/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.tools;

import opale.tools.*;
import java.io.*;
import java.util.*;


/**
* This class make it possible to generate Java program files that contain a data base. It works from two files : the first represents the model of data and the second the data according this model. An exemple is in the package opale.const : we can note the class Element that contains the list of atoms.
* <p> <U>Format of model file </U>:
* <br><code> nameClass
* <br>{
* <br>Field1 "what1" type  
* <br>Field2 "what2" type  
* <br>...  
* <br>}</code>
* <p>
* <code>type</code> is a string that defines the type of the field : STRING, INT or DOUBLE 
* <p> <U>Format of data file </U>:
* <br><code> nameObject1
* <br>{
* <br>valField1  
* <br>valField2 
* <br>...  
* <br>}
* <br>nameObject2
* <br>{
* <br>valField1  
* <br>valField2 
* <br>...  
* <br>}
* <br>...</code>
* @author O.C.
* @date 19/05/2001
* @since Opale-tools 0.13
*/ 


public class OTCG
{
public static void main(String[] arg) throws MalformedFileException
{

if (arg.length != 2)
	{
	System.err.println("Usage : java opale.tools.OTGC file1 file2\n where file1 is the model file and file2 the data file.");
	System.exit(-1);
	}

String modfile = arg[0];
String datafile = arg[1];

System.out.println("model file : "+modfile);
System.out.println("data file : "+datafile);


try
	{
	int type;
	Vector fields = new Vector();
	String nameClass;
	RFile modele = new RFile(modfile);
	modele.slashSlashComments(true);
	
	
	// read the name of the class
	
	System.out.println("Reading the model file...");
	type = modele.nextToken();	
	if ( (type !=StreamTokenizer.TT_WORD)) throw new MalformedFileException("Model file "+modele+" is malformed !!");
	nameClass=modele.sval;
	
	type = modele.nextToken();	
	if ( (type !=StreamTokenizer.TT_WORD) || !modele.sval.equals("{") ) throw new MalformedFileException("Model file "+modele+" is malformed !!");		
	
	type = modele.nextToken();	
	do
	{
	Field tmp = new Field();
	String name,td;
	
//	System.out.println(modele.sval);
	
	name = modele.sval;
	tmp.name=name;
	type = modele.nextToken();
	tmp.description = modele.sval;
	type = modele.nextToken();
	td = modele.sval;
	
		
	if (td.equals( "STRING")) 
		{
		tmp.type = Field.STRING;
		}
	else if (td.equals("INT")) 
		{
		tmp.type = Field.INT;
		}
	else if (td.equals("DOUBLE")) 
		{
		tmp.type = Field.DOUBLE;
		}
	else throw new MalformedFileException("Model file "+modele+" is malformed : unknwon data type !!");
	
	fields.add(tmp);
	type = modele.nextToken();
	}
	while ((type !=StreamTokenizer.TT_WORD) || !modele.sval.equals("}") );
	
	
// Beginning the construction of classes
	System.out.println("Reading the data file...");
	RFile liste = new RFile(datafile);
	Vector val = new Vector(); // value of the fields
	Vector name = new Vector(); // name of the object

	
	type = liste.nextToken();// read the name of the  object	
	do
	{
	
	
	if ( (type !=StreamTokenizer.TT_WORD)) throw new MalformedFileException("List file "+liste+" is malformed !!");
	name.add(new String(liste.sval));
	type = liste.nextToken();	
	if ( (type !=StreamTokenizer.TT_WORD) || !liste.sval.equals("{") ) throw new MalformedFileException("List file "+liste+" is malformed !!");		
	
	for (int i=0;i<fields.size();i++)
	{
	type = liste.nextToken();	
	int  td = ((Field) fields.get(i)).type;
	//System.out.println(td);
	switch (td) 
		{
		case Field.STRING :
			{
			val.add(new String(liste.sval));
			break;
			}
		case Field.INT :
			{
		val.add(new Integer((int) liste.nval));
		break;
			}
		case Field.DOUBLE :
			{
		val.add(new Double(liste.nval));
		break;
			}
		}
	}
	type = liste.nextToken();
	if ( (type !=StreamTokenizer.TT_WORD) || !liste.sval.equals("}") ) throw new MalformedFileException("List file "+liste+" is malformed !!");		
	type = liste.nextToken();
	
	}
	while (type !=StreamTokenizer.TT_EOF );

//	System.out.println(name);
//	System.out.println(fields);
//	System.out.println(val);
	
// Here we can construct the classes
	System.out.println("Writing the file All"+nameClass+"s.java");
	WFile wf = new WFile("All"+nameClass+"s.java");
	wf.writeln("import java.util.*;\n");
	
	wf.writeln("/** \n* This class has been automatically created by the program opale.tools.OTGC. \n*/");
	
	wf.writeln("public class All"+nameClass+"s\n{");

	wf.writeln("private static String[] name = new String["+name.size()+"];");
	wf.writeln("private static  HashMap thefields = new HashMap("+fields.size()+");");
	for (int i=0;i<fields.size();i++)
		{
		Field fi = (Field) fields.get(i);
		wf.writeln("private static Field f"+fi.name+" = new Field(\""+fi.name+"\","+fi.description+","+fi.type+");");
		}

	wf.writeln("\nprivate All"+nameClass+"s() \n{}");
	wf.writeln("\nstatic {");
	for (int i=0;i<name.size();i++)
		wf.writeln("name["+i+"] = new String(\""+name.get(i).toString()+"\");");
	for (int i=0;i<fields.size();i++)
		{
		Field fi = (Field) fields.get(i);
//		wf.writeln(fi.name+".val = new Comparable["+name.size()+"];");
		wf.writeln("f"+fi.name+".val = new Comparable["+name.size()+"];");		
		int  td = fi.type;
		switch (td) 
		{
		case Field.STRING :
			{
			for(int j=i,k=0;j<val.size();j+=fields.size(),k++)
				{
				wf.writeln("f"+fi.name+".val["+k+"] = new String(\""+val.get(j)+"\");");		
				}
			break;
			}
		case Field.INT :
			{
			for(int j=i,k=0;j<val.size();j+=fields.size(),k++)
				{
				wf.writeln("f"+fi.name+".val["+k+"] = new Integer("+val.get(j)+");");		
				}
		break;
			}
		case Field.DOUBLE :
			{
			for(int j=i,k=0;j<val.size();j+=fields.size(),k++)
				{
				wf.writeln("f"+fi.name+".val["+k+"] = new Double("+val.get(j)+");");		
				}
		break;
			}
		}
		wf.writeln("thefields.put(\""+fi.name+"\",f"+fi.name+");");				
		}
	
	wf.writeln("}\n");
	wf.writeln("// search name index.\nprivate static int search(String n)\n{\nfor (int i=0;i<name.length;i++)\n	{\n	if (name[i].equalsIgnoreCase(n)) return i;\n	}\nreturn -1;\n}");
	wf.writeln("\n/** This method permits to get the value of a field for an element.\n* <br>For instance <code>get(\""+name.get(0)+"\",\""+((Field)fields.get(0)).name+"\")</code> returns the value of the field "+((Field)fields.get(0)).name+" for the element "+name.get(0)+".");
	
	
	
	wf.writeln("* <p>The possible names of element are :\n* <UL>");
	for (int i=0;i<name.size();i++)
		wf.writeln("* <LI> "+name.get(i));
	wf.writeln("* </UL>");
	wf.writeln("* <p>The fields of an element are :\n* <UL>");
	for (int i=0;i<fields.size();i++)
		wf.writeln("* <LI> "+((Field)fields.get(i)).name+", "+((Field)fields.get(i)).description);
	wf.writeln("* </UL><p>");
	
	wf.writeln("* @param String the name of an element\n* @param String the name of a field\n* @return the value of the field\n* @throws IllegalArgumentException if the arguments are not valid\n*/");
	wf.writeln("public static  String get(String aname, String afield)\n	{\n	int i = search(aname);\n	Field f = (Field) thefields.get(afield);\n	if(i==-1 || f==null) throw new IllegalArgumentException(\"non valid field!!\");\n	return f.val[i].toString();\n	}");


	wf.writeln("\n/**\n* This method returns an instance of "+nameClass+".");
	wf.writeln("* @param String, the name of an "+nameClass+"\n* @return "+nameClass+", the object \n*/");
	wf.write("public  static "+nameClass+" get"+nameClass+"(String aname)\n	{\n	int i = search(aname);\n	if(i==-1) throw new IllegalArgumentException(\"non valid field!!\");\n	"+nameClass+" obj = new "+nameClass+"(");
	wf.write("name[i], ");
	for (int j=0;j<fields.size();j++)
		{
		Field fi = (Field) fields.get(j);
		int  td = fi.type;
		switch (td) 
		{
		case Field.STRING :
			{
			wf.write("((String) (f"+((Field)fields.get(j)).name+").val[i])");
			break;
			}
		case Field.INT :
			{
			wf.write("((Integer) (f"+((Field)fields.get(j)).name+".val[i])).intValue()");
			break;
			}
		case Field.DOUBLE :
			{
			wf.write("((Double) (f"+((Field)fields.get(j)).name+".val[i])).doubleValue()");
			break;
			}
		}
		if (j == fields.size()-1) wf.write(");");
		else wf.write(", ");
		}
	wf.writeln("\n		return obj;\n	}");

	wf.writeln("\n/**\n* This method returns the number  of "+nameClass+".");
	wf.writeln("* @return int, the size \n*/");
	wf.write("public  static int getSize()\n	{\n	return name.length;\n	}");

	wf.writeln("\n/**\n* This method returns an instance of "+nameClass+".");
	wf.writeln("* @param int, the index of an "+nameClass+"\n* @return "+nameClass+", the object \n*/");
	wf.write("public  static "+nameClass+" get"+nameClass+"(int index)\n	{\n	int i = index;\n	if(i<0 || i>= name.length) throw new IllegalArgumentException(\"no valid index!!\");\n	"+nameClass+" obj = new "+nameClass+"(");
	wf.write("name[i], ");
	for (int j=0;j<fields.size();j++)
		{
		Field fi = (Field) fields.get(j);
		int  td = fi.type;
		switch (td) 
		{
		case Field.STRING :
			{
			wf.write("((String) (f"+((Field)fields.get(j)).name+").val[i])");
			break;
			}
		case Field.INT :
			{
			wf.write("((Integer) (f"+((Field)fields.get(j)).name+".val[i])).intValue()");
			break;
			}
		case Field.DOUBLE :
			{
			wf.write("((Double) (f"+((Field)fields.get(j)).name+".val[i])).doubleValue()");
			break;
			}
		}
		if (j == fields.size()-1) wf.write(");");
		else wf.write(", ");
		}
	wf.writeln("\n		return obj;\n	}");
	
	wf.write("public  static "+nameClass+"[] search(String field,String value)\n	{\n	Field f = (Field) thefields.get(field);\n	if(f==null) throw new IllegalArgumentException(\"non valid field!!\");\n	Vector resu = new Vector();\n	if(f.type == Field.STRING) \n		{\n		for (int i=0;i<name.length;i++)\n			{\n			if (f.val[i].equals(value)) resu.add(All"+nameClass+"s.get"+nameClass+"(i));\n			}\n		}\n	else if(f.type == Field.INT) \n		{\n		for (int i=0;i<name.length;i++)\n			{\n			if ( (((Integer) f.val[i])).equals(new Integer(value)) ) resu.add(All"+nameClass+"s.get"+nameClass+"(i));\n			}\n		}\n	else if(f.type == Field.DOUBLE) \n		{\n		for (int i=0;i<name.length;i++)\n			{\n			if ( (((Double) f.val[i])).equals(new Double(value)) ) resu.add(All"+nameClass+"s.get"+nameClass+"(i));\n			}\n		}");

	wf.writeln("\n	Element[] res = new Element[resu.size()];\n	for(int i=0;i<resu.size();i++) res[i] = (Element) resu.elementAt(i);\n	return res;\n	}");
	wf.writeln("}");

	wf.writeln("\n\nclass Field\n{\nfinal static int STRING=1, INT=2, DOUBLE=3;\n\npublic String name;\npublic String description;\npublic int type;\npublic Comparable[] val;\n\npublic Field(String n, String d, int t)\n	{\n	name = new String(n);\n	description =  new String(d);\n	type = t;\n	}\n\npublic String toString()\n	{\n	return name+\" \"+description+\" \"+type;\n	}\n\n}\n\n");



	wf.close();
	
	
	
// Now we construct the last class
	System.out.println("Writing the file "+nameClass+".java");
	wf = new WFile(nameClass+".java");
	wf.writeln("import java.util.*;\n");
	
	wf.writeln("/** \n* This class has been automatically created by the program opale.tools.OTGC. \n*/");
	
	wf.writeln("public class "+nameClass+"\n{");
	wf.writeln("private String name;");		
	for (int i=0;i<fields.size();i++)
		{
		Field fi = (Field) fields.get(i);
		int  td = fi.type;
		switch (td) 
		{
		case Field.STRING :
			{
			wf.writeln("private String f"+fi.name+";");		
			break;
			}
		case Field.INT :
			{
			wf.writeln("private int f"+fi.name+";");		
		break;
			}
		case Field.DOUBLE :
			{
			wf.writeln("private double f"+fi.name+";");		
		break;
			}
		}
		}

	// a constructor
	wf.writeln("\npublic "+nameClass+"() \n{");
	wf.writeln("name =\"\";");		
	for (int i=0;i<fields.size();i++)
		{
		Field fi = (Field) fields.get(i);
		int  td = fi.type;
		switch (td) 
		{
		case Field.STRING :
			{
			wf.writeln("f"+fi.name+"=\"\";");		
			break;
			}
		case Field.INT :
			{
			wf.writeln("f"+fi.name+"=0;");		
		break;
			}
		case Field.DOUBLE :
			{
			wf.writeln("f"+fi.name+"=0.;");		
		break;
			}
		}
		}
	wf.writeln("}");

	// an another constructor
	wf.write("\npublic "+nameClass+"(String name, ");
	for (int i=0;i<fields.size();i++)
		{
		Field fi = (Field) fields.get(i);
		int  td = fi.type;
		switch (td) 
		{
		case Field.STRING :
			{
			wf.write("String "+fi.name+((i == fields.size()-1) ? "" : ", "));		
			break;
			}
		case Field.INT :
			{
			wf.write("int "+fi.name+((i == fields.size()-1) ? "" : ", "));		
		break;
			}
		case Field.DOUBLE :
			{
			wf.write("double "+fi.name+((i == fields.size()-1) ? "" : ", "));		
		break;
			}
		}
		}
	wf.writeln(")");
	wf.writeln("{");
	wf.writeln("this.name = name;");		
	for (int i=0;i<fields.size();i++)
		{
		Field fi = (Field) fields.get(i);
		int  td = fi.type;
		switch (td) 
		{
		case Field.STRING :
			{
			wf.writeln("this.f"+fi.name+"="+fi.name+";");		
			break;
			}
		case Field.INT :
			{
			wf.writeln("this.f"+fi.name+"="+fi.name+";");		
		break;
			}
		case Field.DOUBLE :
			{
			wf.writeln("this.f"+fi.name+"="+fi.name+";");		
		break;
			}
		}
		}
	wf.writeln("}\n");
	
	//methods
	for (int i=0;i<fields.size();i++)
		{
		Field fi = (Field) fields.get(i);
		int  td = fi.type;
		switch (td) 
		{
		case Field.STRING :
			{
			wf.writeln("public String get"+fi.name+"() { return this.f"+fi.name+ ";};");		
			break;
			}
		case Field.INT :
			{
			wf.writeln("public int get"+fi.name+"() { return this.f"+fi.name+ ";};");				break;
			}
		case Field.DOUBLE :
			{
			wf.writeln("public double get"+fi.name+"() { return this.f"+fi.name+ ";};");		
		break;
			}
		}
		}

	wf.writeln("public String toString() { return name; }\n");		
	wf.writeln("public String toLongString()\n	{\n	StringBuffer s=new StringBuffer(name);");
	for (int i=0;i<fields.size();i++) 		
		{
		Field fi = (Field) fields.get(i);
		wf.writeln("	s.append(\"	"+fi.name+" = \" + this.f"+fi.name+"\n);");
		}
	wf.writeln("	return s.toString();\n	}\n");
	wf.writeln("}");

	wf.close();
	
	}
catch (IOException evt)
	{
	System.err.println(evt);
	}
	
}

	

}	
	
	
