/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.tools;
import java.util.*;
import java.io.*;

/**
* This class represents a group of Opale object. It makes it possible to store these objects attributing them an identificator and it is also possible to read/write them in a stream.
* @author O.C.
* @since Opale-tools 0.14 (OpaleV1b5)
*/
public class OpaleSet
{
private HashMap obj;
private HashMap prior;
private  HashMap objectName,userName; 	//liste des correspondances entre noms des classes des objets et leurs noms utilisateurs ncssaires pour la lecture/ecriture des fichiers de donnes.

/**
* Construct a new OpaleSet.
*/
public OpaleSet()
	{
	if (Debug.On) Stdio.printerrln("New OpaleSet");
	obj = new HashMap();
	
	objectName = new HashMap();
	userName = new HashMap();
	prior = new HashMap();
	int type;
	String nomClasse="", nomUser="";
	
	try
	{
	java.io.InputStream in = getClass().getResourceAsStream("/opale/tools/name_object.rsc");
	StreamTokenizer rf=null;
	if (in != null)
		{
		java.io.Reader r = new java.io.BufferedReader(new java.io.InputStreamReader(in));
		rf = new StreamTokenizer(r);
		}
	else
		{
		System.err.println("File name_object.rsc not found.");
		System.err.println("Stop.");
		System.exit(-1);
		}
	rf.wordChars(33,255);
	type = rf.nextToken();
	while(type != StreamTokenizer.TT_EOF)
		{
		if (type == StreamTokenizer.TT_NUMBER)
			nomClasse = Double.toString(rf.nval);
		else if (type == StreamTokenizer.TT_WORD)
			nomClasse = rf.sval;
		type = rf.nextToken();
		if (type == StreamTokenizer.TT_NUMBER)
			nomUser = Double.toString(rf.nval);
		else if (type == StreamTokenizer.TT_WORD)
			nomUser = rf.sval;
		else if (type == StreamTokenizer.TT_EOF)
			{
			System.err.println("Error reading file of configuration.\n Stop.");
			System.exit(-1);
			}
		type = rf.nextToken();
		if (type != StreamTokenizer.TT_NUMBER)
			{
			System.err.println("Error reading file of configuration.\n Stop.");
			System.exit(-1);
			}
		else 
			{
			prior.put(nomClasse,new Double(rf.nval));
			}
					
		objectName.put(nomUser,nomClasse);
		userName.put(nomClasse,nomUser);
		type = rf.nextToken();
		}
	}
	catch(java.io.IOException e)
		{
		System.err.println("Error reading file of configuration.\n Stop.");
		System.err.println(e);
		System.exit(-1);
		}
	if (Debug.On) System.err.println(objectName);
	if (Debug.On) System.err.println(userName);
	if (Debug.On) System.err.println(prior);
	
	
	}

/**
* Add a new Opale object. If the object hasn't an identificator (<code>setId</code> in the class OpaleObject) then this method throw an instance of the runtime exception <code> InvalidIdException</code>.
* @param OpaleObject, the object to add.
*/
public void add(OpaleObject o) 
        {
        if (o.getId()==null) throw new InvalidIdException("An Opale object must have an identificator before to be added in an Opale set !!!");
	obj.put(o.getId(),o);
        }

/**
* Add a new Opale object specifying its id. If the id specified is null then this method throw an instance of the runtime exception <code> InvalidIdException</code>. If the object has already an id, it is added with its id.
* @param OpaleObject, the object to add.
* @param String, its id.
*/
public void add(OpaleObject o,String id) 
        {
        if (id==null) throw new InvalidIdException("An Opale object must have a non null identificator !!!");
	o.setId(id);
	obj.put(o.getId(),o);
        }

    /**
* Removes all the Opale objects of this set.
*/
public void clear() { obj.clear(); }


/**
* Returns the number of objects.
* @return int
*/
public int size() { return obj.size(); }


/**
* Removes the element with the id specified
* @param String
*/
public void remove(String id) { obj.remove(id); }

/**
* Returns a collection of the all objects contained in the current instance.
* @return Collection
*/
public Collection objects() { return obj.values(); }


/**
*
*/
public OpaleObject getObject(String id)
        {
        return (OpaleObject) obj.get(id);
	}

/**
*/
public boolean contains(OpaleObject o)
        {
        return obj.containsValue(o);
        }

/**
*
*/
public boolean contains(String id)
        {
        return obj.containsKey(id);
        }

/**
* Returns true id this set does not contain objects.
* @return boolean
*/
public boolean isEmpty()
	{
	return obj.isEmpty();
	}
	

/**
* Renvoie un tableau de String qui contient tous les noms utilisateurs des
objets.
* @return String[] le tableau de noms.
*/
public String[] getUserNameObject()
	{
	Object[] lobj = objectName.keySet().toArray();
	String[] list = new String[objectName.size()];
	int i;
	
	for (i=0;i<objectName.size();i++)
		list[i] = (String) lobj[i];
	return list;
	}
	/**
* Renvoie le nom de la classe d'un objet  OpaleObject  partir de son nom
utilisateur.
* @return String le nom de la classe.
* @param String le nom utilisateur.
*/ 	
public String getNameObject(String username)
	{
	return (String) objectName.get(username);
	}
	
	
/**
* Renvoie le nom utilisateur d'une classe d'un objet Object  partir de son
nom de classe en Java.
* @param String le nom de la classe.
* @return String le nom utilisateur.
*/ 	
public String getUserName(String objname)
	{
	return (String) userName.get(objname);
	}



/**
* Reads a set of  Opale objects in a stream.
* @param StreamReader f, a StreamReader object to read.
*/
public void read(StreamReader f) throws InvalidFormatException
	{
	int type;
	String sval="";
	Stdio.println("Reading the stream : "+f);
	
	try
	{

	while (f.hasMoreTokens())
		{
		sval = f.next();
			Stdio.println("->> Read an object of type "+sval+".");
			if (getNameObject(sval)== null) throw new InvalidFormatException("Unknown type "+sval+" !!!");
			OpaleObject ob =  (OpaleObject) Class.forName(getNameObject(sval)).newInstance();
			String id = f.next();	//on lit l'id
			if (Debug.On) Debug.print("id = ",id);
			ob.setId(id);
			ob.read(f,this);
			this.add(ob);
			Stdio.println("->> End of reading an object.");
			//if (Debug.On) Debug.print("End tokens ? "+f.hasMoreTokens());
		}
		

	}
	catch (java.io.IOException e)
	{
	System.err.println("Error reading the file " + f);
	System.err.println(e);
	System.exit(-1);
	}	
	catch(ClassNotFoundException exc)
	{
	throw new InvalidFormatException("Error reading an object of type "+sval+" : the class does not exist.");
	}
	catch(IllegalAccessException exc)
	{
	throw new InvalidFormatException("Error reading an object of type "+sval+" : access to the class not possible.");
	}
	catch(InstantiationException exc)
	{
	throw new InvalidFormatException("Error reading an object of type "+sval+" : class not instantiable.");
	}
	}
	


/**
* Write the objects contained in this class.
* @param PrintWriter f, a stream.
*/
public void write(PrintWriter f) throws InvalidFormatException
	{
	if (isEmpty())
		{
		throw new IllegalArgumentException("No objects to write !!!");
		} 
//	int i;



	Comparator comp = new Comparator()
		{
		public int compare(Object o1, Object o2)
			{
			OpaleObject op1 = (OpaleObject) o1;
			OpaleObject op2 = (OpaleObject) o2;
			double p1 = ((Double)prior.get(op1.getClass().getName())).doubleValue();
			double p2 = ((Double)prior.get(op2.getClass().getName())).doubleValue();
			if (p1 < p2 )
				return -1;
			else if (p1 == p2 )
				return 0;
			else return 1;
			
			}
		
		};


	OpaleObject[]  opobj = (OpaleObject[]) this.objects().toArray(new OpaleObject[0]);
	for (int i = 0;i<opobj.length;i++)
		if (getUserName(opobj[i].getClass().getName())== null) throw new InvalidFormatException("Unknown type "+opobj[i].getClass().getName()+" !!!");
	Arrays.sort(opobj,comp);

	
	for (int i = 0;i<opobj.length;i++)
		{
		if (getUserName(opobj[i].getClass().getName())== null) throw new InvalidFormatException("Unknown type "+opobj[i].getClass().getName()+" !!!");
		f.print(getUserName(opobj[i].getClass().getName())+" ");
		f.println(opobj[i].getId());
		Stdio.println("Writing an Opale object : "+opobj[i].getClass().getName());
		opobj[i].write(f,this);
		f.println("");
		}	
	}

    /**
     * Write in a specified file the contains of this OpaleSet.
     * @param String name, the name of the file
     */
    public void writeInFile(String name) throws
    InvalidFormatException, FileNotFoundException, IOException {
	FileOutputStream fo = new FileOutputStream(name);
	PrintWriter f = new PrintWriter(fo);
	this.write(f);
	f.close();
	fo.close();
    }


private int jump(StreamTokenizer f) throws InvalidFormatException
	{
	try
	{
	Stack pile = new Stack();
	int type;
	
	type = f.nextToken();	//on lit une '{' en principe...
	if (Debug.On) Debug.print(f.sval);
	if ( (type !=StreamTokenizer.TT_WORD) || (!f.sval.equals("{")) ) throw new InvalidFormatException("Syntax error : '{' expected !!");
	pile.push("{");
	type = f.nextToken();	
	while ( (!pile.empty()) && (type != StreamTokenizer.TT_EOF))
		{
		if ( (type == StreamTokenizer.TT_WORD) && (f.sval.equals( "{")) ) 
			{
			if (Debug.On) Debug.print(" > We push {");
			pile.push("{");
			}
		else if	 ( (type == StreamTokenizer.TT_WORD) && (f.sval.equals( "}")) )
			{
			if (Debug.On) Debug.print(" > Pop }");
			if (pile.empty()) throw new InvalidFormatException(" Syntax error : '{' expected !!!");
			else 
				{
				String s = (String) pile.pop();
				if (!s.equals("{"))  throw new InvalidFormatException(" Syntax error : '{' expected !!!");
				}
			}
			
		type = f.nextToken();
		}
	
	if (Debug.On) Debug.print("Stack at the end : "+pile);
	return type;
	}
	catch (java.io.IOException e)
	{
	System.err.println("Error reading the file " + f);
	System.err.println(e);
	System.exit(-1);
	}
	return 0;	
	}

public void check()
	{
        System.err.println("Check OpaleSet : ");
        System.err.println(" "+obj);
	}	



}

