/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.tools;
import java.io.*;
import java.util.*;

/**
 * This class extends BufferedReader and makes it possible to read words and flottants in a Reader instance.
* @since Opale-Tools 0.16
*/

public class StreamReader extends BufferedReader
{
private String stemp;
private StringTokenizer st;

public StreamReader(Reader r)
	{
	super(r);
	}

public StreamReader(Reader r, int sz)
	{
	super(r,sz);
	}

/**
 * Opens a StreamReader from a file.
 * @param String the name of a file
 */
public StreamReader(String name) throws IOException
	{
	super(new FileReader(name));
	}


/**
 * Return the next word in the stream or null if there are no words to read.
 * @return String
 */
public String next() throws IOException
	{
	if (st!=null)
		if (st.hasMoreTokens())
			return st.nextToken();
	else
		{
		stemp = readLine();
		if (stemp == null) return null;
		
		
	
		st = new StringTokenizer(stemp);
		return next();
		//else  return null;
		}
	
	return null;
	
	}

public boolean hasMoreTokens() throws IOException
	{
	if (st!=null)
		{
		if (st.hasMoreTokens()) return true;
		}
	stemp = readLine();
	if (stemp == null) return false;
	/*
	Debug.print("chaine lu = "+stemp);
	while(stemp.equals(""))
		{
		stemp = readLine();
		if (Debug.On) Debug.print("chaine lu = "+stemp);
		if (stemp == null) return false;
		}
	*/
	st = new StringTokenizer(stemp);
	return hasMoreTokens();
	
	
	}


/**
 * Return the next double in the stream. If there are not double number to read then an InvalidFormatException exception is thrown.
 * @return double
 * @throws InvalidFormatException if the stream does not contain double to read. 
 */
public double nextDouble() throws InvalidFormatException, IOException
	{
	String s = next();
	try
	{
	if (s==null)	throw new InvalidFormatException("Invalid format stream : no double to read !!!");
	Double d = new Double(s);
	return d.doubleValue();
	}
	catch (NumberFormatException evt)
	{
	throw new InvalidFormatException("Invalid format stream : "+s+" is not a double !!!");
	}
	
	}


/**
 * Return the next integer in the stream. If there are not integer number to read then an InvalidFormatException exception is thrown.
 * @return double
 * @throws InvalidFormatException if the stream does not contain integer to read. 
 */
public int nextInteger() throws InvalidFormatException, IOException
	{
	String s = next();
	try
	{
	if (s==null)	throw new InvalidFormatException("Invalid format stream : no integer to read !!!");
	Integer d = new Integer(s);
	return d.intValue();
	}
	catch (NumberFormatException evt)
	{
	throw new InvalidFormatException("Invalid format stream : "+s+" is not an integer !!!");
	}
	
	}




}//throw new InvalidFormatException("Invalid format stream : no word to read !!!");
