<?
/*
 *   This file is part of PhpCompta.
 *
 *   PhpCompta is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   PhpCompta is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with PhpCompta; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/* $Revision: 1.23 $ */
// Copyright Author Dany De Bontridder ddebontridder@yahoo.fr

/*! \file
 * \brief This class is used to create all the HTML INPUT TYPE
 */

/*!
 * \brief class widget This class is used to create all the HTML INPUT TYPE
 *        and some specials which works with javascript like 
 *        js_search.
 * special value 
 *    js_search and js_search_only :you need to add a span widget the name
 *    of the js_* widget + '_label' , the member extra contains cred,deb to 
 *    filter the search of cred of deb of a jrn or contains a string with 
 *    a list of frd_id.
 *    Possible type 
 *    $type 
 *      - TEXT 
 *      - HIDDEN
 *      - SELECT
 *      - PASSWORD
 *      - CHECKBOX
 *      - RADIO
 *      - TEXTAREA
 *      - RICHTEXT
 *      - FILE
 *      - JS_SEARCH_POSTE  call a popup window for searching the account
 *      - JS_SEARCH call a popup window for searching a quickcode or to add one
 *      - JS_SEARCH_ONLY like JS_SEARCH but without adding a quickcode
 *      - SPAN
 *      - JS_TVA        open a popup window for the VAT
 *      - JS_CONCERNED  open a popup window for search a operation
 *
 *    For JS_SEARCH_POST,JS_SEARCH or JS_SEARCH_ONLY
 *     - $extra contains 'cred', 'deb', 'all' or a list of fiche_def_ref (frd_id) 
 *           to filter the search/add for the card
 *        
 *     - $extra2 filter on the card parameter, which are given in Avance->journaux menu, 
 *            it is the journal id. If empty, there is no link with a ledger
 *
 */
class widget {
  /*! \enum $type type of the input tag (text, select, files, js_search,...)
   * \enum  $name name of the input tag
   * \enum   $value value 
   * \enum   $readonly if set to false cannot modify
   * \enum   $size size for the text type
   * \enum   $selected selected value for the radio or select
   * \enum   $table if we want to make a HTML table row the value is return with &lt;TD&gt;
   * \enum   $label text before the input tag
   * \enum   $disabled to disable the type
   * \enum   $extra depends of the input type
   * \enum   $extra2 depends of the input type
   * \enum   $tabindex the tabindex
   * \brief
   */

  var $type;                      /*! \enum $type type of the widget */
  var $name;                      /*! \enum $name field NAME of the INPUT */    
  var $value;                     /*! \enum $value what the INPUT contains */
  var $readonly;                  /*! \enum $readonly true : we cannot change value */
  var $size;                      /*! \enum $size size of the input */
  var $selected;                  /*! \enum $selected for SELECT RADIO and CHECKBOX the selected value */
  var $table;                     /*! \enum $table =1 add the table tag */
  var $label;                     /*! \enum $label the question before the input */
  var $disabled;                  /*! \enum $disabled poss. value == true or nothing, to disable INPUT*/
  var $extra;                     /*! \enum $extra different usage, it depends of the $type */
  var $extra2;                    /*! \enum $extra2 different usage, it depends of the $type */
  var $tabindex; 
  function widget($p_type="") {
    $this->type=$p_type;
    $this->readonly=false;
    $this->size=20;
    $this->width=50;
    $this->heigh=20;
    $this->value="";
    $this->selected="";
    $this->table=0;
    $this->label="";
    $this->disabled=false;
    $this->tabindex=32767;
  }
  function SetReadOnly($p_read) {
    $this->readonly=$p_read;
  }
  /*!  function IOValue($p_name,$p_value="",$p_label="") 
   *****************************************************
   * \brief  create the corresponding INPUT tag 
   *        
   *  \param $p_name is the INPUT NAME
   * \param         $p_value is the INPUT VALUE or an array for select
   * \param         $p_label is the label of the INPUT
   *  \return  string containing the tag
   */
  function IOValue($p_name=null,$p_value=null,$p_label="") {
    
    if ( $p_name != null)
      $this->name=$p_name;
    $this->value=($p_value===null)?$this->value:$p_value;
    $this->label=($p_label == "")?$this->label:$p_label;
    
    // Input text type
    $disabled = $this->disabled ? "DISABLED" : "";
    if (strtoupper($this->type)=="TEXT") {
      if ( $this->readonly==false) {
	$r="<INPUT style=\"border:solid 1px blue;\" TYPE=\"TEXT\" NAME=\"$this->name\" VALUE=\"$this->value\" TABINDEX=\"$this->tabindex\" SIZE=\"$this->size\" ".$disabled.">";} else {
	    $r=sprintf('<span>%s</span><input type="hidden" name="%s" value="%s">', $this->value,$this->name,$this->value);
	}
	
      if ($this->table==1) {
	if ( $this->label != "") {
	  $r="<TD  style=\"border:groove 1px blue;\">".$this->label."</TD><TD>".$r."</TD>";
	}else {
	  $r="<TD>".$r."</TD>";
	}
      }
      return $r;
    }
    // Hidden field
    if (strtoupper($this->type)=="HIDDEN") {
      $r='<INPUT TYPE="HIDDEN" name="'.$this->name.'" value="'.$this->value.'">';
      if ( $this->readonly==true) return "";
      return $r;
    }
    // Select value
    if ( strtoupper($this->type) == "SELECT") {
      if ($this->readonly==false )
	{
	  //echo "<b>Selected <b>".$this->selected;
	  $r="<SELECT  NAME=\"$this->name\">";
	  for ( $i=0;$i<sizeof($this->value);$i++) 
	    {
	      $checked=($this->selected==$this->value[$i]['value'])?"SELECTED":"";
	      $r.='<OPTION VALUE="'.$this->value[$i]['value'].'" '.$checked.'>';
	      $r.=$this->value[$i]['label'];
	    }
	  $r.="</SELECT>";
	} else 
	  {
	    $r="";
	    echo_debug('class_widget.php',__LINE__,"this->selected = ".$this->selected); 
	    for ( $i=0;$i<sizeof($this->value);$i++) 
	      {
		echo_debug('class_widget.php',__LINE__,"check for ".$this->value[$i]['value']);
		if ($this->selected==$this->value[$i]['value'] ) 
		  {
		    $r=$this->value[$i]['label'];
 	
		  }
	      }
	  }
      if ( $this->table==1) {
	$r="<TD> $r </TD>";
	if ( $this->label != "") $r="<TD> $this->label</TD>".$r;
      }
      return $r;
    }
    // Password
    if (strtoupper($this->type)=="PASSWORD") {
      if ( $this->readonly==true) return "";
      $r='<input type="password" name="'.$this->name;
      $r.='">';
      if ($this->table==1) {
	$r="<TD> $this->label </TD><TD> $r </TD>";
      }
      return $r;
    }

    // Checkbox
    if (strtoupper($this->type)=="CHECKBOX") {
      if ( $this->readonly == true) {
	$check=( $this->selected==true )?"checked":"unchecked";
	$r='<input type="CHECKBOX" name="'.$this->name.'"';
	$r.="  $check";
	$r.=' disabled>';

      } else {
	$check=( $this->selected==true )?"checked":"unchecked";
	$r='<input type="CHECKBOX" name="'.$this->name.'"';
	$r.="  $check";
	$r.=' '.$disabled.'>';
      }
      if ($this->table==1) {
	$r="<TD> $this->label </TD><TD> $r </TD>";
      } else {
	$r=$r." $this->label";
      }
      return $r;
    }

    //radio
    if (strtoupper($this->type)=="RADIO") {
      if ( $this->readonly == true) {
	$check=( $this->selected==true || $this->selected=='t' )?"Yes":"no";
	$r=$check;
      } else {
	$check=( $this->selected==true||$this->selected=='t' )?"checked":"unchecked";
	$r='<input type="RADIO" name="'.$this->name.'"';
	$r.=" VALUE=\"$this->value\"";
	$r.="  $check";
	$r.=' '.$disabled.'>';
      }
      if ($this->table==1) {
	$r="<TD> $this->label </TD><TD> $r </TD>";
      } else {
      	$r=$this->label.$r;
      }
      return $r;
    }

    //textarea
    if (strtoupper($this->type)=="TEXTAREA") {
      if ( $this->readonly == false ) {
	$r="";
	$r.='<TEXTAREA name="'.$this->name.'"';
	$r.=" rows=\"$this->heigh\" ";
	$r.=" cols=\"$this->width\" ";
	$r.=' '.$disabled.'>';
	$r.=$this->value;

	$r.="</TEXTAREA>";
      } else {
	$r='<p>';
	$r.=$this->value;
	$r.=sprintf('<input type="hidden" name="%s" value="%s">',
		    $this->name,urlencode($this->value));
	$r.='</p>';

      }
      if ($this->table==1) {
	$r="<TD> $this->label </TD><TD> $r </TD>";
      }
      return $r;
    }

    //----------------------------------------------------------------------

    //----------------------------------------------------------------------
    // Rich Text
    /*!\brief
     * \note for the type RICHTEXT we need to include the javascript file
     *       into the head \see commercial.php html_page_start($_SESSION['g_theme'],"","richtext.js");
     */

    if ( strtoupper($this->type)=='RICHTEXT')
      {
	    $r= ' <script language="JavaScript" type="text/javascript"> '.
	      '<!-- '."\n".
	      "\nfunction submitForm() {\n".
	      " updateRTE('".$this->name."');\n ".
	      " return true; \n".
	      "} \n".
	      'initRTE("images/", "", "");'."\n".
	      '//-->'."\n".
	      '</script>'.
	      '<noscript><p><b>Javascript must be enabled to use this form.</b></p></noscript>'.
	      'Note Interne : '.
	      '<script language="JavaScript" type="text/javascript">'."\n".
	      '<!--'."\n";
	      //Usage: writeRichText(fieldname, html, width, height, buttons, readOnly)

	    echo_debug('class_widget',__LINE__,'to write is '.$this->name);
	    /*\! brief 
	     *\note the value must be urlencoded
	     */
	    //  Removing new line
	    
	    //	    $msg=urlencode($this->value);
	    $msg=$this->value;
	    $msg=str_replace("%OA","",$msg);
	    $msg=str_replace("%OD","",$msg);
	    $msg=str_replace("\n","",$msg);
	    $msg=str_replace("\r","",$msg);

	    $read=($this->readonly==false)?"false":"true";	    


	    $r.=sprintf(" writeRichText('%s','%s',%d,%d,true,%s);\n",
			$this->name,
			$msg,
			$this->width,
			$this->heigh, 
			$read);
	    $r.= "\n//-->".
	      "</script>";
	    echo_debug ('class_widget',__LINE__,"writeRichText '$r'");

	    return $r;
	  
      }

    //----------------------------------------------------------------------
    //file
    if (strtoupper($this->type)=="FILE") {
      if ( $this->readonly == false ) {
	$r='<INPUT TYPE="file" name="'.$this->name.'" VALUE="'.$this->value.'">';

      }
      if ( $this->table==1) $r="<TD>$this->label</TD><TD>$r</TD>"; 
      return $r;
    }
  // input type == js_search_poste => button search for the account
    if ( strtolower($this->type)=="js_search_poste") {
     
      $l_sessid=$_REQUEST['PHPSESSID'];
      if ( $this->readonly == false ) {
      // Do we need to filter ??
      if ( $this->extra2 == null ) {
      $r=sprintf('<TD>
         <INPUT TYPE="button" onClick=SearchPoste(\'%s\',\'%s\',\'%s\') value="Search">
            %s</TD><TD> 

             <INPUT   TYPE="Text" NAME="%s" VALUE="%s" SIZE="8">
                 </TD>',
		 $l_sessid,
		 $this->name,
		 $this->extra,
		 $this->label,
		 $this->name,
		 $this->value 
		 );

    } else { // $p_list is not null, so we have a filter
      $r=sprintf('<TD>
         <INPUT TYPE="button" onClick=SearchPosteFilter(\'%s\',\'%s\',\'%s\',\'%s\') value="Search">
            %s</TD><TD> 

             <INPUT TYPE="Text" NAME="%s" VALUE="%s" SIZE="8">
                 </TD>',
		 $l_sessid,
		 $this->name,
		 $this->extra2,
		 $this->extra,
		 $this->label,
		 $this->name,
		 $this->value 
		 );

      } //else
      } else {
      $r=sprintf('<TD><input type="hidden" name="%s" value="%s">
                  %s

                 </TD>',
		 $this->name, 
		 $this->value ,
		 $this->value 
		 );

      } //else if readonly == true
      return $r;

    } // end js_search_poste

  // input type == js_search => button search for card
  if ( strtolower($this->type)=="js_search") {
    $l_sessid=$_REQUEST['PHPSESSID'];
    if  ( $this->readonly == false ) {
      $r=sprintf('<TD>
         <INPUT TYPE="button" onClick=NewCard(\'%s\',\'%s\',\'%s\',\'%s\') value="New">
         </TD><TD>
         <INPUT TYPE="button" onClick=SearchCard(\'%s\',\'%s\',\'%s\',\'%s\') value="Search">
            %s <INPUT TYPE="Text"    NAME="%s" VALUE="%s" SIZE="8" TABINDEX="%s">
                 ',
	       $l_sessid,
	       $this->extra, // deb or cred
	       $this->name,
	       $this->extra2, //jrn
	       $l_sessid,
	       $this->extra,
	       $this->name,
	       $this->extra2,
	       $this->label,
	       $this->name,
	       $this->value, 
         $this->tabindex
	       );
    } else {
      // readonly == true
      $r=sprintf('<TD>            %s</TD>
                 <TD> 
                 <INPUT TYPE="hidden" NAME="%s" VALUE="%s" SIZE="8">
                 </TD>',
	       $this->label,
	       $this->name,
	       $this->value 
		 );

    }
    return $r;
  }// poste==js_search


  // input type == js_search => button search for card
  /*!\brief js_search_only only for searching a card no new button
   */
  if ( strtolower($this->type)=="js_search_only") {
    $l_sessid=$_REQUEST['PHPSESSID'];
    if  ( $this->readonly == false ) {
      if ( $this->table==1)
	{
	  $r=sprintf('<TD>
         <INPUT TYPE="button" onClick=SearchCard(\'%s\',\'%s\',\'%s\',\'%s\') value="QuickCode">
            %s</TD><TD> <INPUT TYPE="Text" NAME="%s" VALUE="%s" SIZE="8" TABINDEX="%s">
                 ',
	       $l_sessid,
	       $this->extra,
	       $this->name,
	       $this->extra2,
	       $this->label,
	       $this->name,
	       $this->value, 
         $this->tabindex
	       );
	}
      else
	{
	  $r=sprintf('
         <INPUT TYPE="button" onClick=SearchCard(\'%s\',\'%s\',\'%s\',\'%s\') value="QuickCode">
            %s <INPUT TYPE="Text" NAME="%s" VALUE="%s" SIZE="8" TABINDEX="%s">           ',
	       $l_sessid,
	       $this->extra,
	       $this->name,
	       $this->extra2,
	       $this->label,
	       $this->name,
	       $this->value, 
	       $this->tabindex
	       );
	}
    } else {
      // readonly == true
      if ( $this->table == 1 )
	{
	
	  $r=sprintf('<TD>            %s</TD>
                 <TD> %s
                 <INPUT TYPE="hidden" NAME="%s" VALUE="%s" SIZE="8">
                 ',
	       $this->label,
		     $this->value, 
	       $this->name,
		     $this->value 
		     );
	}
      else {
	// readonly == true and table == 0
	$r=sprintf('%s',
	       $this->value
	       );

      }

    }
    return $r;
  }// poste==js_search_only





  // type=span
  if ( strtolower($this->type)=="span") {
    $r=sprintf('<span id="%s"  >%s </span>',
	       $this->name,
	       $this->value
	       );

    return $r;
  }// end type = span

   // input type == js_tva
   if ( strtolower($this->type)=="js_tva") {
     $id=sprintf("<span id=%s></span>",$this->label);
        $r=sprintf('%s<TD> <INPUT TYPE="Text" NAME="%s" VALUE="%s" SIZE="3" onChange="ChangeTVA(\'%s\',\'%s\');">',
 		  $id,
 	       $this->name,
 	       $this->value,
 	       $this->label,
 	       $this->name);
     $l_sessid=$_REQUEST['PHPSESSID'];
     $r.=sprintf("<input type=\"button\" value=\"Tva\" 
     	onClick=\"
        	           ShowTva('%s','%s');\"></TD>",
 		$l_sessid,$this->name);
     return $r;
   }

  // input type == js_concerned => button search for the concerned operations
  if ( strtolower($this->type)=="js_concerned") {
    if ( $this->readonly == false) {
      $l_sessid=$_REQUEST['PHPSESSID'];
      $r=sprintf('<TD>
         <INPUT TYPE="button" onClick=SearchJrn(\'%s\',\'%s\') value="Search">
            %s</TD><TD> 

             <INPUT TYPE="Text" NAME="%s" VALUE="%s" SIZE="8">
                 </TD>',
		 $l_sessid,
		 $this->name,
		 $this->label,
		 $this->name,
		 $this->value 
		 );
    } else {
      $r=sprintf("<TD><span>%s</span>",$this->value);
      $r.=sprintf('<input type="hidden" name="%s" value="%s"></TD>', $this->name,$this->value);
    }

    return $r;
  }// end js_concerned
  return "INVALID WIDGET $this->type ";
  } //end function
  /* Debug
   */
  function debug() {
    echo "Type ".$this->type."<br>";
    echo "name ".$this->name."<br>";
    echo "value". $this->value."<br>";
    $readonly=($this->readonly==false)?"false":"true";
    echo "read only".$readonly."<br>";
  }
  function Submit ($p_name,$p_value) {
    return '<INPUT TYPE="SUBMIT" NAME="'.$p_name.'" VALUE="'.$p_value.'">';
  }
  function Reset ($p_value) {
    return '<INPUT TYPE="SUBMIT"  VALUE="'.$p_value.'">';
  }

}
