/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.DeviceCommandRequest;
import org.nongnu.pulsefire.device.DeviceConnectListener;
import org.nongnu.pulsefire.device.DeviceData;
import org.nongnu.pulsefire.device.DeviceDataListener;
import org.nongnu.pulsefire.device.DeviceWireManager;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;
import org.nongnu.pulsefire.wire.CommandNameVersionFactory;

public abstract class AbstractDeviceWireManager
implements DeviceWireManager {
    protected Logger logger = null;
    protected Queue<DeviceCommandRequest> sendCommandQueue = new LinkedBlockingQueue<DeviceCommandRequest>();
    protected Map<CommandName, List<DeviceCommandListener>> commandListeners = null;
    protected List<DeviceDataListener> dataListeners = null;
    protected List<DeviceConnectListener> connectListeners = null;
    protected int deviceVersion = 0;
    protected int connectProgress = 0;
    protected String connectPhase = null;
    protected DeviceData deviceData = null;

    public AbstractDeviceWireManager() {
        this.logger = Logger.getLogger(AbstractDeviceWireManager.class.getName());
        this.commandListeners = new HashMap<CommandName, List<DeviceCommandListener>>(20);
        this.dataListeners = new ArrayList<DeviceDataListener>(3);
        this.connectListeners = new ArrayList<DeviceConnectListener>(30);
        this.deviceData = new DeviceData();
    }

    @Override
    public void disconnect() {
        this.deviceData.createParameters();
        this.connectProgress = 0;
        this.sendCommandQueue.clear();
        if (this.isConnected()) {
            this.fireSerialConnect(false);
            this.deviceVersion = 0;
        }
    }

    protected boolean doSafeConnect(DeviceCommandRequest infoChip) {
        if (infoChip.getResponse() == null) {
            this.disconnect();
            this.logger.info("Could not request info_chip");
            this.connectPhase = "Err on info_chip";
            return false;
        }
        Command version = this.getDeviceData().getDeviceParameter(CommandName.chip_version);
        if (version == null) {
            this.disconnect();
            this.logger.warning("Could not get " + CommandName.chip_version.name());
            this.connectPhase = "Err on " + CommandName.chip_version.name();
            return false;
        }
        int deviceVersion = new Double(Double.parseDouble(version.getArgu0()) * 10.0).intValue();
        this.logger.info("Chip version: " + deviceVersion);
        if (!CommandNameVersionFactory.configCommandName((int)deviceVersion)) {
            this.disconnect();
            this.logger.warning("Version not supported: " + deviceVersion);
            this.connectPhase = "Version not supported: " + deviceVersion;
            return false;
        }
        this.deviceVersion = deviceVersion;
        this.connectPhase = "pf rq tx echo";
        this.connectProgress = 10;
        this.requestCommand(new Command(CommandName.req_tx_echo, "0")).waitForResponse();
        this.connectPhase = "push promt";
        this.connectProgress = 12;
        this.requestCommand(new Command(CommandName.req_tx_promt, "0")).waitForResponseChecked();
        this.connectPhase = "help max";
        this.connectProgress = 15;
        this.requestCommand(new Command(CommandName.help, "max")).waitForResponseChecked();
        this.connectPhase = "help map";
        this.connectProgress = 20;
        this.requestCommand(new Command(CommandName.help, "map")).waitForResponseChecked();
        this.connectPhase = "help idx";
        this.connectProgress = 25;
        this.requestCommand(new Command(CommandName.help, "idx")).waitForResponseChecked();
        this.connectPhase = "info_conf";
        this.connectProgress = 30;
        this.requestCommand(new Command(CommandName.info_conf, "all")).waitForResponseChecked();
        this.connectPhase = "info_data";
        this.connectProgress = 70;
        this.requestCommand(new Command(CommandName.info_data)).waitForResponseChecked();
        this.connectPhase = "info_prog";
        this.connectProgress = 85;
        this.requestCommand(new Command(CommandName.info_prog)).waitForResponseChecked();
        this.requestCommand(new Command(CommandName.req_tx_push, "1")).waitForResponseChecked();
        this.connectPhase = "Fire events";
        this.connectProgress = 95;
        if (this.isConnected()) {
            this.fireSerialConnect(true);
        }
        this.connectPhase = "Connected";
        this.connectProgress = 100;
        return true;
    }

    @Override
    public boolean isConnected() {
        return this.deviceVersion > 0;
    }

    @Override
    public int getDeviceVersion() {
        return this.deviceVersion;
    }

    @Override
    public int getConnectProgress() {
        return this.connectProgress;
    }

    @Override
    public String getConnectPhase() {
        return this.connectPhase;
    }

    @Override
    public DeviceData getDeviceData() {
        return this.deviceData;
    }

    @Override
    public DeviceCommandRequest requestCommand(Command command) {
        DeviceCommandRequest rc = new DeviceCommandRequest(command);
        if (command.getCommandName().equals((Object)CommandName.reset_data)) {
            this.sendCommandQueue.clear();
        } else if (command.getCommandName().equals((Object)CommandName.reset_conf)) {
            this.sendCommandQueue.clear();
        } else if (command.getCommandName().equals((Object)CommandName.reset_chip)) {
            this.sendCommandQueue.clear();
        }
        this.sendCommandQueue.add(rc);
        return rc;
    }

    public DeviceCommandRequest pollCommandRequest() {
        return this.sendCommandQueue.poll();
    }

    public DeviceCommandRequest peekCommandRequest() {
        return this.sendCommandQueue.peek();
    }

    @Override
    public void addDeviceDataListener(DeviceDataListener dataListener) {
        this.dataListeners.add(dataListener);
    }

    @Override
    public void addDeviceCommandListener(CommandName cn, DeviceCommandListener commandListener) {
        List<DeviceCommandListener> list = this.commandListeners.get(cn);
        if (list == null) {
            list = new ArrayList<DeviceCommandListener>(5);
            this.commandListeners.put(cn, list);
        }
        list.add(commandListener);
    }

    @Override
    public void addDeviceConnectListener(DeviceConnectListener connectListener) {
        this.connectListeners.add(connectListener);
    }

    @Override
    public void fireSerialConnect(boolean connected) {
        for (int i = 0; i < this.connectListeners.size(); ++i) {
            if (connected) {
                this.connectListeners.get(i).deviceConnect();
                continue;
            }
            this.connectListeners.get(i).deviceDisconnect();
        }
    }

    @Override
    public void fireDataSend(String data) {
        for (int i = 0; i < this.dataListeners.size(); ++i) {
            this.dataListeners.get(i).deviceDataSend(data);
        }
    }

    @Override
    public void fireDataReceived(String data) {
        for (int i = 0; i < this.dataListeners.size(); ++i) {
            this.dataListeners.get(i).deviceDataReceived(data);
        }
    }

    @Override
    public void fireCommandReceived(Command command) {
        List<DeviceCommandListener> list = this.commandListeners.get(command.getCommandName());
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).commandReceived(command);
        }
    }
}

