/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import org.nongnu.pulsefire.device.DeviceConnectListener;
import org.nongnu.pulsefire.device.DeviceDataListener;
import org.nongnu.pulsefire.device.ui.DevicePortsComboBoxModel;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingKeys;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;
import org.nongnu.pulsefire.device.ui.components.JConnectDialog;

public class JTopPanelSerial
extends JPanel
implements ActionListener,
DeviceConnectListener,
DeviceDataListener {
    private static final long serialVersionUID = -6521267550228492042L;
    private JButton connectButtton = null;
    private JComboBox portsComboBox = null;
    private JLabel versionLabel = null;
    private JConnectDialog connectDialog = null;
    private JLabel serialTxCounter = null;
    private JLabel serialRxCounter = null;
    private long txBytes = 0L;
    private long rxBytes = 0L;

    public JTopPanelSerial() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridLayout(1, 0));
        JPanel borderPanel = JComponentFactory.createJFirePanel(this, "serial");
        this.add(borderPanel);
        JPanel serialPanel = new JPanel();
        serialPanel.setLayout(new SpringLayout());
        borderPanel.add(serialPanel);
        serialPanel.add(JComponentFactory.createJLabel(this, "ports"));
        DevicePortsComboBoxModel portModel = new DevicePortsComboBoxModel();
        this.portsComboBox = new JComboBox(portModel);
        this.portsComboBox.addPopupMenuListener(portModel);
        serialPanel.add(this.portsComboBox);
        serialPanel.add(JComponentFactory.createJLabel(this, "connect"));
        this.connectButtton = new JButton("Connect");
        this.connectButtton.addActionListener(this);
        this.connectButtton.requestFocusInWindow();
        serialPanel.add(this.connectButtton);
        SpringLayoutGrid.makeCompactGrid(serialPanel, 2, 2);
        JPanel serialInfoPanel = new JPanel();
        serialInfoPanel.setLayout(new SpringLayout());
        borderPanel.add(serialInfoPanel);
        serialInfoPanel.add(JComponentFactory.createJLabel(this, "version"));
        this.versionLabel = new JLabel("");
        serialInfoPanel.add(this.versionLabel);
        this.serialTxCounter = new JLabel();
        serialInfoPanel.add(JComponentFactory.createJLabel(this, "serialTxCounter"));
        serialInfoPanel.add(this.serialTxCounter);
        this.serialRxCounter = new JLabel();
        serialInfoPanel.add(JComponentFactory.createJLabel(this, "serialRxCounter"));
        serialInfoPanel.add(this.serialRxCounter);
        SpringLayoutGrid.makeCompactGrid(serialInfoPanel, 3, 2);
        PulseFireUI.getInstance().getDeviceManager().addDeviceConnectListener((DeviceConnectListener)this);
        PulseFireUI.getInstance().getDeviceManager().addDeviceDataListener((DeviceDataListener)this);
        this.updateSerialCounter();
        Boolean autoConnect = PulseFireUI.getInstance().getSettingBoolean(PulseFireUISettingKeys.AUTO_CONNECT);
        String devicePort = PulseFireUI.getInstance().getSettingString(PulseFireUISettingKeys.DEVICE_PORT);
        if (autoConnect.booleanValue() && !devicePort.isEmpty()) {
            for (int i = 0; i < this.portsComboBox.getModel().getSize(); ++i) {
                String port = (String)this.portsComboBox.getModel().getElementAt(i);
                if (!port.equals(devicePort)) continue;
                this.portsComboBox.setSelectedIndex(i);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTopPanelSerial.this.actionPerformed(null);
                    }
                });
                break;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String port = this.portsComboBox.getSelectedItem().toString();
        if (this.portsComboBox.isEnabled()) {
            if (this.connectDialog != null && !this.connectDialog.isVisible()) {
                this.connectDialog = null;
            }
            if (this.connectDialog == null) {
                this.connectDialog = new JConnectDialog((JFrame)SwingUtilities.getRoot(this), port);
            }
        } else {
            PulseFireUI.getInstance().getDeviceManager().disconnect();
        }
    }

    public void deviceConnect() {
        this.connectDialog = null;
        this.portsComboBox.setEnabled(false);
        this.connectButtton.setText("Disconnect");
        this.versionLabel.setText("" + new Float(PulseFireUI.getInstance().getDeviceManager().getDeviceVersion()).floatValue() / 10.0f);
        PulseFireUI.getInstance().getSettings().setProperty(PulseFireUISettingKeys.DEVICE_PORT.name(), "" + this.portsComboBox.getSelectedItem());
    }

    public void deviceDisconnect() {
        this.portsComboBox.setEnabled(true);
        this.connectButtton.setText("Connect");
        this.versionLabel.setText("");
        this.txBytes = 0L;
        this.rxBytes = 0L;
        this.updateSerialCounter();
    }

    public void deviceDataSend(String data) {
        this.txBytes += (long)data.length();
        this.updateSerialCounter();
    }

    public void deviceDataReceived(String data) {
        this.rxBytes += (long)data.length();
        this.updateSerialCounter();
    }

    private void updateSerialCounter() {
        String txSize = "B";
        String rxSize = "B";
        String txDotSize = "";
        String rxDotSize = "";
        long tx = this.txBytes;
        long rx = this.rxBytes;
        if (tx > 1024L) {
            txSize = "KB";
            txDotSize = "" + tx % 1024L;
            tx /= 1024L;
        }
        if (rx > 1024L) {
            rxSize = "KB";
            rxDotSize = "" + rx % 1024L;
            rx /= 1024L;
        }
        if (tx > 1024L) {
            txSize = "MB";
            txDotSize = "" + tx % 1024L;
            tx /= 1024L;
        }
        if (rx > 1024L) {
            rxSize = "MB";
            rxDotSize = "" + rx % 1024L;
            rx /= 1024L;
        }
        txDotSize = txDotSize.length() == 2 ? ".0" + txDotSize : (txDotSize.length() == 1 ? ".00" + txDotSize : (txDotSize.length() == 0 ? "" : "." + txDotSize));
        rxDotSize = rxDotSize.length() == 2 ? ".0" + rxDotSize : (rxDotSize.length() == 1 ? ".00" + rxDotSize : (rxDotSize.length() == 0 ? "" : "." + rxDotSize));
        this.serialTxCounter.setText(tx + txDotSize + txSize);
        this.serialTxCounter.repaint();
        this.serialRxCounter.setText(rx + rxDotSize + rxSize);
        this.serialRxCounter.repaint();
    }
}

