/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.DeviceData;
import org.nongnu.pulsefire.device.DeviceDataListener;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingKeys;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;
import org.nongnu.pulsefire.wire.CommandVariableType;

public class PulseFireDataLogManager {
    private Logger logger = Logger.getLogger(PulseFireDataLogManager.class.getName());
    private LogDataWriter logDataWriter = null;
    private LogPullWriter logPullWriter = null;

    public void start() {
        Boolean logFileAppend = PulseFireUI.getInstance().getSettingBoolean(PulseFireUISettingKeys.LOG_FILE_APPEND);
        Boolean logCmdEnable = PulseFireUI.getInstance().getSettingBoolean(PulseFireUISettingKeys.LOG_CMD_ENABLE);
        String cmdFile = PulseFireUI.getInstance().getSettingString(PulseFireUISettingKeys.LOG_CMD_FILE);
        if (logCmdEnable.booleanValue() && !cmdFile.isEmpty()) {
            File logFile = new File(cmdFile);
            try {
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                this.logDataWriter = new LogDataWriter(logFile, logFileAppend);
            }
            catch (IOException ioe) {
                this.logger.log(Level.WARNING, ioe.getMessage(), ioe);
                return;
            }
            PulseFireUI.getInstance().getDeviceManager().addDeviceDataListener((DeviceDataListener)this.logDataWriter);
            Thread t = new Thread(this.logDataWriter);
            t.setName("pulsefire-log-data-writer");
            t.start();
        }
        Boolean logPullEnable = PulseFireUI.getInstance().getSettingBoolean(PulseFireUISettingKeys.LOG_PULL_ENABLE);
        String pullFile = PulseFireUI.getInstance().getSettingString(PulseFireUISettingKeys.LOG_PULL_FILE);
        if (logPullEnable.booleanValue() && !pullFile.isEmpty()) {
            File logFile = new File(pullFile);
            try {
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                this.logPullWriter = new LogPullWriter(logFile, logFileAppend);
            }
            catch (IOException ioe) {
                this.logger.log(Level.WARNING, ioe.getMessage(), ioe);
                return;
            }
            PulseFireUI.getInstance().getDeviceManager().addDeviceCommandListener(CommandName.info_data, (DeviceCommandListener)this.logPullWriter);
            Thread t = new Thread(this.logPullWriter);
            t.setName("pulsefire-log-pull-writer");
            t.start();
        }
    }

    public void stop() {
        if (this.logDataWriter != null) {
            this.logDataWriter.shutdown();
        }
        if (this.logPullWriter != null) {
            this.logPullWriter.shutdown();
        }
    }

    class LogPullWriter
    implements Runnable,
    DeviceCommandListener {
        private volatile boolean run = true;
        private Writer out = null;
        private DateFormat timeFormat = null;
        private volatile boolean doPullLog = false;
        private volatile boolean writeHeader = true;

        public LogPullWriter(File logFile, boolean logFileAppend) throws IOException {
            this.out = new OutputStreamWriter((OutputStream)new FileOutputStream(logFile, logFileAppend), Charset.forName("UTF-8"));
            this.timeFormat = new SimpleDateFormat("HH:mm:ss-dd/MM/yyyy");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                char sep = ',';
                DeviceData devData = PulseFireUI.getInstance().getDeviceData();
                while (this.run) {
                    Thread.sleep(1000L);
                    if (!this.doPullLog) continue;
                    this.doPullLog = false;
                    if (this.writeHeader) {
                        this.writeHeader();
                        this.writeHeader = false;
                    }
                    long time = System.currentTimeMillis();
                    this.out.append("" + time);
                    this.out.append(sep);
                    this.out.append(this.timeFormat.format(time));
                    this.out.append(sep);
                    for (CommandName cn : CommandName.values()) {
                        if (!CommandVariableType.DATA.equals((Object)cn.getType())) continue;
                        if (cn.isIndexedA()) {
                            for (int i = 0; i < cn.getMaxIndexA(); ++i) {
                                Command cmd = devData.getDeviceParameterIndexed(cn, Integer.valueOf(i));
                                if (cmd == null) continue;
                                this.out.append(cmd.getArgu0());
                                this.out.append(sep);
                            }
                            continue;
                        }
                        Command cmd = devData.getDeviceParameter(cn);
                        if (cmd == null) continue;
                        this.out.append(cmd.getArgu0());
                        this.out.append(sep);
                    }
                    this.out.append("\r\n");
                    this.out.flush();
                }
            }
            catch (Exception e) {
                PulseFireDataLogManager.this.logger.log(Level.WARNING, e.getMessage(), e);
            }
            finally {
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                }
                catch (IOException e) {
                    PulseFireDataLogManager.this.logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }

        private void writeHeader() throws IOException {
            this.out.append('#');
            this.out.append("epoch,time,");
            for (CommandName cn : CommandName.values()) {
                if (!CommandVariableType.DATA.equals((Object)cn.getType())) continue;
                if (cn.isIndexedA()) {
                    for (int i = 0; i < cn.getMaxIndexA(); ++i) {
                        this.out.append(cn.name());
                        this.out.append("" + i);
                        this.out.append(',');
                    }
                    continue;
                }
                this.out.append(cn.name());
                this.out.append(',');
            }
            this.out.append("\r\n");
            this.out.flush();
        }

        public void shutdown() {
            this.run = false;
        }

        public void commandReceived(Command command) {
            this.doPullLog = true;
        }
    }

    class LogData {
        String data;
        String type;
        long time;

        LogData() {
        }
    }

    class LogDataWriter
    implements Runnable,
    DeviceDataListener {
        private volatile boolean run = true;
        private Queue<LogData> dataQueue = new LinkedBlockingQueue<LogData>();
        private Writer out = null;
        private DateFormat timeFormat = null;

        public LogDataWriter(File logFile, boolean logFileAppend) throws FileNotFoundException {
            this.out = new OutputStreamWriter((OutputStream)new FileOutputStream(logFile, logFileAppend), Charset.forName("UTF-8"));
            this.timeFormat = new SimpleDateFormat("HH:mm:ss-dd/MM/yyyy");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                char sep = ',';
                while (this.run) {
                    Thread.sleep(1000L);
                    Boolean logRx = PulseFireUI.getInstance().getSettingBoolean(PulseFireUISettingKeys.LOG_CMD_RX);
                    Boolean logTx = PulseFireUI.getInstance().getSettingBoolean(PulseFireUISettingKeys.LOG_CMD_TX);
                    LogData logData = this.dataQueue.poll();
                    while (logData != null) {
                        if ("rx".equals(logData.type) && !logRx.booleanValue()) {
                            logData = this.dataQueue.poll();
                            continue;
                        }
                        if ("tx".equals(logData.type) && !logTx.booleanValue()) {
                            logData = this.dataQueue.poll();
                            continue;
                        }
                        this.out.append("" + logData.time);
                        this.out.append(sep);
                        this.out.append(this.timeFormat.format(logData.time));
                        this.out.append(sep);
                        this.out.append(logData.type);
                        this.out.append(sep);
                        this.out.append(logData.data);
                        this.out.append("\r\n");
                        logData = this.dataQueue.poll();
                    }
                    this.out.flush();
                }
            }
            catch (Exception e) {
                PulseFireDataLogManager.this.logger.log(Level.WARNING, e.getMessage(), e);
            }
            finally {
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                }
                catch (IOException e) {
                    PulseFireDataLogManager.this.logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }

        public void shutdown() {
            this.run = false;
        }

        public void deviceDataSend(String data) {
            LogData ld = new LogData();
            ld.data = data;
            ld.type = "tx";
            ld.time = System.currentTimeMillis();
            this.dataQueue.offer(ld);
        }

        public void deviceDataReceived(String data) {
            LogData ld = new LogData();
            ld.data = data;
            ld.type = "rx";
            ld.time = System.currentTimeMillis();
            this.dataQueue.offer(ld);
        }
    }
}

