/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.tabs;

import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.nongnu.pulsefire.device.DeviceConnectListener;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.tabs.JTabFirePanel;

public abstract class AbstractTabPanel
extends JPanel
implements JTabFirePanel,
DeviceConnectListener {
    private JScrollPane parentScrollPane = null;

    public AbstractTabPanel() {
        PulseFireUI.getInstance().getDeviceManager().addDeviceConnectListener((DeviceConnectListener)this);
    }

    abstract Class<?> getTabClassName();

    @Override
    public String getTabName() {
        String nameKey = this.getTabClassName().getName() + ".text";
        return PulseFireUI.getInstance().getContext().getResourceMap().getString(nameKey, new Object[0]);
    }

    @Override
    public String getTabTooltip() {
        String nameKey = this.getTabClassName().getName() + ".tooltip";
        return PulseFireUI.getInstance().getContext().getResourceMap().getString(nameKey, new Object[0]);
    }

    @Override
    public Icon getTabIcon() {
        String nameKey = this.getTabClassName().getName() + ".icon";
        return PulseFireUI.getInstance().getContext().getResourceMap().getIcon(nameKey);
    }

    @Override
    public JPanel getJPanel() {
        return this;
    }

    @Override
    public JScrollPane getParentScrollPane() {
        return this.parentScrollPane;
    }

    @Override
    public void setParentScrollPane(JScrollPane parentScrollPane) {
        this.parentScrollPane = parentScrollPane;
    }

    public void deviceConnect() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.updateComponentTreeUI(AbstractTabPanel.this.parentScrollPane);
            }
        });
    }

    public void deviceDisconnect() {
    }
}

