/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.time;

import org.nongnu.pulsefire.device.DeviceConnectListener;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingKeys;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingListener;
import org.nongnu.pulsefire.device.ui.time.EventTimeTrigger;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;

public class PulseFireDataPuller
implements Runnable,
DeviceConnectListener,
PulseFireUISettingListener {
    public static final int INIT_SPEED = 10000;
    private volatile boolean run = false;
    private volatile boolean runOnce = true;
    private volatile boolean runPause = false;

    public PulseFireDataPuller() {
        PulseFireUI.getInstance().getDeviceManager().addDeviceConnectListener((DeviceConnectListener)this);
        PulseFireUI.getInstance().getSettingsManager().addSettingListener(PulseFireUISettingKeys.PULL_SPEED, this);
    }

    @Override
    public void run() {
        if (this.run & !this.runPause) {
            PulseFireUI.getInstance().getDeviceManager().requestCommand(new Command(CommandName.info_data));
            PulseFireUI.getInstance().getDeviceManager().requestCommand(new Command(CommandName.info_prog));
            PulseFireUI.getInstance().getDeviceManager().requestCommand(new Command(CommandName.info_freq));
            if (this.runOnce) {
                this.runOnce = false;
                PulseFireUI.getInstance().getDeviceManager().requestCommand(new Command(CommandName.info_conf));
                this.settingUpdated(PulseFireUISettingKeys.PULL_SPEED, PulseFireUI.getInstance().getSettingsManager().getSettingString(PulseFireUISettingKeys.PULL_SPEED));
            }
        }
    }

    public void deviceConnect() {
        this.run = true;
        this.runOnce = true;
    }

    public void deviceDisconnect() {
        this.run = false;
        this.runOnce = true;
    }

    public boolean isRunPause() {
        return this.runPause;
    }

    public void setRunPause(boolean runPause) {
        this.runPause = runPause;
    }

    @Override
    public void settingUpdated(PulseFireUISettingKeys key, String value) {
        EventTimeTrigger trig = PulseFireUI.getInstance().getEventTimeManager().getEventTimeTriggerByName("refreshData");
        if (trig != null) {
            trig.setTimeStep(new Integer(value).intValue());
            trig.setTimeNextRun(trig.getRunStartTime() + trig.getTimeStep());
        }
    }
}

