/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.tabs;

import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.DeviceData;
import org.nongnu.pulsefire.device.DeviceWireManager;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;
import org.nongnu.pulsefire.device.ui.components.JCommandButton;
import org.nongnu.pulsefire.device.ui.components.JFireQMapTable;
import org.nongnu.pulsefire.device.ui.tabs.AbstractFireTabPanel;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;

public class JTabPanelPtt
extends AbstractFireTabPanel
implements DeviceCommandListener {
    private static final long serialVersionUID = 2716662787208065889L;
    private JLabel runLabel = null;
    private JLabel runStepLabel = null;

    public JTabPanelPtt() {
        this.setLayout(new FlowLayout(0));
        JPanel wrap = new JPanel();
        wrap.setLayout(new SpringLayout());
        wrap.add(this.createTriggerStatusPanel());
        wrap.add(this.createTriggerTestPanel());
        JPanel trig0Panel = JComponentFactory.createJFirePanel(this, "ptt0");
        trig0Panel.add(new JFireQMapTable(CommandName.ptt_0map, "value", "time"));
        wrap.add(trig0Panel);
        JPanel trig1Panel = JComponentFactory.createJFirePanel(this, "ptt1");
        trig1Panel.add(new JFireQMapTable(CommandName.ptt_1map, "value", "time"));
        wrap.add(trig1Panel);
        JPanel trig2Panel = JComponentFactory.createJFirePanel(this, "ptt2");
        trig2Panel.add(new JFireQMapTable(CommandName.ptt_2map, "value", "time"));
        wrap.add(trig2Panel);
        JPanel trig3Panel = JComponentFactory.createJFirePanel(this, "ptt3");
        trig3Panel.add(new JFireQMapTable(CommandName.ptt_3map, "value", "time"));
        wrap.add(trig3Panel);
        SpringLayoutGrid.makeCompactGrid(wrap, 3, 2);
        this.add(wrap);
        DeviceWireManager deviceManager = PulseFireUI.getInstance().getDeviceManager();
        deviceManager.addDeviceCommandListener(CommandName.info_data, (DeviceCommandListener)this);
    }

    private JPanel createTriggerStatusPanel() {
        JPanel header = JComponentFactory.createJFirePanel(this, "pttStatus");
        JPanel wrap = new JPanel();
        wrap.setLayout(new SpringLayout());
        wrap.add(new JLabel("Run:"));
        this.runLabel = new JLabel();
        wrap.add(this.runLabel);
        wrap.add(new JLabel("Step:"));
        this.runStepLabel = new JLabel();
        wrap.add(this.runStepLabel);
        SpringLayoutGrid.makeCompactGrid(wrap, 2, 2);
        header.add(wrap);
        return header;
    }

    private JPanel createTriggerTestPanel() {
        JPanel header = JComponentFactory.createJFirePanel(this, "pttTrigger");
        JPanel wrap = new JPanel();
        wrap.add(new JLabel("Fire: "));
        wrap.add(new JCommandButton(CommandName.req_trigger, CommandName.ptt_fire, 0));
        wrap.add(new JCommandButton(CommandName.req_trigger, CommandName.ptt_fire, 1));
        wrap.add(new JCommandButton(CommandName.req_trigger, CommandName.ptt_fire, 2));
        wrap.add(new JCommandButton(CommandName.req_trigger, CommandName.ptt_fire, 3));
        header.add(wrap);
        return header;
    }

    @Override
    public Class<?> getTabClassName() {
        return this.getClass();
    }

    public void commandReceived(Command command) {
        int value;
        Command cmd;
        int i;
        DeviceData deviceData = PulseFireUI.getInstance().getDeviceManager().getDeviceData();
        StringBuilder buf = new StringBuilder(100);
        for (i = CommandName.ptt_cnt.getMaxIndexA() - 1; i >= 0; --i) {
            cmd = deviceData.getDeviceParameterIndexed(CommandName.ptt_cnt, Integer.valueOf(i));
            value = -1;
            if (cmd != null) {
                value = new Integer(cmd.getArgu0());
            }
            buf.append(CommandName.ptt_cnt.name());
            buf.append(i);
            buf.append(": ");
            buf.append(value);
            buf.append(" ");
        }
        this.runLabel.setText(buf.toString());
        buf = new StringBuilder(100);
        for (i = CommandName.ptt_idx.getMaxIndexA() - 1; i >= 0; --i) {
            cmd = deviceData.getDeviceParameterIndexed(CommandName.ptt_idx, Integer.valueOf(i));
            value = -1;
            if (cmd != null) {
                value = new Integer(cmd.getArgu0());
            }
            buf.append(CommandName.ptt_idx.name());
            buf.append(i);
            buf.append(": ");
            buf.append(value);
            buf.append(" ");
        }
        this.runStepLabel.setText(buf.toString());
    }
}

