/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.wire;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nongnu.pulsefire.wire.CommandName;

public class MalCommand
implements Cloneable {
    private List<Byte> opcodes = new ArrayList<Byte>(4);
    private CmdType cmdType = null;
    private ValueType valueType = null;
    private VarIndex varIndex = null;
    private ExtType extType = null;
    private int extOp = 0;
    private int cmdArgu = 0;
    private int cmdArguIdx = 0;
    private int tabIndent = 0;
    private static int tabIndentParse = 0;

    public void init() {
        this.cmdType = CmdType.LOAD;
        this.valueType = ValueType.RAW_VALUE;
        this.varIndex = VarIndex.VAR_0;
        this.extType = ExtType.VOP;
        this.compile();
    }

    public boolean parse(Iterator<Byte> data) {
        if (!data.hasNext()) {
            return false;
        }
        this.tabIndent = tabIndentParse;
        Byte opcode = data.next();
        this.opcodes.add(opcode);
        int value_type = opcode >> 4 & 3;
        int var_idx = opcode & 0xF;
        int cmd_type = opcode >> 6 & 3;
        int ext_type = 0;
        int ext_op = 0;
        if (!data.hasNext()) {
            return false;
        }
        this.cmdType = CmdType.values()[cmd_type];
        this.valueType = ValueType.values()[value_type];
        this.varIndex = VarIndex.values()[var_idx];
        if (cmd_type == 1) {
            opcode = data.next();
            this.opcodes.add(opcode);
            ext_type = opcode >> 4 & 0xF;
            ext_op = opcode & 0xF;
            if (ext_type < ExtType.values().length) {
                this.extType = ExtType.values()[ext_type];
            }
            this.extOp = ext_op;
        } else if (cmd_type == 3) {
            opcode = data.next();
            this.opcodes.add(opcode);
            return true;
        }
        if (ext_type == 3) {
            ++tabIndentParse;
        }
        if (ext_type == 4) {
            this.tabIndent = --tabIndentParse;
            return true;
        }
        if (!data.hasNext()) {
            return false;
        }
        opcode = data.next();
        this.opcodes.add(opcode);
        this.cmdArgu = opcode.byteValue();
        if (value_type == 0) {
            opcode = data.next();
            this.opcodes.add(opcode);
            this.cmdArgu = (this.cmdArgu << 8) + opcode;
        } else if (value_type != 1) {
            if (value_type == 2) {
                CommandName cmd = CommandName.valueOfMapIndex(this.cmdArgu);
                if (cmd.isIndexedA()) {
                    opcode = data.next();
                    this.opcodes.add(opcode);
                    this.cmdArguIdx = opcode.byteValue();
                }
            } else {
                CommandName cmd = CommandName.valueOfMapIndex(this.cmdArgu);
                if (cmd.isIndexedA()) {
                    opcode = data.next();
                    this.opcodes.add(opcode);
                    this.cmdArguIdx = opcode.byteValue();
                }
            }
        }
        return true;
    }

    public void compile() {
        this.opcodes.clear();
        byte opcode = 0;
        opcode = (byte)(opcode + this.getVarIndex().ordinal());
        opcode = (byte)(opcode + (this.getValueType().ordinal() << 4));
        opcode = (byte)(opcode + (this.getCmdType().ordinal() << 6));
        this.opcodes.add(opcode);
        block0 : switch (this.cmdType) {
            case LOAD: {
                switch (this.valueType) {
                    case RAW_VALUE: {
                        opcode = new Integer(this.getCmdArgu() >> 8).byteValue();
                        this.opcodes.add(opcode);
                        opcode = new Integer(this.getCmdArgu() & 0xFF).byteValue();
                        this.opcodes.add(opcode);
                        break;
                    }
                    case PF_VALUE: 
                    case PF_VALUE_SET: {
                        opcode = new Integer(this.getCmdArgu() & 0xFF).byteValue();
                        this.opcodes.add(opcode);
                        CommandName cmd = CommandName.valueOfMapIndex(this.getCmdArgu());
                        if (!cmd.isIndexedA()) break block0;
                        opcode = new Integer(this.getCmdArguIdx() & 0xFF).byteValue();
                        this.opcodes.add(opcode);
                        break;
                    }
                    default: {
                        opcode = new Integer(this.getCmdArgu() & 0xFF).byteValue();
                        this.opcodes.add(opcode);
                        break;
                    }
                }
                break;
            }
            case EXTENDED: {
                if (this.getExtType() == null) {
                    this.setExtType(ExtType.STOP);
                }
                opcode = 0;
                opcode = (byte)(opcode + this.getExtOp());
                opcode = (byte)(opcode + (this.getExtType().ordinal() << 4));
                this.opcodes.add(opcode);
                switch (this.extType) {
                    case VOP: {
                        opcode = new Integer(this.getCmdArgu()).byteValue();
                        this.opcodes.add(opcode);
                        switch (this.valueType) {
                            case RAW_VALUE: {
                                opcode = new Integer(this.getCmdArgu() >> 8).byteValue();
                                this.opcodes.add(opcode);
                                break;
                            }
                            case PF_VALUE: 
                            case PF_VALUE_SET: {
                                CommandName cmd = CommandName.valueOfMapIndex(this.getCmdArgu());
                                if (!cmd.isIndexedA()) break;
                                opcode = new Integer(this.getCmdArguIdx() & 0xFF).byteValue();
                                this.opcodes.add(opcode);
                                break;
                            }
                        }
                        break block0;
                    }
                    case STOP: {
                        break block0;
                    }
                    case GOTO: {
                        opcode = new Integer(this.getCmdArgu() >> 8).byteValue();
                        this.opcodes.add(opcode);
                        opcode = new Integer(this.getCmdArgu()).byteValue();
                        this.opcodes.add(opcode);
                        break block0;
                    }
                    case IF: {
                        opcode = new Integer(this.getCmdArgu()).byteValue();
                        this.opcodes.add(opcode);
                        switch (this.valueType) {
                            case RAW_VALUE: {
                                opcode = new Integer(this.getCmdArgu() >> 8).byteValue();
                                this.opcodes.add(opcode);
                                break;
                            }
                            case PF_VALUE: 
                            case PF_VALUE_SET: {
                                CommandName cmd = CommandName.valueOfMapIndex(this.getCmdArgu());
                                if (!cmd.isIndexedA()) break;
                                opcode = new Integer(this.getCmdArguIdx() & 0xFF).byteValue();
                                this.opcodes.add(opcode);
                                break;
                            }
                        }
                        break block0;
                    }
                }
                break;
            }
            case RESERVED: {
                break;
            }
            case LAST_CMD: {
                this.opcodes.add(new Integer(255).byteValue());
            }
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(100);
        for (int i = 0; i < this.tabIndent; ++i) {
            buff.append("    ");
        }
        String malVarIndex = "" + (Object)((Object)this.varIndex);
        if (this.cmdType == null) {
            return "cmdType=null";
        }
        switch (this.cmdType) {
            case LOAD: {
                buff.append("LOAD ");
                switch (this.valueType) {
                    case RAW_VALUE: {
                        buff.append(malVarIndex);
                        buff.append("=");
                        buff.append(this.cmdArgu);
                        break;
                    }
                    case PROG_VALUE: {
                        buff.append(malVarIndex);
                        buff.append("=");
                        buff.append("VAR_");
                        buff.append(this.cmdArgu);
                        break;
                    }
                    case PF_VALUE: {
                        buff.append((Object)this.varIndex);
                        buff.append("=");
                        CommandName cmdA = CommandName.valueOfMapIndex(this.cmdArgu);
                        buff.append((Object)cmdA);
                        if (!cmdA.isIndexedA()) break;
                        buff.append('[');
                        buff.append(this.cmdArguIdx);
                        buff.append(']');
                        break;
                    }
                    case PF_VALUE_SET: {
                        CommandName cmdB = CommandName.valueOfMapIndex(this.cmdArgu);
                        buff.append((Object)cmdB);
                        if (cmdB.isIndexedA()) {
                            buff.append('[');
                            buff.append(this.cmdArguIdx);
                            buff.append(']');
                        }
                        buff.append("=");
                        buff.append(malVarIndex);
                    }
                }
                break;
            }
            case EXTENDED: {
                if (this.extType == null) {
                    return "extType=null";
                }
                switch (this.extType) {
                    case VOP: {
                        buff.append("VOP ");
                        buff.append(malVarIndex);
                        buff.append("=");
                        buff.append(malVarIndex);
                        buff.append(" ");
                        buff.append(ExtOpVar.values()[this.extOp].getCharCode());
                        buff.append(" ");
                        switch (this.valueType) {
                            case RAW_VALUE: {
                                buff.append(this.cmdArgu);
                                break;
                            }
                            case PROG_VALUE: {
                                buff.append("VAR_");
                                buff.append(this.cmdArgu);
                                break;
                            }
                            case PF_VALUE: {
                                CommandName cmd = CommandName.valueOfMapIndex(this.cmdArgu);
                                buff.append((Object)cmd);
                                if (!cmd.isIndexedA()) break;
                                buff.append('[');
                                buff.append(this.cmdArguIdx);
                                buff.append(']');
                                break;
                            }
                            case PF_VALUE_SET: {
                                buff.append("reserved");
                            }
                        }
                        break;
                    }
                    case STOP: {
                        buff.append("STOP");
                        break;
                    }
                    case GOTO: {
                        buff.append("GOTO ");
                        buff.append(this.cmdArgu);
                        break;
                    }
                    case IF: {
                        buff.append("IF ( ");
                        buff.append(malVarIndex);
                        buff.append(" ");
                        buff.append(ExtOpIf.values()[this.extOp].getCharCode());
                        buff.append(" ");
                        switch (this.valueType) {
                            case RAW_VALUE: {
                                buff.append(this.cmdArgu);
                                break;
                            }
                            case PROG_VALUE: {
                                buff.append("VAR_");
                                buff.append(this.cmdArgu);
                                break;
                            }
                            case PF_VALUE: {
                                CommandName cmd = CommandName.valueOfMapIndex(this.cmdArgu);
                                buff.append((Object)cmd);
                                if (!cmd.isIndexedA()) break;
                                buff.append('[');
                                buff.append(this.cmdArguIdx);
                                buff.append(']');
                                break;
                            }
                            case PF_VALUE_SET: {
                                buff.append("reserved");
                            }
                        }
                        buff.append(" )");
                        break;
                    }
                    case ENDIF: {
                        buff.append("ENDIF");
                    }
                }
                break;
            }
            case RESERVED: {
                buff.append("RESERVED");
                break;
            }
            case LAST_CMD: {
                buff.append("END");
            }
        }
        return buff.toString();
    }

    public String toStringHexOpcodes() {
        StringBuffer buff = new StringBuffer(5);
        for (Byte opcode : this.opcodes) {
            String hex = Integer.toHexString(opcode.byteValue());
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            if (hex.length() == 8) {
                hex = hex.substring(6);
            }
            buff.append(hex);
        }
        return buff.toString();
    }

    public int getOpcodeSize() {
        return this.opcodes.size();
    }

    public List<Byte> getOpcodes() {
        return this.opcodes;
    }

    public CmdType getCmdType() {
        return this.cmdType;
    }

    public void setCmdType(CmdType cmdType) {
        this.cmdType = cmdType;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public VarIndex getVarIndex() {
        return this.varIndex;
    }

    public void setVarIndex(VarIndex varIndex) {
        this.varIndex = varIndex;
    }

    public ExtType getExtType() {
        return this.extType;
    }

    public void setExtType(ExtType extType) {
        this.extType = extType;
    }

    public int getExtOp() {
        return this.extOp;
    }

    public void setExtOp(int extOp) {
        this.extOp = extOp;
    }

    public int getCmdArgu() {
        return this.cmdArgu;
    }

    public void setCmdArgu(int cmdArgu) {
        this.cmdArgu = cmdArgu;
    }

    public int getCmdArguIdx() {
        return this.cmdArguIdx;
    }

    public void setCmdArguIdx(int cmdArguIdx) {
        this.cmdArguIdx = cmdArguIdx;
    }

    public MalCommand clone() {
        MalCommand cmd = new MalCommand();
        cmd.setCmdArguIdx(this.getCmdArguIdx());
        cmd.setCmdArgu(this.getCmdArgu());
        cmd.setCmdType(this.getCmdType());
        cmd.setExtOp(this.getExtOp());
        cmd.setExtType(this.getExtType());
        cmd.setValueType(this.getValueType());
        cmd.setVarIndex(this.getVarIndex());
        cmd.compile();
        return cmd;
    }

    public static enum ExtOpIf {
        EQUAL("=="),
        NOT_EQUAL("!="),
        GREATER_THEN(">"),
        SMALLER_THEN("<"),
        GREATER_OR_EQUAL("=>"),
        SMALLER_OR_EQUAL("<=");

        private String charCode = null;

        private ExtOpIf(String charCode) {
            this.charCode = charCode;
        }

        public String getCharCode() {
            return this.charCode;
        }
    }

    public static enum ExtOpVar {
        ADD("+"),
        SUBTRACT("-"),
        MULTIPLY("*"),
        DIVIDE("/"),
        AND("&"),
        OR("|");

        private String charCode = null;

        private ExtOpVar(String charCode) {
            this.charCode = charCode;
        }

        public String getCharCode() {
            return this.charCode;
        }
    }

    public static enum ExtType {
        VOP,
        STOP,
        GOTO,
        IF,
        ENDIF;

    }

    public static enum VarIndex {
        VAR_0,
        VAR_1,
        VAR_2,
        VAR_3,
        VAR_4,
        VAR_5,
        VAR_6,
        VAR_7,
        VAR_8,
        VAR_9,
        VAR_10,
        VAR_11,
        VAR_12,
        VAR_13,
        VAR_14,
        VAR_15;

    }

    public static enum ValueType {
        RAW_VALUE,
        PROG_VALUE,
        PF_VALUE,
        PF_VALUE_SET;

    }

    public static enum CmdType {
        LOAD,
        EXTENDED,
        RESERVED,
        LAST_CMD;

    }
}

