/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.DeviceWireManager;
import org.nongnu.pulsefire.device.ui.JComponentEnableStateListener;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;

public class JCommandCheckBoxAll
extends JCheckBox
implements ActionListener,
DeviceCommandListener {
    private static final long serialVersionUID = -3660219975769332446L;
    private DeviceWireManager deviceManager = null;
    private Command command = null;
    private int bit = -1;

    public JCommandCheckBoxAll(CommandName commandName) {
        this(commandName, -1);
    }

    public JCommandCheckBoxAll(CommandName commandName, int bit) {
        this.bit = bit;
        this.deviceManager = PulseFireUI.getInstance().getDeviceManager();
        this.command = new Command(commandName);
        this.addActionListener(this);
        JComponentEnableStateListener.attach(this, commandName);
        this.deviceManager.addDeviceCommandListener(this.command.getCommandName(), (DeviceCommandListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean selected = this.isSelected();
        String argu0 = "0";
        if (selected) {
            argu0 = "65535";
        }
        if (this.bit == -1) {
            this.command.setArgu0(argu0);
            this.deviceManager.requestCommand(this.command);
        } else {
            Command cmd = PulseFireUI.getInstance().getDeviceData().getDeviceParameterIndexed(this.command, Integer.valueOf(0));
            if (cmd == null) {
                return;
            }
            int andBits = 1 << this.bit;
            int data = new Integer(cmd.getArgu0());
            if ((data & andBits) == 0) {
                this.command.setArgu0("" + (data + andBits));
            } else {
                this.command.setArgu0("" + (data - andBits));
            }
            this.deviceManager.requestCommand(this.command);
        }
    }

    public void commandReceived(Command command) {
        if (this.bit == -1) {
            boolean selectedBox;
            boolean selectedNew = "1".endsWith(command.getArgu0());
            if (selectedNew == (selectedBox = this.isSelected())) {
                return;
            }
            this.setSelected(selectedNew);
        } else {
            if (command.getArgu1() == null) {
                return;
            }
            if (!new Integer(command.getArgu1()).equals(0)) {
                return;
            }
            Command cmd = PulseFireUI.getInstance().getDeviceData().getDeviceParameterIndexed(command, Integer.valueOf(0));
            if (cmd == null) {
                return;
            }
            int andBits = 1 << this.bit;
            int data = new Integer(cmd.getArgu0());
            this.setSelected((data & andBits) > 0);
        }
    }
}

