/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.tabs;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.filechooser.FileFilter;
import org.nongnu.pulsefire.device.DeviceData;
import org.nongnu.pulsefire.device.ui.JComponentEnableStateListener;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;
import org.nongnu.pulsefire.device.ui.components.JCommandButton;
import org.nongnu.pulsefire.device.ui.components.JCommandComboBox;
import org.nongnu.pulsefire.device.ui.components.JCommandDial;
import org.nongnu.pulsefire.device.ui.components.JCommandLabel;
import org.nongnu.pulsefire.device.ui.components.JFireQMapTable;
import org.nongnu.pulsefire.device.ui.tabs.AbstractFireTabPanel;
import org.nongnu.pulsefire.device.ui.time.PulseFireDataPuller;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;
import org.nongnu.pulsefire.wire.CommandVariableType;
import org.nongnu.pulsefire.wire.CommandWire;

public class JTabPanelSystem
extends AbstractFireTabPanel {
    private static final long serialVersionUID = -5523263800067726564L;
    private Logger logger = Logger.getLogger(JTabPanelSystem.class.getName());

    public JTabPanelSystem() {
        this.setLayout(new FlowLayout(0));
        JPanel wrap = new JPanel();
        wrap.setLayout(new SpringLayout());
        wrap.add(this.createSystemConfig());
        wrap.add(this.createSystemIO());
        wrap.add(this.createSystemWarmup());
        SpringLayoutGrid.makeCompactGrid(wrap, 1, 3);
        this.add(wrap);
    }

    private JPanel createSystemConfig() {
        JPanel wrapPanel = JComponentFactory.createJFirePanel(this, "config");
        JPanel confPanel = new JPanel();
        confPanel.setLayout(new SpringLayout());
        confPanel.add(new JCommandLabel(CommandName.save));
        confPanel.add(new JCommandButton(CommandName.save));
        confPanel.add(new JCommandLabel(CommandName.reset_conf));
        confPanel.add(new JCommandButton(CommandName.reset_conf));
        confPanel.add(new JCommandLabel(CommandName.reset_data));
        confPanel.add(new JCommandButton(CommandName.reset_data));
        confPanel.add(new JCommandLabel(CommandName.reset_chip));
        confPanel.add(new JCommandButton(CommandName.reset_chip));
        JButton loadButton = new JButton("Load");
        JComponentEnableStateListener.attach(loadButton, null);
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setFileFilter(new ChipConfigFileFilter());
                int returnVal = fc.showOpenDialog((JButton)e.getSource());
                if (returnVal == 0) {
                    final File file = fc.getSelectedFile();
                    Thread t = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            PulseFireDataPuller puller = (PulseFireDataPuller)PulseFireUI.getInstance().getEventTimeManager().getEventTimeTriggerByName("refreshData").getRunnable();
                            try {
                                puller.setRunPause(true);
                                JTabPanelSystem.this.logger.info("Reading config from: " + file.getAbsolutePath());
                                JTabPanelSystem.this.readConfig(new FileInputStream(file));
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                            finally {
                                puller.setRunPause(false);
                            }
                        }
                    });
                    t.start();
                }
            }
        });
        confPanel.add(JComponentFactory.createJLabel("Load File"));
        confPanel.add(loadButton);
        JButton saveButton = new JButton("Save");
        JComponentEnableStateListener.attach(saveButton, null);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setFileFilter(new ChipConfigFileFilter());
                fc.setSelectedFile(new File("my-config.pfcc"));
                int returnVal = fc.showSaveDialog((JButton)e.getSource());
                if (returnVal == 0) {
                    File selFile = fc.getSelectedFile();
                    if (!selFile.getName().contains(".")) {
                        selFile = new File(selFile.getAbsolutePath() + ".pfcc");
                    }
                    final File file = selFile;
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                JTabPanelSystem.this.logger.info("Writing config to: " + file.getAbsolutePath());
                                JTabPanelSystem.this.writeConfig(new FileOutputStream(file));
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    });
                    t.start();
                }
            }
        });
        confPanel.add(JComponentFactory.createJLabel("Save File"));
        confPanel.add(saveButton);
        SpringLayoutGrid.makeCompactGrid(confPanel, 6, 2);
        wrapPanel.add(confPanel);
        return wrapPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfig(OutputStream output) throws IOException {
        try {
            DeviceData devData = PulseFireUI.getInstance().getDeviceData();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, Charset.forName("UTF-8")));
            writer.append("#??pulsefire??");
            writer.append(System.getProperty("line.separator"));
            this.writeConfigCommand(writer, devData.getDeviceParameter(CommandName.chip_version));
            this.writeConfigCommand(writer, devData.getDeviceParameter(CommandName.chip_name));
            this.writeConfigCommand(writer, devData.getDeviceParameter(CommandName.chip_name_id));
            for (CommandName cn : CommandName.values()) {
                if (!CommandVariableType.CONF.equals((Object)cn.getType())) continue;
                if (cn.isIndexedA()) {
                    for (int i = 0; i < cn.getMaxIndexA(); ++i) {
                        Command cmd = devData.getDeviceParameterIndexed(cn, Integer.valueOf(i));
                        this.writeConfigCommand(writer, cmd);
                    }
                    continue;
                }
                Command cmd = devData.getDeviceParameter(cn);
                this.writeConfigCommand(writer, cmd);
            }
            writer.append("# END");
            writer.append(System.getProperty("line.separator"));
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        finally {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void writeConfigCommand(Writer writer, Command cmd) throws IOException {
        if (cmd == null) {
            return;
        }
        String cmdLine = CommandWire.encodeCommand((Command)cmd, (boolean)true);
        writer.append(cmdLine);
        writer.append(System.getProperty("line.separator"));
        writer.flush();
    }

    private void readConfig(InputStream input) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, Charset.forName("UTF-8")));
        String line = reader.readLine();
        if (!line.startsWith("#??pulsefire??")) {
            this.logger.warning("No magic header found in line: '" + line + "'");
            reader.close();
            return;
        }
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.startsWith("#")) continue;
            int idxComment = line.indexOf("#");
            if (idxComment > 1) {
                line = line.substring(0, idxComment);
            }
            if (line.startsWith("chip")) continue;
            try {
                Command cmd = CommandWire.decodeCommand((String)line);
                PulseFireUI.getInstance().getDeviceManager().requestCommand(cmd).waitForResponse();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        reader.close();
    }

    private JPanel createSystemIO() {
        JPanel wrapPanel = JComponentFactory.createJFirePanel(this, "io");
        JPanel ioPanel = new JPanel();
        ioPanel.setLayout(new SpringLayout());
        ioPanel.add(new JCommandLabel(CommandName.lcd_size));
        ioPanel.add(new JCommandComboBox(CommandName.lcd_size));
        ioPanel.add(new JCommandLabel(CommandName.dev_volt_dot));
        ioPanel.add(new JCommandComboBox(CommandName.dev_volt_dot));
        ioPanel.add(new JCommandLabel(CommandName.dev_amp_dot));
        ioPanel.add(new JCommandComboBox(CommandName.dev_amp_dot));
        ioPanel.add(new JCommandLabel(CommandName.dev_temp_dot));
        ioPanel.add(new JCommandComboBox(CommandName.dev_temp_dot));
        SpringLayoutGrid.makeCompactGrid(ioPanel, 4, 2);
        wrapPanel.add(ioPanel);
        return wrapPanel;
    }

    private JPanel createSystemWarmup() {
        JPanel wrapPanel = JComponentFactory.createJFirePanel(this, "warmup");
        wrapPanel.setLayout(new BoxLayout(wrapPanel, 3));
        JPanel warmDialPanel = new JPanel();
        warmDialPanel.setLayout(new FlowLayout(0));
        warmDialPanel.add(JComponentFactory.createJPanelJWrap(new JCommandDial(CommandName.swc_delay)));
        warmDialPanel.add(JComponentFactory.createJPanelJWrap(new JCommandDial(CommandName.swc_secs)));
        warmDialPanel.add(JComponentFactory.createJPanelJWrap(new JCommandDial(CommandName.swc_duty)));
        wrapPanel.add(warmDialPanel);
        JPanel warmPanel = new JPanel();
        warmPanel.add(new JFireQMapTable(CommandName.swc_map, "warmup", "normal"));
        wrapPanel.add(warmPanel);
        return wrapPanel;
    }

    @Override
    public Class<?> getTabClassName() {
        return this.getClass();
    }

    class ChipConfigFileFilter
    extends FileFilter {
        public static final String CONFIG_EXT = ".pfcc";
        private static final String DESC = "*.pfcc - PulseFire ChipConfig";

        ChipConfigFileFilter() {
        }

        @Override
        public String getDescription() {
            return DESC;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(CONFIG_EXT);
        }
    }
}

