# pygsear
# Copyright (C) 2003 Lee Harr
#
#
# This file is part of pygsear.
#
# pygsear is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# pygsear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with pygsear; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


import random

import Shape
from conf import *

small = [getattr(Shape, name) for name in ['N1Shape', 'N2IShape', 'N3IShape', 'N3LShape']]
medium = [getattr(Shape, name) for name in dir(Shape) if name.startswith('N4')]
large = [getattr(Shape, name) for name in dir(Shape) if name.startswith('N5')]

class Level:
    levels = {  0:    {'ticks': TICKS,
                        'shape_types': small,
                        'next_score': 150,
                        'next_lines': 3},
                1:    {'ticks': TICKS - 175,
                        'shape_types': small,
                        'next_score': 150,
                        'next_lines': 3},
                2:    {'ticks': TICKS + 100,
                        'shape_types': medium,
                        'next_score': 600,
                        'next_lines': 7},
                3:    {'ticks': TICKS,
                        'shape_types': small + medium,
                        'next_score': 800,
                        'next_lines': 9},
                4:    {'ticks': TICKS,
                        'shape_types': medium + [random.choice(large)],
                        'next_score': 1200,
                        'next_lines': 5},
                5:    {'ticks': TICKS,
                        'shape_types': medium + random.sample(large, 2),
                        'next_score': 1500,
                        'next_lines': 5},
                6:    {'ticks': TICKS,
                        'shape_types': large,
                        'next_score': 1500,
                        'next_lines': 4},
    }


    def __init__(self):
        self.next()

    def next(self):
        if not hasattr(self, 'level'):
            self.level = 0
        else:
            self.level += 1
        self.score = 0
        self.lines = 0

        levels = self.levels
        level = self.level
        try:
            level_conf = levels[level]
        except KeyError:
            self.ticks = int(self.ticks * 0.9)
            self.next_score = 500 * level
            self.next_lines = 4 * level
        else:
            self.ticks = level_conf['ticks']
            self.shape_types = level_conf['shape_types']
            self.next_score = level_conf['next_score']
            self.next_lines = level_conf['next_lines']



class KidLevel(Level):
    levels = {  0:    {'ticks': TICKS,
                        'shape_types': random.sample(small, 2),
                        'next_score': 50,
                        'next_lines': 2},
                1:    {'ticks': TICKS,
                        'shape_types': small,
                        'next_score': 150,
                        'next_lines': 3},
                2:    {'ticks': TICKS - 100,
                        'shape_types': small,
                        'next_score': 400,
                        'next_lines': 4},
                3:    {'ticks': TICKS - 200,
                        'shape_types': small,
                        'next_score': 500,
                        'next_lines': 5},
                4:    {'ticks': TICKS,
                        'shape_types': small + [random.choice(medium)],
                        'next_score': 800,
                        'next_lines': 4},
                5:    {'ticks': TICKS - 100,
                        'shape_types': small + random.sample(medium, 2),
                        'next_score': 800,
                        'next_lines': 4},
                6:    {'ticks': TICKS,
                        'shape_types': small + medium,
                        'next_score': 1500,
                        'next_lines': 4},
                7:    {'ticks': TICKS,
                        'shape_types': medium,
                        'next_score': 1500,
                        'next_lines': 4},
    }
