package transcript;

#   Rebot 0.10 (beta): Bot para aventuras de texto por red
#   Mdulo de transcript versin 0.5
#   http://aventuras.presi.org/rebot
#   (C) 2005,2007 Enrique D. Bosch 'presi'
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License 
#   along with this program.  If not, see <http://www.gnu.org/licenses/>. 

use transcript_conf;
use Encode;

BEGIN
{
  $mod_lang="transcript_lang_$rebot_conf::language";
  eval "require $mod_lang";
  $prompt=$transcript_conf::prompt;
  $filename=$transcript_conf::ini_filename;
  $pausa=0;
  $ini_cont=!$transcript_conf::ini_overwrite;
  my $input=$transcript_conf::input;
  if ($input)
  { 
    if (!open($flujo_entrada,"< $input"))
    {
      salida("$MSG_errfile $MSG_errinput\n");
      $flujo_entrada=STDIN;
    }
  }
  else { $flujo_entrada=STDIN; }
}

# Funciones requeridas por la interfaz con el ncleo de rebot


sub texto_inicial { return $MSG_ini; }

sub texto_ayuda { return $MSG_help; }

sub configurar
{
  enviar_mensaje('transcript',$main::texto_inicial."\n".texto_inicial());
  open_trfile($filename,$ini_cont);
}

sub conectar
{
  main::modo('comando');

  while (1)
  {
    salida($prompt);
    $inp=entrada();
    salida("$prompt$inp\n",SALIDA);
    main::tratar_texto($inp);
  }
}

sub enviar_mensaje
{
   my $texto=$_[1];

   salida($texto."\n");
   salida($texto."\n",SALIDA);
   $|=1;
}

sub comando
{
  my $com=$_[2];
  my $arg=$_[3];

  if ($com eq $COM_file)
  {
    if ($arg eq '')
    {
      if ($filename ne '')
      {
        salida("$MSG_fact $filename\n");
        salida($MSG_over);
        my $sn=lc(entrada());
        if ($sn eq $COM_yes) { $arg=$filename; }
        elsif (($arg=nuevo_fichero()) eq '') { return 1; }
      }
      elsif (($arg=nuevo_fichero()) eq '') { return 1; }
    }
    close_trfile();
    open_trfile($arg);
    $pausa=0;
  }
  elsif ($com eq $COM_paus)
  {
    if ($filename eq '') { salida("$MSG_nop\n"); return 1; }
    if ($pausa) { $pausa=0; open_trfile($filename,1); }
    else { $pausa=1; close_trfile(); }
  }
  elsif ($com eq $COM_del)
  {
    close_trfile();
    unlink($filename);
    salida("$filename $MSG_dele\n");
    $filename='';
  }
  elsif ($com eq $COM_exit) { close_trfile(); exit; }
  else { return 0; }
  return 1;
}

# Funciones internas

sub open_trfile
{
  my $trfile=$_[0];
  my $cont=$_[1];
  my $mmodo='>';

  if ($trfile eq '') { salida("$MSG_nof\n"); return 0; }
  if (!$fileopen)
  {
    if ($trfile eq '') { return 0; };

    if ($cont) { $mmodo='>>'; }
    if (!open(SALIDA,"$mmodo $trfile")) { salida("$MSG_errfile\n"); return 0; }
    SALIDA->autoflush(1);
    $filename=$trfile;
    $fileopen=1;
    salida("$trfile $MSG_opened\n");
    if ($cont) { salida("$MSG_contr\n",SALIDA); }
    else { salida("$MSG_cotr\n",SALIDA); }
  }
}

sub close_trfile
{
  if ($filename eq '') { return 0; }

  if ($fileopen)
  {
    salida("$MSG_fitr\n",SALIDA);
    close(SALIDA);
    $fileopen=0;
    salida("$filename $MSG_closed\n");
  }
  else { salida("$MSG_noc\n"); }
}

sub nuevo_fichero
{
  salida($MSG_prompt_file);
  return entrada();
}

sub entrada
{
  my $ent=$_[0];

  $/="\n";
  $ent=<$flujo_entrada>;
  chomp($ent);
  undef $/;
  return $ent;
}

sub salida
{
  my $texto=$_[0];
  my $flujo=$_[1];

  if (!defined($flujo))
  {
    if ($transcript_conf::quiet) { return; }
    $flujo=STDOUT;
  }

  $texto=encode($transcript_conf::encoding,$texto);

  print $flujo $texto;
}


BEGIN
{
  $MSG_ini=${qq(${mod_lang}::ini)};
  $MSG_fact=${qq(${mod_lang}::fact)};
  $MSG_over=${qq(${mod_lang}::over)};
  $MSG_prompt_file=${qq(${mod_lang}::prompt_file)};
  $MSG_errfile=${qq(${mod_lang}::errfile)};
  $MSG_errinput=${qq(${mod_lang}::errinput)};
  $MSG_opened=${qq(${mod_lang}::opened)};
  $MSG_closed=${qq(${mod_lang}::closed)};
  $MSG_cotr=${qq(${mod_lang}::cotr)};
  $MSG_contr=${qq(${mod_lang}::contr)};
  $MSG_nof=${qq(${mod_lang}::nof)};
  $MSG_noc=${qq(${mod_lang}::noc)};
  $MSG_nop=${qq(${mod_lang}::nop)};
  $MSG_fitr=${qq(${mod_lang}::fitr)};
  $MSG_dele=${qq(${mod_lang}::dele)};
  $MSG_help=${qq(${mod_lang}::help)};
  $COM_file=${qq(${mod_lang}::file)};
  $COM_exit=${qq(${mod_lang}::exit)};
  $COM_paus=${qq(${mod_lang}::paus)};
  $COM_del=${qq(${mod_lang}::del)};
  $COM_yes=${qq(${mod_lang}::yes)};
}

1;
