package floydzx;

#   Rebot 0.10: Bot para aventuras de texto por red
#   Mdulo de multijuador floydzx (versin 0.2)
#   http://aventuras.presi.org/rebot
#   (C) 2007 Enrique D. Bosch 'presi'
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License 
#   along with this program.  If not, see <http://www.gnu.org/licenses/>. 

# Soporte multijugador del antiguo protocolo usado por los bots
# floyd y zx en conjuncin con sus libreras para Inform/Informate

use floydzx_conf;

use functions;
use Digest::MD5 qw(md5_base64);

@methods=('none','digest','filter');

$filt_met=$floydzx_conf::nick_conv;
$long_id=15;

sub init {}

sub init_adv    # Inicializacin cuando comienza la aventura
{
  undef %tabla_usuarios;
  if ($main::interprete eq 'dfrotz') { return '\cm'."\n".'\ch1'; }
  else { return 0; }
}

sub args
{
  my $arg=$_[1];

  if (functions::esta_en($arg,\@methods)) { $filt_met=$arg; return 1; }
  else { return 0; }
}

sub filtro_in
{
  my $texto=$_[1];
  my $usuario=filtro_usuario_in($_[2]);

  return "$usuario, $texto";  
}


sub filtro_out
{
  my $texto=$_[1];
  local (*publico)=$_[2];
  my %salida;
  my @evitar=( ' ' , "\n" , '  ' );

  while ($texto=~m/([^<]*)<whisper( |\n)+([^>]+)>([^<]*)<\/whisper>([^<]*)/g)
  {
    my $usuario=filtro_usuario_out($3);
    my $te_user=$4;
    my $tmp_pub=$1.$5;

    if (!functions::esta_en($tmp_pub,\@evitar)) { $publico.="\n".$tmp_pub; }
    if (!functions::esta_en($te_user,\@evitar)) { $salida{$usuario}.="\n".$te_user; }
  }
  return %salida;
}


sub close {}

sub close_adv
{
  undef %tabla_usuarios;
}

# Funciones internas

sub filtro_usuario_in
{
  my $usuario=$_[0];
  my $result;

  if ($filt_met eq 'digest')
  {
    $result=lc(substr(md5_base64($usuario),0,$long_id));
    $tabla_usuarios{$result}=$usuario;
  }
  elsif ($filt_met eq 'filter')
  {
    $result=lc(substr($usuario,0,$long_id));
    $result=~tr/.,/xy/;
    $tabla_usuarios{$result}=$usuario;
  }
  else { $result=$usuario; }

  return $result;
}

sub filtro_usuario_out
{
  my $valor=$_[0];
  my $result;

  if ($filt_met eq 'digest' || $filt_met eq 'filter')
  {
    $result=$tabla_usuarios{$valor};
  }
  else { $result=$valor; }

  return $result;
}

1;
