package irc;

#   Rebot 0.8 (beta): Bot para aventuras de texto por red
#   Mdulo de protocolo IRC
#   http://aventuras.presi.org/rebot
#   (C) 2005 Enrique D. Bosch 'presi'
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#   http://www.gnu.org/licenses/gpl.html

require Net::IRC;
use irc_conf;
use functions;

$n_nick=0;
$nick_auth=0;
$nick_actual=$irc_conf::nick;
$cambio=$irc_conf::pref_commands;
$hay_comando=0;
$c_donde='';
$c_quien='';
$c_comando='';
$c_arg='';
$master_auth=0;
$usuario_maestro=lc($irc_conf::master_user);

# Funciones requeridas por la interfaz con el ncleo de rebot

sub texto_inicial
{
  return 'Mdulo de protocolo IRC versin 0.8 (beta) para rebot';
}

sub texto_ayuda
{
  my $t_com;

  if ($cambio)
    {
      $t_com='Los comandos (tanto del bot como del juego)
estando en canal pblico deben comenzar por . , # , \' o !';
    }
  else
    {
       $t_com='Las lneas que comiencen por . , # , \' o ! son
ignoradas (por ejemplo para poner comentarios)';
    }
  return
  '  canal <canal>
     Cambia el canal de IRC en el que rebot est.
  master [password]
     Autentifica al usuario maestro mediante password.
  op [password]
     Da op si se es el usuario maestro. Se deber especificar
     la password de usuario maestro si es necesaria.
  salir
     Termina la ejecucin del bot.'."\n".$t_com.
  "\nesto puede cambiarse con el comando 'cambio' o 'cambiar'.\n".
  'Algunos de estos comandos pueden estar permitidos slo a
usuarios con op o al usuario maestro.';
}

sub configurar
{
    $irc=new Net::IRC;

    $conexion=$irc->newconn
    (
      Server   => $irc_conf::server,
      Port     => $irc_conf::port,
      Nick     => $irc_conf::nick,
      Ircname  => $irc_conf::ircname,
      Username => $irc_conf::username
    );

    $conexion->{channel}=$irc_conf::chan;
    $conexion->add_handler('376', \&irc_on_connect);
    $conexion->add_handler('public', \&irc_on_public);
    if ($irc_conf::priv) { $conexion->add_handler('msg', \&irc_on_msg); }
    $conexion->add_handler('nicknameinuse', \&irc_on_nicknameinuse);
    $conexion->add_handler('whoischannels', \&irc_on_whoischannels);
    $conexion->add_handler('cping', \&irc_on_ping);
    $conexion->add_handler('cversion', \&irc_on_version);
}

sub conectar
{
   ${main::log}->eslog("irc: Conectando a $nick_actual".'@'."$irc_conf::server:$irc_conf::port");
   $irc->start();
   ${main::log}->eslog('irc: Desconectado');
}

sub enviar_mensaje   # Separa un texto en lneas y lo enva introduciendo un retardo para evitar el flood
{
   my $texto=$_[1];
   my $donde=$_[2];
   my @lineas=split("\n",$texto);
   foreach my $linea (@lineas)
    {
      my @sublineas=functions::textwrap($linea,$irc_conf::max_line);
      foreach my $sublinea (@sublineas)
       {
         irc_enviar_mensaje($sublinea,$donde);
         sleep $irc_conf::delay;
       }
    }
}

sub comando
{
  # Recoge los argumentos y enva un whois al usuario originador
  # el comando se parsear en irc_comando (si se autoriza)
  # en la respuesta al evento whoischannel

  my @elem=@_;
  my $quien=$c_quien;
  $c_donde=$elem[1];
  $c_comando=$elem[2];
  $c_arg=$elem[3];
  $hay_comando=1;

  $conexion->whois($quien);
  return 1;
}


# Funciones privadas especficas de irc


BEGIN
{

sub irc_on_connect 
{
   my $conexion=$_[0];

   ${main::log}->eslog('irc: Conectado');
   if ($nick_auth==0) { irc_nick_auth($conexion,$irc_conf::nick,$irc_conf::password); }
   if ($irc_conf::mode ne '')
   {
     ${main::log}->eslog("irc: Estableciendo modo de usuario $irc_conf::mode");
     $conexion->mode($nick_actual,$irc_conf::mode);
   }
   if (substr($conexion->{channel},0,1) eq '#') { irc_entrar_canal($conexion); }
   enviar_mensaje('irc',$main::texto_inicial."\n".texto_inicial());
   main::modo('comando');
   $conexion->{connected}=1;
}

sub irc_on_public
{
   my ($conexion, $eventos) = @_;
   my $texto=$eventos->{args}[0];  # texto del canal
   my $quien=$eventos->nick;

   if (irc_no_comentario($texto))
   {
      $c_quien=$quien;
      if ($cambio) { $texto=substr($texto,1); }
      main::tratar_texto($texto);
   }
}

sub irc_on_msg
{
   my ($conexion, $eventos) = @_;
   my $texto=$eventos->{args}[0];  # texto del privado
   my $quien=$eventos->nick;

   ${main::log}->eslog("irc: Mensaje privado de '$quien'");
   $c_quien=$quien;
   main::tratar_texto($texto,$quien);
}

sub irc_on_whoischannels
{
   my ($conexion, $eventos) = @_;
   my $canales=lc($eventos->{args}[2]);
   my $canal_actual=lc($conexion->{channel});

   $c_quien=lc($c_quien);

   if ($hay_comando)
   {
     if ( $irc_conf::all_auth || 
          ($canales=~/\@$canal_actual/) || 
          ( ($c_quien eq $usuario_maestro) && 
                    ( $master_auth || 
                      ($irc_conf::master_pass eq '') || 
                      ($c_comando eq 'master') || 
                      ($c_comando eq 'op') 
                    ) 
          ) 
        )
      { 
        if ( irc_comando($c_donde,$c_comando,$c_arg) )
          { 
            enviar_mensaje('irc','Comando no reconocido',$c_donde);
            main::modo('',$donde);
          }
      }
     elsif ($irc_conf::errors)
      {
        ${main::log}->eslog("irc: Comando no autorizado de '$c_quien'");
        irc_no_autorizado($c_donde);
      }
     $hay_comando=0;
   }
}

sub irc_on_nicknameinuse
{
  my ($conexion, $eventos) = @_;
  my $viejo_nick;

  if ($n_nick)
    { $viejo_nick="$irc_conf::nick$n_nick"; }
  else
    { 
      $viejo_nick=$irc_conf::nick;
      if ( irc_nick_auth($conexion,$viejo_nick,$irc_conf::password) ) { $nick_auth=1; return 0; }
    }
  $n_nick++;
  $nick_actual="$irc_conf::nick$n_nick";
  $conexion->nick($nick_actual);
  ${main::log}->eslog("irc: Nick '$viejo_nick' en uso o registrado, cambiado a '$nick_actual'");
}

sub irc_on_ping
{
   my ($conexion, $eventos) = @_;
   my $quien=$eventos->nick;

   $conexion->ctcp_reply($quien,'PING '.join(' ',$eventos->args));
   ${main::log}->eslog("irc: CTCP Ping solicitado por '$quien'");
}

sub irc_on_version
{
   my ($conexion, $eventos) = @_;
   my $quien=$eventos->nick;

   $conexion->ctcp_reply($quien,'VERSION '.$main::linea1_texto_inicial);
   ${main::log}->eslog("irc: CTCP Version solicitado por '$quien'");
}

sub irc_enviar_mensaje
{
   my $texto=$_[0];
   my $quien=$_[1];

   if ($quien eq '') { $quien=$conexion->{channel}; };

   $conexion->privmsg($quien,$texto);
}

sub irc_entrar_canal
{
   my $conexion=$_[0];
   my $quien=$_[1];
   my $canal_ant=$_[2];

   $conexion->join($conexion->{channel});
   ${main::log}->eslog("irc: Entrando al canal $conexion->{channel}");
}

sub irc_salir_canal
{
   my $conexion=$_[0];
   my $quien=$_[1];

   if ($conexion->{channel} eq '') { return 2; }
   $conexion->part($conexion->{channel});
   ${main::log}->eslog("irc: Saliendo del canal $conexion->{channel}");
   $conexion->{channel}='';
}

sub irc_nick_auth
{
  my $conexion=$_[0];
  my $nick=$_[1];
  my $pass=$_[2];

  if ($pass ne '')
  {
    if ($irc_conf::nickbot eq '')
    {
      $conexion->sl("NICK $nick $pass");
    }
    else
    {
      $conexion->privmsg($irc_conf::nickbot,"identify $pass");
    }
    ${main::log}->eslog("irc: Nick '$nick' autentificado por password");
    return 1;
  }
  return 0;
}

sub irc_no_comentario
{
  my $texto=$_[0];

  my $primero=substr($texto,0,1);
  return (!(  $cambio xor ( ($primero eq '.') || ($primero eq "'") || ($primero eq '#') || ($primero eq '!') )  ));
}

sub irc_comando
{
  my $quien=$c_quien;
  my $donde=$_[0];
  my $comando=$_[1];
  my $arg=$_[2];

  if ($comando eq 'canal')
  {
    my $canal=$arg;

    if ($canal eq 'ninguno')
    {
       irc_salir_canal($conexion,$donde);
    }
    elsif (substr($canal,0,1) eq '#')
    {
       my $canal_ant=$conexion->{channel};
       irc_salir_canal($conexion,$donde);
       $conexion->{channel}=$canal;
       irc_entrar_canal($conexion,$donde,$canal_ant);
    }
    else { enviar_mensaje('irc','Todo canal empieza por #',$donde); }
  }
  elsif ( ($comando eq 'cambio') || ($comando eq 'cambiar') )
  {
    if ($cambio)
     {
       $cambio=0;
       enviar_mensaje('irc',"Los comentarios en el canal ahora deben empezar por . , ', # o !",$donde);
       ${main::log}->eslog("irc: Cambiados comentarios a . ' # !");
     }
    else
     {
       $cambio=1;
       enviar_mensaje('irc',"Los comandos en el canal ahora deben empezar por . , ' , # o !",$donde);
       ${main::log}->eslog("irc: Cambiados comentarios a NO . ' # !");
     }
  }
  elsif ( $comando eq 'master')
  {
    if ($quien eq '') { return 0; }
    if (($quien eq $usuario_maestro) && ($arg eq $irc_conf::master_pass) )
     {
       ${main::log}->eslog("irc: Autenticado el usuario maestro '$quien'");
       $master_auth=1;
     }
    else
     { 
       ${main::log}->eslog("irc: Usuario '$quien' no est autorizado para autenticarse como maestro");
       irc_no_autorizado($donde);
       return 0;
     }
  }
  elsif ( $comando eq 'op')
  {
    if ($quien eq '') { return 0; }
    if (($quien eq $usuario_maestro) && (($arg eq $irc_conf::master_pass) || $master_auth) )
     {
       $conexion->mode($conexion->{channel},'+o',$quien);
       ${main::log}->eslog("irc: Dando op al usuario maestro '$quien'");
       $master_auth=1;
     }
    else
     {
       ${main::log}->eslog("irc: Usuario '$quien' no est autorizado para obtener op");
       irc_no_autorizado($donde);
       return 0;
     }
  }
  elsif ( $comando eq 'salir' )
  {
    exit 0;
  }
  else { return $irc_conf::errors; }
  main::modo('',$donde);
  return 0;
}

sub irc_no_autorizado
{
  my $donde=$_[0];

  if ($irc_conf::errors)
    {
      enviar_mensaje('irc','No autorizado',$donde);
      main::modo('',$donde);
    }
}

}

1;
