package irc;

#   Rebot 0.9 (beta): Bot para aventuras de texto por red
#   Mdulo de protocolo IRC
#   http://aventuras.presi.org/rebot
#   (C) 2005 Enrique D. Bosch 'presi'
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#   http://www.gnu.org/licenses/gpl.html

require Net::IRC;
use irc_conf;
use functions;

BEGIN
{
  $mod_lang="irc_lang_$rebot_conf::language";
  eval "require $mod_lang";
}

$n_nick=0;
$nick_auth=0;
$nick_actual=$irc_conf::nick;
$cambio=$irc_conf::pref_commands;
$hay_comando=0;
$c_donde='';
$c_quien='';
$c_comando='';
$c_arg='';
$master_auth=0;
$usuario_maestro=lc($irc_conf::master_user);

# Funciones requeridas por la interfaz con el ncleo de rebot

sub texto_inicial
{
  return $MSG_ini;
}

sub texto_ayuda
{
  my $t_com;

  if ($cambio) { $t_com=$MSG_help_c;  }
  else         { $t_com=$MSG_help_nc; }
  return $MSG_help1.$t_com.$MSG_help2;
}

sub configurar
{
    $irc=new Net::IRC;

    $conexion=$irc->newconn
    (
      Server   => $irc_conf::server,
      Port     => $irc_conf::port,
      Nick     => $irc_conf::nick,
      Ircname  => $irc_conf::ircname,
      Username => $irc_conf::username
    );

    $conexion->{channel}=$irc_conf::chan;
    $conexion->add_handler('376', \&irc_on_connect);
    $conexion->add_handler('public', \&irc_on_public);
    if ($irc_conf::priv) { $conexion->add_handler('msg', \&irc_on_msg); }
    $conexion->add_handler('nicknameinuse', \&irc_on_nicknameinuse);
    $conexion->add_handler('whoischannels', \&irc_on_whoischannels);
    $conexion->add_handler('cping', \&irc_on_ping);
    $conexion->add_handler('cversion', \&irc_on_version);
}

sub conectar
{
   ${main::log}->eslog("irc: Conectando a $nick_actual".'@'."$irc_conf::server:$irc_conf::port",3);
   $irc->start();
   ${main::log}->eslog('irc: Desconectado',3);
}

sub enviar_mensaje   # Separa un texto en lneas y lo enva introduciendo un retardo para evitar el flood
{
   my $texto=$_[1];
   my $donde=$_[2];
   my @lineas=split("\n",$texto);
   foreach my $linea (@lineas)
    {
      my @sublineas=functions::textwrap($linea,$irc_conf::max_line);
      foreach my $sublinea (@sublineas)
       {
         irc_enviar_mensaje($sublinea,$donde);
         sleep $irc_conf::delay;
       }
    }
}

sub comando
{
  # Recoge los argumentos y enva un whois al usuario originador
  # el comando se parsear en irc_comando (si se autoriza)
  # en la respuesta al evento whoischannel

  my @elem=@_;
  my $quien=$c_quien;
  $c_donde=$elem[1];
  $c_comando=$elem[2];
  $c_arg=$elem[3];
  $hay_comando=1;

  $conexion->whois($quien);
  return 1;
}


# Funciones privadas especficas de irc


BEGIN
{

sub irc_on_connect 
{
   my $conexion=$_[0];

   ${main::log}->eslog($MSG_connected,4);
   if ($nick_auth==0) { irc_nick_auth($conexion,$irc_conf::nick,$irc_conf::password); }
   if ($irc_conf::mode ne '')
   {
     ${main::log}->eslog("$MSG_mod $irc_conf::mode",2);
     $conexion->mode($nick_actual,$irc_conf::mode);
   }
   if (substr($conexion->{channel},0,1) eq '#') { irc_entrar_canal($conexion); }
   enviar_mensaje('irc',$main::texto_inicial."\n".texto_inicial());
   main::modo('comando');
   $conexion->{connected}=1;
}

sub irc_on_public
{
   my ($conexion, $eventos) = @_;
   my $texto=$eventos->{args}[0];  # texto del canal
   my $quien=$eventos->nick;

   if (irc_no_comentario($texto))
   {
      $c_quien=$quien;
      if ($cambio) { $texto=substr($texto,1); }
      main::tratar_texto($texto);
   }
}

sub irc_on_msg
{
   my ($conexion, $eventos) = @_;
   my $texto=$eventos->{args}[0];  # texto del privado
   my $quien=$eventos->nick;

   ${main::log}->eslog("$MSG_priv '$quien'",3);
   $c_quien=$quien;
   main::tratar_texto($texto,$quien);
}

sub irc_on_whoischannels
{
   my ($conexion, $eventos) = @_;
   my $canales=lc($eventos->{args}[2]);
   my $canal_actual=lc($conexion->{channel});

   $c_quien=lc($c_quien);

   if ($hay_comando)
   {
     if ( $irc_conf::all_auth || 
          ($canales=~/\@$canal_actual/) || 
          ( ($c_quien eq $usuario_maestro) && 
                    ( $master_auth || 
                      ($irc_conf::master_pass eq '') || 
                      ($c_comando eq 'master') || 
                      ($c_comando eq 'op') 
                    ) 
          ) 
        )
      { 
        if ( irc_comando($c_donde,$c_comando,$c_arg) )
          { 
            enviar_mensaje('irc',$MSG_no_com,$c_donde);
            main::modo('',$donde);
          }
      }
     elsif ($irc_conf::errors)
      {
        ${main::log}->eslog("$MSG_no_com_aut '$c_quien'",4);
        irc_no_autorizado($c_donde);
      }
     $hay_comando=0;
   }
}

sub irc_on_nicknameinuse
{
  my ($conexion, $eventos) = @_;
  my $viejo_nick;

  if ($n_nick)
    { $viejo_nick="$irc_conf::nick$n_nick"; }
  else
    { 
      $viejo_nick=$irc_conf::nick;
      if ( irc_nick_auth($conexion,$viejo_nick,$irc_conf::password) ) { $nick_auth=1; return 0; }
    }
  $n_nick++;
  $nick_actual="$irc_conf::nick$n_nick";
  $conexion->nick($nick_actual);
  ${main::log}->eslog("$MSG_nick '$viejo_nick' $MSG_uso '$nick_actual'",3);
}

sub irc_on_ping
{
   my ($conexion, $eventos) = @_;
   my $quien=$eventos->nick;

   $conexion->ctcp_reply($quien,'PING '.join(' ',$eventos->args));
   ${main::log}->eslog("$MSG_ping '$quien'",3);
}

sub irc_on_version
{
   my ($conexion, $eventos) = @_;
   my $quien=$eventos->nick;

   $conexion->ctcp_reply($quien,'VERSION '.$main::linea1_texto_inicial);
   ${main::log}->eslog("$MSG_version '$quien'",3);
}

sub irc_enviar_mensaje
{
   my $texto=$_[0];
   my $quien=$_[1];

   if ($quien eq '') { $quien=$conexion->{channel}; };

   $conexion->privmsg($quien,$texto);
}

sub irc_entrar_canal
{
   my $conexion=$_[0];
   my $quien=$_[1];
   my $canal_ant=$_[2];

   $conexion->join($conexion->{channel});
   ${main::log}->eslog("$MSG_join $conexion->{channel}",3);
}

sub irc_salir_canal
{
   my $conexion=$_[0];
   my $quien=$_[1];

   if ($conexion->{channel} eq '') { return 2; }
   $conexion->part($conexion->{channel});
   ${main::log}->eslog("$MSG_part $conexion->{channel}",3);
   $conexion->{channel}='';
}

sub irc_nick_auth
{
  my $conexion=$_[0];
  my $nick=$_[1];
  my $pass=$_[2];

  if ($pass ne '')
  {
    if ($irc_conf::nickbot eq '')
    {
      $conexion->sl("NICK $nick $pass");
    }
    else
    {
      $conexion->privmsg($irc_conf::nickbot,"identify $pass");
    }
    ${main::log}->eslog("$MSG_nick '$nick' $MSG_aut",3);
    return 1;
  }
  return 0;
}

sub irc_no_comentario
{
  my $texto=$_[0];

  my $primero=substr($texto,0,1);
  return (!(  $cambio xor ( ($primero eq '.') || ($primero eq "'") || ($primero eq '#') || ($primero eq '!') )  ));
}

sub irc_comando
{
  my $quien=$c_quien;
  my $donde=$_[0];
  my $comando=$_[1];
  my $arg=$_[2];

  if ($comando eq $COM_canal)
  {
    my $canal=$arg;

    if ($canal eq 'ninguno')
    {
       irc_salir_canal($conexion,$donde);
    }
    elsif (substr($canal,0,1) eq '#')
    {
       my $canal_ant=$conexion->{channel};
       irc_salir_canal($conexion,$donde);
       $conexion->{channel}=$canal;
       irc_entrar_canal($conexion,$donde,$canal_ant);
    }
    else { enviar_mensaje('irc','Todo canal empieza por #',$donde); }
  }
  elsif ( ($comando eq $COM_cambio) || ($comando eq $COM_cambiar) )
  {
    if ($cambio)
     {
       $cambio=0;
       ${main::log}->eslog($MSG_com,2);
       enviar_mensaje('irc',$MSG_come,$donde);
     }
    else
     {
       $cambio=1;
       ${main::log}->eslog($MSG_com_no,2);
       enviar_mensaje('irc',$MSG_coma,$donde);
     }
  }
  elsif ( $comando eq $COM_master)
  {
    if ($quien eq '') { return 0; }
    if (($quien eq $usuario_maestro) && ($arg eq $irc_conf::master_pass) )
     {
       $master_auth=1;
       ${main::log}->eslog("$MSG_aut_master '$quien'",4);
       enviar_mensaje('irc',$MSG_aut,$donde);
     }
    else
     { 
       ${main::log}->eslog("$MSG_user '$quien' $MSG_no_master",4);
       irc_no_autorizado($donde);
       return 0;
     }
  }
  elsif ( $comando eq $COM_op)
  {
    if ($quien eq '') { return 0; }
    if (($quien eq $usuario_maestro) && (($arg eq $irc_conf::master_pass) || $master_auth) )
     {
       $conexion->mode($conexion->{channel},'+o',$quien);
       $master_auth=1;
       ${main::log}->eslog("$MSG_op_master '$quien'",4);
     }
    else
     {
       ${main::log}->eslog("$MSG_user '$quien' $MSG_no_op",4);
       irc_no_autorizado($donde);
       return 0;
     }
  }
  elsif ( $comando eq $COM_finalizar )
  {
    if ($quien eq '') { return 0; }
    if (($quien eq $usuario_maestro) && $master_auth)
     {
       $master_auth=0;
       ${main::log}->eslog("$MSG_user '$quien' $MSG_deaut",4);
       enviar_mensaje('irc',$MSG_deaut_m,$donde);
     }
    else
     {
       ${main::log}->eslog("$MSG_user '$quien' $MSG_no_deaut",4);
       irc_no_autorizado($donde);
       return 0;
     }
  }
  elsif ( $comando eq $COM_salir )
  {
    exit 0;
  }
  else { return $irc_conf::errors; }
  main::modo('',$donde);
  return 0;
}

sub irc_no_autorizado
{
  my $donde=$_[0];

  if ($irc_conf::errors)
    {
      enviar_mensaje('irc',$MSG_no_aut,$donde);
      main::modo('',$donde);
    }
}

}

BEGIN      # Extrayendo mensajes y comandos para simplificar sintaxis
{
  $MSG_ini=${qq(${mod_lang}::ini)};
  $MSG_connected=${qq(${mod_lang}::connected)};
  $MSG_mod=${qq(${mod_lang}::mod)};
  $MSG_priv=${qq(${mod_lang}::priv)};
  $MSG_no_com=${qq(${mod_lang}::no_com)};
  $MSG_no_com_aut=${qq(${mod_lang}::no_com_aut)};
  $MSG_nick=${qq(${mod_lang}::nick)};
  $MSG_uso=${qq(${mod_lang}::uso)};
  $MSG_ping=${qq(${mod_lang}::ping)};
  $MSG_version=${qq(${mod_lang}::version)};
  $MSG_join=${qq(${mod_lang}::join)};
  $MSG_part=${qq(${mod_lang}::part)};
  $MSG_aut=${qq(${mod_lang}::aut)};
  $MSG_come=${qq(${mod_lang}::come)};
  $MSG_coma=${qq(${mod_lang}::coma)};
  $MSG_com=${qq(${mod_lang}::com)};
  $MSG_com_no=${qq(${mod_lang}::com_no)};
  $MSG_aut_master=${qq(${mod_lang}::aut_master)};
  $MSG_aut=${qq(${mod_lang}::aut)};
  $MSG_user=${qq(${mod_lang}::user)};
  $MSG_no_master=${qq(${mod_lang}::no_master)};
  $MSG_op_master=${qq(${mod_lang}::op_master)};
  $MSG_no_op=${qq(${mod_lang}::no_op)};
  $MSG_no_aut=${qq(${mod_lang}::no_aut)};
  $MSG_no_deaut=${qq(${mod_lang}::no_deaut)};
  $MSG_deaut=${qq(${mod_lang}::deaut)};
  $MSG_deaut_m=${qq(${mod_lang}::deaut_m)};
  $MSG_help_c=${qq(${mod_lang}::help_c)};
  $MSG_help_nc=${qq(${mod_lang}::help_nc)};
  $MSG_help1=${qq(${mod_lang}::help1)};
  $MSG_help2=${qq(${mod_lang}::help2)};
  $COM_canal=${qq(${mod_lang}::canal)};
  $COM_cambio=${qq(${mod_lang}::cambio)};
  $COM_cambiar=${qq(${mod_lang}::cambiar)};
  $COM_master=${qq(${mod_lang}::master)};
  $COM_op=${qq(${mod_lang}::op)};
  $COM_finalizar=${qq(${mod_lang}::finalizar)};
  $COM_salir=${qq(${mod_lang}::salir)};
}

1;
