/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.axes.AncestorContext;
import org.apache.commons.jxpath.ri.axes.AttributeContext;
import org.apache.commons.jxpath.ri.axes.ChildContext;
import org.apache.commons.jxpath.ri.axes.DescendantContext;
import org.apache.commons.jxpath.ri.axes.NamespaceContext;
import org.apache.commons.jxpath.ri.axes.ParentContext;
import org.apache.commons.jxpath.ri.axes.PrecedingOrFollowingContext;
import org.apache.commons.jxpath.ri.axes.PredicateContext;
import org.apache.commons.jxpath.ri.axes.SelfContext;
import org.apache.commons.jxpath.ri.axes.SimplePathInterpreter;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.NameAttributeTest;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.Step;
import org.apache.commons.jxpath.ri.model.NodePointer;

public abstract class Path
extends Expression {
    private Step[] steps;
    public static final String BASIC_PATH_HINT = "basicPathHint";
    private boolean basicKnown = false;
    private boolean basic;

    public Path(int typeCode, Step[] steps) {
        super(typeCode);
        this.steps = steps;
    }

    public Step[] getSteps() {
        return this.steps;
    }

    public boolean computeContextDependent() {
        if (this.steps != null) {
            int i = 0;
            while (i < this.steps.length) {
                if (this.steps[i].isContextDependent()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isSimplePath() {
        if (!this.basicKnown) {
            this.basicKnown = true;
            this.basic = true;
            Step[] steps = this.getSteps();
            int i = 0;
            while (i < steps.length) {
                if (steps[i].getAxis() != 2 || !(steps[i].getNodeTest() instanceof NodeNameTest) || ((NodeNameTest)steps[i].getNodeTest()).getNodeName().getName().equals("*")) {
                    this.basic = false;
                    break;
                }
                if (this.basic) {
                    this.basic = this.areBasicPredicates(steps[i].getPredicates());
                }
                ++i;
            }
        }
        return this.basic;
    }

    protected boolean areBasicPredicates(Expression[] predicates) {
        if (predicates != null && predicates.length != 0) {
            boolean firstIndex = true;
            int i = 0;
            while (i < predicates.length) {
                if (predicates[i] instanceof NameAttributeTest) {
                    if (((NameAttributeTest)predicates[i]).getNameTestExpression().isContextDependent()) {
                        return false;
                    }
                } else {
                    if (predicates[i].isContextDependent()) {
                        return false;
                    }
                    if (!firstIndex) {
                        return false;
                    }
                    firstIndex = false;
                }
                ++i;
            }
        }
        return true;
    }

    protected Pointer getSingleNodePointerForSteps(EvalContext context) {
        if (this.steps.length == 0) {
            return context.getSingleNodePointer();
        }
        if (this.isSimplePath()) {
            NodePointer ptr = (NodePointer)context.getSingleNodePointer();
            return SimplePathInterpreter.interpretPath(context, ptr, this.steps);
        }
        int i = 0;
        while (i < this.steps.length) {
            context = this.createContextForStep(context, this.steps[i].getAxis(), this.steps[i].getNodeTest());
            Expression[] predicates = this.steps[i].getPredicates();
            if (predicates != null) {
                int j = 0;
                while (j < predicates.length) {
                    context = new PredicateContext(context, predicates[j]);
                    ++j;
                }
            }
            ++i;
        }
        return context.getSingleNodePointer();
    }

    protected EvalContext evalSteps(EvalContext context) {
        if (this.steps.length == 0) {
            return context;
        }
        int i = 0;
        while (i < this.steps.length) {
            context = this.createContextForStep(context, this.steps[i].getAxis(), this.steps[i].getNodeTest());
            Expression[] predicates = this.steps[i].getPredicates();
            if (predicates != null) {
                int j = 0;
                while (j < predicates.length) {
                    context = new PredicateContext(context, predicates[j]);
                    ++j;
                }
            }
            ++i;
        }
        return context;
    }

    protected EvalContext createContextForStep(EvalContext context, int axis, NodeTest nodeTest) {
        switch (axis) {
            case 4: {
                return new AncestorContext(context, false, nodeTest);
            }
            case 10: {
                return new AncestorContext(context, true, nodeTest);
            }
            case 5: {
                return new AttributeContext(context, nodeTest);
            }
            case 2: {
                return new ChildContext(context, nodeTest, false, false);
            }
            case 9: {
                return new DescendantContext(context, false, nodeTest);
            }
            case 13: {
                return new DescendantContext(context, true, nodeTest);
            }
            case 8: {
                return new PrecedingOrFollowingContext(context, nodeTest, false);
            }
            case 11: {
                return new ChildContext(context, nodeTest, true, false);
            }
            case 6: {
                return new NamespaceContext(context, nodeTest);
            }
            case 3: {
                return new ParentContext(context, nodeTest);
            }
            case 7: {
                return new PrecedingOrFollowingContext(context, nodeTest, true);
            }
            case 12: {
                return new ChildContext(context, nodeTest, true, true);
            }
            case 1: {
                return new SelfContext(context, nodeTest);
            }
        }
        return null;
    }

    static {
        BASIC_PATH_HINT = BASIC_PATH_HINT;
    }
}

