/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.fo.NumberProperty;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;

class RoundFunction
extends FunctionBase {
    RoundFunction() {
    }

    public Property eval(Property[] args, PropertyInfo pInfo) throws PropertyException {
        Number dbl = args[0].getNumber();
        if (dbl == null) {
            throw new PropertyException("Non number operand to round function");
        }
        double n = dbl.doubleValue();
        double r = Math.floor(n + 0.5);
        if (r == 0.0 && n < 0.0) {
            r = -r;
        }
        return new NumberProperty(r);
    }

    public int nbArgs() {
        return 1;
    }
}

