/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebuggableScript;

class InterpretedFunction
extends NativeFunction
implements DebuggableScript,
Serializable {
    static final long serialVersionUID = -6235150451107527319L;
    InterpreterData itsData;
    Scriptable itsClosure;

    InterpretedFunction(Context context, InterpreterData interpreterData, String[] stringArray, short s) {
        this.itsData = interpreterData;
        this.argNames = stringArray;
        this.argCount = s;
        this.init(context);
    }

    void init(Context context) {
        this.functionName = this.itsData.itsName;
        this.source = this.itsData.itsSource;
        this.nestedFunctions = this.itsData.itsNestedFunctions;
        if (context != null) {
            this.version = (short)context.getLanguageVersion();
        }
    }

    InterpretedFunction(InterpretedFunction interpretedFunction, Scriptable scriptable, Context context) {
        this.itsData = interpretedFunction.itsData;
        this.argNames = interpretedFunction.argNames;
        this.argCount = interpretedFunction.argCount;
        this.itsClosure = scriptable;
        this.init(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        Object object;
        if (this.itsClosure != null) {
            scriptable = this.itsClosure;
        } else if (!this.itsData.itsUseDynamicScope) {
            scriptable = this.getParentScope();
        }
        if (this.itsData.itsCheckThis) {
            scriptable2 = ScriptRuntime.getThis(scriptable2);
        }
        if (this.itsData.itsNeedsActivation) {
            scriptable = ScriptRuntime.initVarObj(context, scriptable, this, scriptable2, objectArray);
        }
        try {
            object = Interpreter.interpret(context, scriptable, scriptable2, objectArray, this, this.itsData);
            Object var7_6 = null;
            if (!this.itsData.itsNeedsActivation) return object;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!this.itsData.itsNeedsActivation) throw throwable;
            ScriptRuntime.popActivation(context);
            throw throwable;
        }
        ScriptRuntime.popActivation(context);
        return object;
    }

    public boolean isFunction() {
        return true;
    }

    public Scriptable getScriptable() {
        return this;
    }

    public String getSourceName() {
        return this.itsData.itsSourceFile;
    }

    public int[] getLineNumbers() {
        return this.itsData.itsLineNumberTable.getKeys();
    }

    public boolean placeBreakpoint(int n) {
        return this.itsData.placeBreakpoint(n);
    }

    public boolean removeBreakpoint(int n) {
        return this.itsData.removeBreakpoint(n);
    }
}

