/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeArray
extends IdScriptable {
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int Id_constructor = 2;
    private static final int Id_toString = 3;
    private static final int Id_toLocaleString = 4;
    private static final int Id_join = 5;
    private static final int Id_reverse = 6;
    private static final int Id_sort = 7;
    private static final int Id_push = 8;
    private static final int Id_pop = 9;
    private static final int Id_shift = 10;
    private static final int Id_unshift = 11;
    private static final int Id_splice = 12;
    private static final int Id_concat = 13;
    private static final int Id_slice = 14;
    private static final int MAX_PROTOTYPE_ID = 14;
    private long length;
    private Object[] dense;
    private static final int maximumDenseLength = 10000;
    private boolean prototypeFlag;

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeArray nativeArray = new NativeArray();
        nativeArray.prototypeFlag = true;
        nativeArray.addAsPrototype(14, context, scriptable, bl);
    }

    public NativeArray() {
        this.dense = null;
        this.length = 0L;
    }

    public NativeArray(long l) {
        int n = (int)l;
        if ((long)n == l && n > 0) {
            if (n > 10000) {
                n = 10000;
            }
            this.dense = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                this.dense[n2] = Scriptable.NOT_FOUND;
                ++n2;
            }
        }
        this.length = l;
    }

    public NativeArray(Object[] objectArray) {
        this.dense = objectArray;
        this.length = objectArray.length;
    }

    public String getClassName() {
        return "Array";
    }

    protected int getIdDefaultAttributes(int n) {
        if (n == 1) {
            return 6;
        }
        return super.getIdDefaultAttributes(n);
    }

    protected Object getIdValue(int n) {
        if (n == 1) {
            return this.wrap_double(this.length);
        }
        return super.getIdValue(n);
    }

    protected void setIdValue(int n, Object object) {
        if (n == 1) {
            this.jsSet_length(object);
            return;
        }
        super.setIdValue(n, object);
    }

    public int methodArity(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case 2: {
                    return 1;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 0;
                }
                case 7: {
                    return 1;
                }
                case 8: {
                    return 1;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 1;
                }
                case 11: {
                    return 1;
                }
                case 12: {
                    return 1;
                }
                case 13: {
                    return 1;
                }
                case 14: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (n) {
                case 2: {
                    return NativeArray.jsConstructor(context, scriptable, objectArray, idFunction, scriptable2 == null);
                }
                case 3: {
                    return NativeArray.jsFunction_toString(context, scriptable2, objectArray);
                }
                case 4: {
                    return NativeArray.jsFunction_toLocaleString(context, scriptable2, objectArray);
                }
                case 5: {
                    return NativeArray.jsFunction_join(context, scriptable2, objectArray);
                }
                case 6: {
                    return NativeArray.jsFunction_reverse(context, scriptable2, objectArray);
                }
                case 7: {
                    return NativeArray.jsFunction_sort(context, scriptable, scriptable2, objectArray);
                }
                case 8: {
                    return NativeArray.jsFunction_push(context, scriptable2, objectArray);
                }
                case 9: {
                    return NativeArray.jsFunction_pop(context, scriptable2, objectArray);
                }
                case 10: {
                    return NativeArray.jsFunction_shift(context, scriptable2, objectArray);
                }
                case 11: {
                    return NativeArray.jsFunction_unshift(context, scriptable2, objectArray);
                }
                case 12: {
                    return NativeArray.jsFunction_splice(context, scriptable, scriptable2, objectArray);
                }
                case 13: {
                    return NativeArray.jsFunction_concat(context, scriptable, scriptable2, objectArray);
                }
                case 14: {
                    return this.jsFunction_slice(context, scriptable2, objectArray);
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    public Object get(int n, Scriptable scriptable) {
        if (this.dense != null && 0 <= n && n < this.dense.length) {
            return this.dense[n];
        }
        return super.get(n, scriptable);
    }

    public boolean has(int n, Scriptable scriptable) {
        if (this.dense != null && 0 <= n && n < this.dense.length) {
            return this.dense[n] != Scriptable.NOT_FOUND;
        }
        return super.has(n, scriptable);
    }

    private static long toArrayIndex(String string) {
        long l;
        double d = ScriptRuntime.toNumber(string);
        if (d == d && (double)(l = ScriptRuntime.toUint32(d)) == d && l != 0xFFFFFFFFL && Long.toString(l).equals(string)) {
            return l;
        }
        return -1L;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        long l;
        if (scriptable == this && (l = NativeArray.toArrayIndex(string)) >= this.length) {
            this.length = l + 1L;
        }
        super.put(string, scriptable, object);
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (scriptable == this) {
            if (this.length <= (long)n) {
                this.length = (long)n + 1L;
            }
            if (this.dense != null && 0 <= n && n < this.dense.length) {
                this.dense[n] = object;
                return;
            }
        }
        super.put(n, scriptable, object);
    }

    public void delete(int n) {
        if (!this.isSealed() && this.dense != null && 0 <= n && n < this.dense.length) {
            this.dense[n] = Scriptable.NOT_FOUND;
            return;
        }
        super.delete(n);
    }

    public Object[] getIds() {
        Object[] objectArray = super.getIds();
        if (this.dense == null) {
            return objectArray;
        }
        int n = this.dense.length;
        long l = this.length;
        if ((long)n > l) {
            n = (int)l;
        }
        if (n == 0) {
            return objectArray;
        }
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n2 + n];
        System.arraycopy(this.dense, 0, objectArray2, n2, n);
        int n3 = 0;
        int n4 = 0;
        while (n4 != n) {
            if (objectArray2[n2 + n4] != Scriptable.NOT_FOUND) {
                objectArray2[n2 + n3] = new Integer(n4);
                ++n3;
            }
            ++n4;
        }
        if (n3 != n) {
            Object[] objectArray3 = new Object[n2 + n3];
            System.arraycopy(objectArray2, n2, objectArray3, n2, n3);
            objectArray2 = objectArray3;
        }
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        return objectArray2;
    }

    public Object getDefaultValue(Class clazz) {
        Context context;
        if (clazz == ScriptRuntime.NumberClass && (context = Context.getContext()).getLanguageVersion() == 120) {
            return new Long(this.length);
        }
        return super.getDefaultValue(clazz);
    }

    private static Object jsConstructor(Context context, Scriptable scriptable, Object[] objectArray, IdFunction idFunction, boolean bl) throws JavaScriptException {
        if (!bl) {
            return idFunction.construct(context, scriptable, objectArray);
        }
        if (objectArray.length == 0) {
            return new NativeArray();
        }
        if (context.getLanguageVersion() == 120) {
            return new NativeArray(objectArray);
        }
        if (objectArray.length > 1 || !(objectArray[0] instanceof Number)) {
            return new NativeArray(objectArray);
        }
        long l = ScriptRuntime.toUint32(objectArray[0]);
        if ((double)l != ((Number)objectArray[0]).doubleValue()) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        return new NativeArray(l);
    }

    public long jsGet_length() {
        return this.length;
    }

    private void jsSet_length(Object object) {
        double d = ScriptRuntime.toNumber(object);
        long l = ScriptRuntime.toUint32(d);
        if ((double)l != d) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        if (l < this.length) {
            if (this.length - l > 4096L) {
                Object[] objectArray = this.getIds();
                int n = 0;
                while (n < objectArray.length) {
                    Object object2 = objectArray[n];
                    if (object2 instanceof String) {
                        String string = (String)object2;
                        long l2 = NativeArray.toArrayIndex(string);
                        if (l2 >= l) {
                            this.delete(string);
                        }
                    } else {
                        int n2 = (Integer)object2;
                        if ((long)n2 >= l) {
                            this.delete(n2);
                        }
                    }
                    ++n;
                }
            } else {
                long l3 = l;
                while (l3 < this.length) {
                    NativeArray.deleteElem(this, l3);
                    ++l3;
                }
            }
        }
        this.length = l;
    }

    static double getLengthProperty(Scriptable scriptable) {
        if (scriptable instanceof NativeString) {
            return ((NativeString)scriptable).jsGet_length();
        }
        if (scriptable instanceof NativeArray) {
            return ((NativeArray)scriptable).jsGet_length();
        }
        return ScriptRuntime.toUint32(ScriptRuntime.getProp(scriptable, "length", scriptable));
    }

    static boolean hasLengthProperty(Object object) {
        if (!(object instanceof Scriptable) || object == Context.getUndefinedValue()) {
            return false;
        }
        if (object instanceof NativeString || object instanceof NativeArray) {
            return true;
        }
        Scriptable scriptable = (Scriptable)object;
        Object object2 = ScriptRuntime.getProp(scriptable, "length", scriptable);
        return object2 instanceof Number;
    }

    private static void deleteElem(Scriptable scriptable, long l) {
        int n = (int)l;
        if ((long)n == l) {
            scriptable.delete(n);
        } else {
            scriptable.delete(Long.toString(l));
        }
    }

    private static Object getElem(Scriptable scriptable, long l) {
        if (l > Integer.MAX_VALUE) {
            String string = Long.toString(l);
            return ScriptRuntime.getStrIdElem(scriptable, string);
        }
        return ScriptRuntime.getElem(scriptable, (int)l);
    }

    private static void setElem(Scriptable scriptable, long l, Object object) {
        if (l > Integer.MAX_VALUE) {
            String string = Long.toString(l);
            ScriptRuntime.setStrIdElem(scriptable, string, object, scriptable);
        } else {
            ScriptRuntime.setElem(scriptable, (int)l, object);
        }
    }

    private static String jsFunction_toString(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        return NativeArray.toStringHelper(context, scriptable, context.getLanguageVersion() == 120, false);
    }

    private static String jsFunction_toLocaleString(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        return NativeArray.toStringHelper(context, scriptable, false, true);
    }

    private static String toStringHelper(Context context, Scriptable scriptable, boolean bl, boolean bl2) throws JavaScriptException {
        String string;
        boolean bl3;
        long l = (long)NativeArray.getLengthProperty(scriptable);
        StringBuffer stringBuffer = new StringBuffer();
        if (context.iterating == null) {
            context.iterating = new Hashtable(31);
        }
        boolean bl4 = bl3 = context.iterating.get(scriptable) == Boolean.TRUE;
        if (bl) {
            stringBuffer.append('[');
            string = ", ";
        } else {
            string = ",";
        }
        boolean bl5 = false;
        long l2 = 0L;
        if (!bl3) {
            l2 = 0L;
            while (l2 < l) {
                Object object;
                if (l2 > 0L) {
                    stringBuffer.append(string);
                }
                if ((object = NativeArray.getElem(scriptable, l2)) == null || object == Undefined.instance) {
                    bl5 = false;
                } else {
                    Object object2;
                    bl5 = true;
                    if (object instanceof String) {
                        object2 = (String)object;
                        if (bl) {
                            stringBuffer.append('\"');
                            stringBuffer.append(ScriptRuntime.escapeString((String)object2));
                            stringBuffer.append('\"');
                        } else {
                            stringBuffer.append((String)object2);
                        }
                    } else {
                        Object var16_13;
                        try {
                            context.iterating.put(scriptable, Boolean.TRUE);
                            if (bl2 && object != Undefined.instance && object != null) {
                                object2 = Context.toObject(object, scriptable);
                                Object object3 = ScriptRuntime.getProp(object2, "toLocaleString", scriptable);
                                object = ScriptRuntime.call(context, object3, object, ScriptRuntime.emptyArgs);
                            }
                            stringBuffer.append(ScriptRuntime.toString(object));
                            var16_13 = null;
                            context.iterating.remove(scriptable);
                        }
                        catch (Throwable throwable) {
                            var16_13 = null;
                            context.iterating.remove(scriptable);
                            throw throwable;
                        }
                        {
                        }
                    }
                }
                ++l2;
            }
        }
        if (bl) {
            if (!bl5 && l2 > 0L) {
                stringBuffer.append(", ]");
            } else {
                stringBuffer.append(']');
            }
        }
        return stringBuffer.toString();
    }

    private static String jsFunction_join(Context context, Scriptable scriptable, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        double d = NativeArray.getLengthProperty(scriptable);
        String string = objectArray.length < 1 ? "," : ScriptRuntime.toString(objectArray[0]);
        long l = 0L;
        while ((double)l < d) {
            Object object;
            if (l > 0L) {
                stringBuffer.append(string);
            }
            if ((object = NativeArray.getElem(scriptable, l)) != null && object != Undefined.instance) {
                stringBuffer.append(ScriptRuntime.toString(object));
            }
            ++l;
        }
        return stringBuffer.toString();
    }

    private static Scriptable jsFunction_reverse(Context context, Scriptable scriptable, Object[] objectArray) {
        long l = (long)NativeArray.getLengthProperty(scriptable);
        long l2 = l / 2L;
        long l3 = 0L;
        while (l3 < l2) {
            long l4 = l - l3 - 1L;
            Object object = NativeArray.getElem(scriptable, l3);
            Object object2 = NativeArray.getElem(scriptable, l4);
            NativeArray.setElem(scriptable, l3, object2);
            NativeArray.setElem(scriptable, l4, object);
            ++l3;
        }
        return scriptable;
    }

    private static Scriptable jsFunction_sort(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        long l = (long)NativeArray.getLengthProperty(scriptable2);
        Object object = objectArray.length > 0 && Undefined.instance != objectArray[0] ? objectArray[0] : null;
        if (l >= Integer.MAX_VALUE) {
            NativeArray.qsort_extended(context, object, scriptable2, 0L, l - 1L);
        } else {
            Object[] objectArray2 = new Object[(int)l];
            int n = 0;
            while ((long)n < l) {
                objectArray2[n] = NativeArray.getElem(scriptable2, n);
                ++n;
            }
            NativeArray.qsort(context, object, objectArray2, 0, (int)l - 1, scriptable);
            int n2 = 0;
            while ((long)n2 < l) {
                NativeArray.setElem(scriptable2, n2, objectArray2[n2]);
                ++n2;
            }
        }
        return scriptable2;
    }

    private static double qsortCompare(Context context, Object object, Object object2, Object object3, Scriptable scriptable) throws JavaScriptException {
        Scriptable scriptable2 = Undefined.instance;
        if (scriptable2 == object2 || scriptable2 == object3) {
            if (scriptable2 != object2) {
                return -1.0;
            }
            if (scriptable2 != object3) {
                return 1.0;
            }
            return 0.0;
        }
        if (object == null) {
            String string = ScriptRuntime.toString(object2);
            String string2 = ScriptRuntime.toString(object3);
            return string.compareTo(string2);
        }
        Object[] objectArray = new Object[]{object2, object3};
        double d = ScriptRuntime.toNumber(ScriptRuntime.call(context, object, null, objectArray, scriptable));
        return d == d ? d : 0.0;
    }

    private static void qsort(Context context, Object object, Object[] objectArray, int n, int n2, Scriptable scriptable) throws JavaScriptException {
        while (n < n2) {
            int n3 = n;
            int n4 = n2;
            int n5 = n3;
            Object object2 = objectArray[n5];
            while (n3 < n4) {
                int n6;
                while (true) {
                    n6 = --n4;
                    if (NativeArray.qsortCompare(context, object, objectArray[n4], object2, scriptable) <= 0.0) break;
                }
                objectArray[n5] = objectArray[n6];
                while (n3 < n4 && NativeArray.qsortCompare(context, object, objectArray[n5], object2, scriptable) <= 0.0) {
                    n5 = ++n3;
                }
                objectArray[n6] = objectArray[n5];
            }
            objectArray[n5] = object2;
            if (n3 - n < n2 - n3) {
                NativeArray.qsort(context, object, objectArray, n, n3 - 1, scriptable);
                n = n3 + 1;
                continue;
            }
            NativeArray.qsort(context, object, objectArray, n3 + 1, n2, scriptable);
            n2 = n3 - 1;
        }
    }

    private static void qsort_extended(Context context, Object object, Scriptable scriptable, long l, long l2) throws JavaScriptException {
        while (l < l2) {
            long l3 = l;
            long l4 = l2;
            long l5 = l3;
            Object object2 = NativeArray.getElem(scriptable, l5);
            while (l3 < l4) {
                long l6;
                while (true) {
                    l6 = --l4;
                    if (NativeArray.qsortCompare(context, object, NativeArray.getElem(scriptable, l4), object2, scriptable) <= 0.0) break;
                }
                NativeArray.setElem(scriptable, l5, NativeArray.getElem(scriptable, l6));
                while (l3 < l4 && NativeArray.qsortCompare(context, object, NativeArray.getElem(scriptable, l5), object2, scriptable) <= 0.0) {
                    l5 = ++l3;
                }
                NativeArray.setElem(scriptable, l6, NativeArray.getElem(scriptable, l5));
            }
            NativeArray.setElem(scriptable, l5, object2);
            if (l3 - l < l2 - l3) {
                NativeArray.qsort_extended(context, object, scriptable, l, l3 - 1L);
                l = l3 + 1L;
                continue;
            }
            NativeArray.qsort_extended(context, object, scriptable, l3 + 1L, l2);
            l2 = l3 - 1L;
        }
    }

    private static Object jsFunction_push(Context context, Scriptable scriptable, Object[] objectArray) {
        double d = NativeArray.getLengthProperty(scriptable);
        int n = 0;
        while (n < objectArray.length) {
            NativeArray.setElem(scriptable, (long)d + (long)n, objectArray[n]);
            ++n;
        }
        ScriptRuntime.setProp(scriptable, "length", new Double(d += (double)objectArray.length), scriptable);
        if (context.getLanguageVersion() == 120) {
            return objectArray.length == 0 ? Context.getUndefinedValue() : objectArray[objectArray.length - 1];
        }
        return new Long((long)d);
    }

    private static Object jsFunction_pop(Context context, Scriptable scriptable, Object[] objectArray) {
        double d = NativeArray.getLengthProperty(scriptable);
        Object object = d > 0.0 ? NativeArray.getElem(scriptable, (long)(d -= 1.0)) : Context.getUndefinedValue();
        ScriptRuntime.setProp(scriptable, "length", new Double(d), scriptable);
        return object;
    }

    private static Object jsFunction_shift(Context context, Scriptable scriptable, Object[] objectArray) {
        Object object;
        double d = NativeArray.getLengthProperty(scriptable);
        if (d > 0.0) {
            long l = 0L;
            d -= 1.0;
            object = NativeArray.getElem(scriptable, l);
            if (d > 0.0) {
                l = 1L;
                while ((double)l <= d) {
                    Object object2 = NativeArray.getElem(scriptable, l);
                    NativeArray.setElem(scriptable, l - 1L, object2);
                    ++l;
                }
            }
        } else {
            object = Context.getUndefinedValue();
        }
        ScriptRuntime.setProp(scriptable, "length", new Double(d), scriptable);
        return object;
    }

    private static Object jsFunction_unshift(Context context, Scriptable scriptable, Object[] objectArray) {
        double d = NativeArray.getLengthProperty(scriptable);
        int n = objectArray.length;
        if (objectArray.length > 0) {
            if (d > 0.0) {
                long l = (long)d - 1L;
                while (l >= 0L) {
                    Object object = NativeArray.getElem(scriptable, l);
                    NativeArray.setElem(scriptable, l + (long)n, object);
                    --l;
                }
            }
            int n2 = 0;
            while (n2 < objectArray.length) {
                NativeArray.setElem(scriptable, n2, objectArray[n2]);
                ++n2;
            }
            ScriptRuntime.setProp(scriptable, "length", new Double(d += (double)objectArray.length), scriptable);
        }
        return new Long((long)d);
    }

    private static Object jsFunction_splice(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        long l;
        double d;
        double d2;
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Object object2 = ScriptRuntime.newObject(context, scriptable, "Array", null);
        int n = objectArray.length;
        if (n == 0) {
            return object2;
        }
        double d3 = NativeArray.getLengthProperty(scriptable2);
        double d4 = ScriptRuntime.toInteger(objectArray[0]);
        if (d4 < 0.0) {
            if ((d4 += d3) < 0.0) {
                d4 = 0.0;
            }
        } else if (d4 > d3) {
            d4 = d3;
        }
        --n;
        double d5 = d3 - d4;
        if (objectArray.length == 1) {
            d2 = d5;
            d = d3;
        } else {
            d2 = ScriptRuntime.toInteger(objectArray[1]);
            if (d2 < 0.0) {
                d2 = 0.0;
            } else if (d2 > d5) {
                d2 = d5;
            }
            d = d4 + d2;
            --n;
        }
        long l2 = (long)d4;
        long l3 = (long)d;
        if (d2 > 0.0) {
            if (d2 == 1.0 && context.getLanguageVersion() == 120) {
                object2 = NativeArray.getElem(scriptable2, l2);
            } else {
                l = l2;
                while (l < l3) {
                    object = (Scriptable)object2;
                    Object object3 = NativeArray.getElem(scriptable2, l);
                    NativeArray.setElem((Scriptable)object, l - l2, object3);
                    ++l;
                }
            }
        } else if (d2 == 0.0 && context.getLanguageVersion() == 120) {
            object2 = Context.getUndefinedValue();
        }
        d5 = (double)n - d2;
        if (d5 > 0.0) {
            l = (long)d3 - 1L;
            while (l >= l3) {
                object = NativeArray.getElem(scriptable2, l);
                NativeArray.setElem(scriptable2, l + (long)d5, object);
                --l;
            }
        } else if (d5 < 0.0) {
            l = l3;
            while ((double)l < d3) {
                object = NativeArray.getElem(scriptable2, l);
                NativeArray.setElem(scriptable2, l + (long)d5, object);
                ++l;
            }
        }
        int n2 = objectArray.length - n;
        int n3 = 0;
        while (n3 < n) {
            NativeArray.setElem(scriptable2, l2 + (long)n3, objectArray[n3 + n2]);
            ++n3;
        }
        ScriptRuntime.setProp(scriptable2, "length", new Double(d3 + d5), scriptable2);
        return object2;
    }

    private static Scriptable jsFunction_concat(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d;
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Scriptable scriptable3 = ScriptRuntime.newObject(context, scriptable, "Array", null);
        long l = 0L;
        if (NativeArray.hasLengthProperty(scriptable2)) {
            d = NativeArray.getLengthProperty(scriptable2);
            l = 0L;
            while ((double)l < d) {
                Object object = NativeArray.getElem(scriptable2, l);
                NativeArray.setElem(scriptable3, l, object);
                ++l;
            }
        } else {
            NativeArray.setElem(scriptable3, l++, scriptable2);
        }
        int n = 0;
        while (n < objectArray.length) {
            if (NativeArray.hasLengthProperty(objectArray[n])) {
                Scriptable scriptable4 = (Scriptable)objectArray[n];
                d = NativeArray.getLengthProperty(scriptable4);
                long l2 = 0L;
                while ((double)l2 < d) {
                    Object object = NativeArray.getElem(scriptable4, l2);
                    NativeArray.setElem(scriptable3, l, object);
                    ++l2;
                    ++l;
                }
            } else {
                NativeArray.setElem(scriptable3, l++, objectArray[n]);
            }
            ++n;
        }
        return scriptable3;
    }

    private Scriptable jsFunction_slice(Context context, Scriptable scriptable, Object[] objectArray) {
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(this);
        Scriptable scriptable3 = ScriptRuntime.newObject(context, scriptable2, "Array", null);
        double d = NativeArray.getLengthProperty(scriptable);
        double d2 = 0.0;
        double d3 = d;
        if (objectArray.length > 0) {
            d2 = ScriptRuntime.toInteger(objectArray[0]);
            if (d2 < 0.0) {
                if ((d2 += d) < 0.0) {
                    d2 = 0.0;
                }
            } else if (d2 > d) {
                d2 = d;
            }
            if (objectArray.length > 1) {
                d3 = ScriptRuntime.toInteger(objectArray[1]);
                if (d3 < 0.0) {
                    if ((d3 += d) < 0.0) {
                        d3 = 0.0;
                    }
                } else if (d3 > d) {
                    d3 = d;
                }
            }
        }
        long l = (long)d2;
        long l2 = (long)d3;
        long l3 = l;
        while (l3 < l2) {
            Object object = NativeArray.getElem(scriptable, l3);
            NativeArray.setElem(scriptable3, l3 - l, object);
            ++l3;
        }
        return scriptable3;
    }

    protected int maxInstanceId() {
        return 1;
    }

    protected String getIdName(int n) {
        if (n == 1) {
            return "length";
        }
        if (this.prototypeFlag) {
            switch (n) {
                case 2: {
                    return "constructor";
                }
                case 3: {
                    return "toString";
                }
                case 4: {
                    return "toLocaleString";
                }
                case 5: {
                    return "join";
                }
                case 6: {
                    return "reverse";
                }
                case 7: {
                    return "sort";
                }
                case 8: {
                    return "push";
                }
                case 9: {
                    return "pop";
                }
                case 10: {
                    return "shift";
                }
                case 11: {
                    return "unshift";
                }
                case 12: {
                    return "splice";
                }
                case 13: {
                    return "concat";
                }
                case 14: {
                    return "slice";
                }
            }
        }
        return null;
    }

    protected int mapNameToId(String string) {
        if (string.equals("length")) {
            return 1;
        }
        if (this.prototypeFlag) {
            return NativeArray.toPrototypeId(string);
        }
        return 0;
    }

    private static int toPrototypeId(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 3: {
                string2 = "pop";
                n = 9;
                break;
            }
            case 4: {
                char c = string.charAt(0);
                if (c == 'j') {
                    string2 = "join";
                    n = 5;
                    break;
                }
                if (c == 'p') {
                    string2 = "push";
                    n = 8;
                    break;
                }
                if (c != 's') break;
                string2 = "sort";
                n = 7;
                break;
            }
            case 5: {
                char c = string.charAt(1);
                if (c == 'h') {
                    string2 = "shift";
                    n = 10;
                    break;
                }
                if (c != 'l') break;
                string2 = "slice";
                n = 14;
                break;
            }
            case 6: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "concat";
                    n = 13;
                    break;
                }
                if (c == 'l') {
                    string2 = "length";
                    n = 1;
                    break;
                }
                if (c != 's') break;
                string2 = "splice";
                n = 12;
                break;
            }
            case 7: {
                char c = string.charAt(0);
                if (c == 'r') {
                    string2 = "reverse";
                    n = 6;
                    break;
                }
                if (c != 'u') break;
                string2 = "unshift";
                n = 11;
                break;
            }
            case 8: {
                string2 = "toString";
                n = 3;
                break;
            }
            case 11: {
                string2 = "constructor";
                n = 2;
                break;
            }
            case 14: {
                string2 = "toLocaleString";
                n = 4;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

