/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Node;

public class PreorderNodeIterator {
    private Node start;
    private Node[] stack;
    private int stackTop;
    private Node current;
    private Node cachedPrev;

    public PreorderNodeIterator(Node node) {
        this.start = node;
    }

    public Node currentNode() {
        return this.current;
    }

    public Node getCurrentParent() {
        return this.stack[this.stackTop - 1];
    }

    public Node nextNode() {
        if (this.current == null) {
            this.current = this.start;
        } else if (this.current.first != null) {
            this.stackPush(this.current);
            this.cachedPrev = null;
            this.current = this.current.first;
        } else {
            while (true) {
                this.cachedPrev = this.current;
                this.current = this.current.next;
                if (this.current != null) break;
                if (this.stackTop == 0) {
                    this.cachedPrev = null;
                    break;
                }
                --this.stackTop;
                this.current = this.stack[this.stackTop];
                this.stack[this.stackTop] = null;
            }
        }
        return this.current;
    }

    public void replaceCurrent(Node node) {
        Node node2 = this.stack[this.stackTop - 1];
        if (this.cachedPrev != null && this.cachedPrev.next == this.current) {
            node2.replaceChildAfter(this.cachedPrev, node);
        } else {
            node2.replaceChild(this.current, node);
        }
        this.current = node;
    }

    private void stackPush(Node node) {
        int n = this.stackTop;
        if (n == 0) {
            this.stack = new Node[16];
        } else if (n == this.stack.length) {
            Node[] nodeArray = new Node[n * 2];
            System.arraycopy(this.stack, 0, nodeArray, 0, n);
            this.stack = nodeArray;
        }
        this.stack[n] = node;
        this.stackTop = n + 1;
    }
}

