/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.source.Recyclable;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.URLSource;

public class SourceResolverImpl
extends AbstractLogEnabled
implements Composable,
Contextualizable,
Disposable,
Parameterizable,
SourceResolver,
ThreadSafe {
    protected ComponentManager m_manager;
    protected ComponentSelector m_factorySelector;
    protected Context m_context;
    protected URL m_baseURL;
    protected Class m_urlSourceClass;

    public void contextualize(Context context) throws ContextException {
        this.m_context = context;
        try {
            this.m_baseURL = ((File)this.m_context.get((Object)"context-root")).toURL();
        }
        catch (ContextException ce) {
            try {
                this.m_baseURL = new File(System.getProperty("user.dir")).toURL();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("SourceResolver: Using base URL: " + this.m_baseURL);
                }
            }
            catch (MalformedURLException mue) {
                this.getLogger().warn("Malformed URL for user.dir, and no container.rootDir exists", (Throwable)mue);
                throw new ContextException("Malformed URL for user.dir, and no container.rootDir exists", (Throwable)mue);
            }
        }
        catch (MalformedURLException mue) {
            this.getLogger().warn("Malformed URL for container.rootDir", (Throwable)mue);
            throw new ContextException("Malformed URL for container.rootDir", (Throwable)mue);
        }
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.m_manager = manager;
        this.m_factorySelector = (ComponentSelector)this.m_manager.lookup(SourceFactory.ROLE + "Selector");
    }

    public void dispose() {
        if (this.m_manager != null) {
            this.m_manager.release((Component)this.m_factorySelector);
            this.m_factorySelector = null;
        }
    }

    public void parameterize(Parameters pars) throws ParameterException {
        String urlSourceClassName = pars.getParameter("url-source", "org.apache.excalibur.source.impl.URLSource");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        try {
            this.m_urlSourceClass = loader.loadClass(urlSourceClassName);
        }
        catch (ClassNotFoundException cnfe) {
            this.getLogger().error("Class not found: " + urlSourceClassName, (Throwable)cnfe);
            throw new ParameterException("Class not found: " + urlSourceClassName, (Throwable)cnfe);
        }
    }

    public Source resolveURI(String location) throws MalformedURLException, IOException, SourceException {
        return this.resolveURI(location, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Source resolveURI(String location, String baseURI, Map parameters) throws MalformedURLException, IOException, SourceException {
        String protocol;
        String systemID;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Resolving '" + location + "' with base '" + baseURI + "' in context '" + this.m_baseURL + "'");
        }
        if (location == null) {
            throw new MalformedURLException("Invalid System ID");
        }
        if (null != baseURI && baseURI.indexOf(58) == -1) {
            throw new MalformedURLException("BaseURI is not valid, it must contain a protocol: " + baseURI);
        }
        if (baseURI == null) {
            baseURI = this.m_baseURL.toExternalForm();
        }
        if (location.length() == 0) {
            systemID = baseURI;
        } else if (location.charAt(0) == '/') {
            if (location.length() > 2 && location.charAt(2) == ':') {
                systemID = "file:" + location;
            } else {
                int protocolEnd = baseURI.indexOf(58);
                systemID = baseURI.substring(0, protocolEnd + 1) + location;
            }
        } else if (location.indexOf(":") > 1) {
            systemID = location;
        } else if (location.length() > 1 && location.charAt(1) == ':') {
            systemID = "file:/" + location;
        } else if (baseURI.startsWith("file:")) {
            File temp = new File(baseURI.substring("file:".length()), location);
            String path = temp.getAbsolutePath();
            systemID = path.charAt(0) != File.separatorChar ? "file:/" + path : "file:" + path;
        } else {
            StringBuffer buffer = new StringBuffer(baseURI);
            if (!baseURI.endsWith("/")) {
                buffer.append('/');
            }
            buffer.append(location);
            systemID = buffer.toString();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Resolved to systemID '" + systemID + "'");
        }
        Source source = null;
        int protocolPos = systemID.indexOf(58);
        if (protocolPos != -1 && this.m_factorySelector.hasComponent((Object)(protocol = systemID.substring(0, protocolPos)))) {
            SourceFactory factory = null;
            try {
                try {
                    factory = (SourceFactory)this.m_factorySelector.select((Object)protocol);
                    source = factory.getSource(systemID, parameters);
                }
                catch (ComponentException ce) {
                    throw new SourceException("ComponentException.", ce);
                }
                Object var11_19 = null;
            }
            catch (Throwable throwable) {
                Object var11_20 = null;
                this.m_factorySelector.release((Component)factory);
                throw throwable;
            }
            this.m_factorySelector.release((Component)factory);
        }
        if (null == source) {
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Making URL from " + systemID);
                }
                try {
                    URLSource urlSource = (URLSource)this.m_urlSourceClass.newInstance();
                    urlSource.init(new URL(systemID), parameters);
                    source = urlSource;
                }
                catch (MalformedURLException mue) {
                    throw mue;
                }
                catch (Exception ie) {
                    throw new SourceException("Unable to create new instance of " + this.m_urlSourceClass, ie);
                }
            }
            catch (MalformedURLException mue) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Making URL - MalformedURLException in getURL:", (Throwable)mue);
                    this.getLogger().debug("Making URL a File (assuming that it is full path):" + systemID);
                }
                try {
                    URLSource urlSource = (URLSource)this.m_urlSourceClass.newInstance();
                    urlSource.init(new File(systemID).toURL(), parameters);
                    source = urlSource;
                }
                catch (Exception ie) {
                    throw new SourceException("Unable to create new instance of " + this.m_urlSourceClass, ie);
                }
            }
        }
        if (source instanceof LogEnabled) {
            ((LogEnabled)source).enableLogging(this.getLogger());
        }
        if (source instanceof Contextualizable) {
            try {
                ((Contextualizable)source).contextualize(this.m_context);
            }
            catch (ContextException ce) {
                throw new SourceException("ContextException occured during source resolving.", ce);
            }
        }
        if (!(source instanceof Composable)) return source;
        try {
            ((Composable)source).compose(this.m_manager);
            return source;
        }
        catch (ComponentException ce) {
            throw new SourceException("ComponentException occured during source resolving.", ce);
        }
    }

    public void release(Source source) {
        if (source == null) {
            return;
        }
        if (source instanceof Recyclable) {
            ((Recyclable)((Object)source)).recycle();
        }
        if (source instanceof Disposable) {
            ((Disposable)source).dispose();
        }
    }
}

