/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class Constants {
    public static final String SAX_FEATURE_PREFIX = "http://xml.org/sax/features/";
    public static final String NAMESPACES_FEATURE = "namespaces";
    public static final String NAMESPACE_PREFIXES_FEATURE = "namespace-prefixes";
    public static final String STRING_INTERNING_FEATURE = "string-interning";
    public static final String VALIDATION_FEATURE = "validation";
    public static final String EXTERNAL_GENERAL_ENTITIES_FEATURE = "external-general-entities";
    public static final String EXTERNAL_PARAMETER_ENTITIES_FEATURE = "external-parameter-entities";
    public static final String SAX_PROPERTY_PREFIX = "http://xml.org/sax/properties/";
    public static final String DECLARATION_HANDLER_PROPERTY = "declaration-handler";
    public static final String LEXICAL_HANDLER_PROPERTY = "lexical-handler";
    public static final String DOM_NODE_PROPERTY = "dom-node";
    public static final String XML_STRING_PROPERTY = "xml-string";
    public static final String INCLUDE_COMMENTS_FEATURE = "include-comments";
    public static final String CREATE_CDATA_NODES_FEATURE = "create-cdata-nodes";
    public static final String LOAD_AS_INFOSET = "load-as-infoset";
    public static final String XERCES_FEATURE_PREFIX = "http://apache.org/xml/features/";
    public static final String SCHEMA_VALIDATION_FEATURE = "validation/schema";
    public static final String SCHEMA_NORMALIZED_VALUE = "validation/schema/normalized-value";
    public static final String SCHEMA_ELEMENT_DEFAULT = "validation/schema/element-default";
    public static final String SCHEMA_FULL_CHECKING = "validation/schema-full-checking";
    public static final String DYNAMIC_VALIDATION_FEATURE = "validation/dynamic";
    public static final String WARN_ON_DUPLICATE_ATTDEF_FEATURE = "validation/warn-on-duplicate-attdef";
    public static final String WARN_ON_UNDECLARED_ELEMDEF_FEATURE = "validation/warn-on-undeclared-elemdef";
    public static final String ALLOW_JAVA_ENCODINGS_FEATURE = "allow-java-encodings";
    public static final String CONTINUE_AFTER_FATAL_ERROR_FEATURE = "continue-after-fatal-error";
    public static final String LOAD_DTD_GRAMMAR_FEATURE = "nonvalidating/load-dtd-grammar";
    public static final String LOAD_EXTERNAL_DTD_FEATURE = "nonvalidating/load-external-dtd";
    public static final String CREATE_ENTITY_REF_NODES_FEATURE = "dom/create-entity-ref-nodes";
    public static final String INCLUDE_IGNORABLE_WHITESPACE = "dom/include-ignorable-whitespace";
    public static final String DEFAULT_ATTRIBUTE_VALUES_FEATURE = "validation/default-attribute-values";
    public static final String VALIDATE_CONTENT_MODELS_FEATURE = "validation/validate-content-models";
    public static final String VALIDATE_DATATYPES_FEATURE = "validation/validate-datatypes";
    public static final String NOTIFY_CHAR_REFS_FEATURE = "scanner/notify-char-refs";
    public static final String NOTIFY_BUILTIN_REFS_FEATURE = "scanner/notify-builtin-refs";
    public static final String XERCES_PROPERTY_PREFIX = "http://apache.org/xml/properties/";
    public static final String CURRENT_ELEMENT_NODE_PROPERTY = "dom/current-element-node";
    public static final String DOCUMENT_CLASS_NAME_PROPERTY = "dom/document-class-name";
    public static final String SYMBOL_TABLE_PROPERTY = "internal/symbol-table";
    public static final String ERROR_REPORTER_PROPERTY = "internal/error-reporter";
    public static final String ERROR_HANDLER_PROPERTY = "internal/error-handler";
    public static final String ENTITY_MANAGER_PROPERTY = "internal/entity-manager";
    public static final String ENTITY_RESOLVER_PROPERTY = "internal/entity-resolver";
    public static final String XMLGRAMMAR_POOL_PROPERTY = "internal/grammar-pool";
    public static final String DATATYPE_VALIDATOR_FACTORY_PROPERTY = "internal/datatype-validator-factory";
    public static final String DOCUMENT_SCANNER_PROPERTY = "internal/document-scanner";
    public static final String DTD_SCANNER_PROPERTY = "internal/dtd-scanner";
    public static final String VALIDATOR_PROPERTY = "internal/validator";
    public static final String DTD_VALIDATOR_PROPERTY = "internal/validator/dtd";
    public static final String SCHEMA_VALIDATOR_PROPERTY = "internal/validator/schema";
    public static final String SCHEMA_LOCATION = "schema/external-schemaLocation";
    public static final String SCHEMA_NONS_LOCATION = "schema/external-noNamespaceSchemaLocation";
    public static final String NAMESPACE_BINDER_PROPERTY = "internal/namespace-binder";
    public static final String VALIDATION_MANAGER_PROPERTY = "internal/validation-manager";
    public static final String ELEMENT_PSVI = "ELEMENT_PSVI";
    public static final String ATTRIBUTE_PSVI = "ATTRIBUTE_PSVI";
    private static final String[] fgSAXFeatures = new String[]{"namespaces", "namespace-prefixes", "string-interning", "validation", "external-general-entities", "external-parameter-entities"};
    private static final String[] fgSAXProperties = new String[]{"declaration-handler", "lexical-handler", "dom-node", "xml-string"};
    private static final String[] fgXercesFeatures = new String[]{"validation/schema", "validation/schema-full-checking", "validation/dynamic", "validation/warn-on-duplicate-attdef", "validation/warn-on-undeclared-elemdef", "allow-java-encodings", "continue-after-fatal-error", "nonvalidating/load-dtd-grammar", "nonvalidating/load-external-dtd", "dom/create-entity-ref-nodes", "dom/include-ignorable-whitespace", "validation/default-attribute-values", "validation/validate-content-models", "validation/validate-datatypes", "scanner/notify-char-refs"};
    private static final String[] fgXercesProperties = new String[]{"dom/current-element-node", "dom/document-class-name", "internal/symbol-table", "internal/error-handler", "internal/error-reporter", "internal/entity-manager", "internal/entity-resolver", "internal/grammar-pool", "internal/datatype-validator-factory", "internal/document-scanner", "internal/dtd-scanner", "internal/validator", "schema/external-schemaLocation", "schema/external-noNamespaceSchemaLocation", "internal/validation-manager"};
    private static final Enumeration fgEmptyEnumeration = new ArrayEnumeration(new Object[0]);

    private Constants() {
    }

    public static Enumeration getSAXFeatures() {
        return fgSAXFeatures.length > 0 ? new ArrayEnumeration(fgSAXFeatures) : fgEmptyEnumeration;
    }

    public static Enumeration getSAXProperties() {
        return fgSAXProperties.length > 0 ? new ArrayEnumeration(fgSAXProperties) : fgEmptyEnumeration;
    }

    public static Enumeration getXercesFeatures() {
        return fgXercesFeatures.length > 0 ? new ArrayEnumeration(fgXercesFeatures) : fgEmptyEnumeration;
    }

    public static Enumeration getXercesProperties() {
        return fgXercesProperties.length > 0 ? new ArrayEnumeration(fgXercesProperties) : fgEmptyEnumeration;
    }

    public static void main(String[] stringArray) {
        Constants.print("SAX features:", SAX_FEATURE_PREFIX, fgSAXFeatures);
        Constants.print("SAX properties:", SAX_PROPERTY_PREFIX, fgSAXProperties);
        Constants.print("Xerces features:", XERCES_FEATURE_PREFIX, fgXercesFeatures);
        Constants.print("Xerces properties:", XERCES_PROPERTY_PREFIX, fgXercesProperties);
    }

    private static void print(String string, String string2, Object[] objectArray) {
        System.out.print(string);
        if (objectArray.length > 0) {
            System.out.println();
            int n = 0;
            while (n < objectArray.length) {
                System.out.print("  ");
                System.out.print(string2);
                System.out.println(objectArray[n]);
                ++n;
            }
        } else {
            System.out.println(" none.");
        }
    }

    static class ArrayEnumeration
    implements Enumeration {
        private Object[] array;
        private int index;

        public ArrayEnumeration(Object[] objectArray) {
            this.array = objectArray;
        }

        public boolean hasMoreElements() {
            return this.index < this.array.length;
        }

        public Object nextElement() {
            if (this.index < this.array.length) {
                return this.array[this.index++];
            }
            throw new NoSuchElementException();
        }
    }
}

