/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocket;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.UserPrincipal;
import org.mortbay.http.UserRealm;
import org.mortbay.util.Code;

public class ClientCertAuthenticator
implements SecurityConstraint.Authenticator {
    private int _maxHandShakeSeconds = 60;

    public ClientCertAuthenticator() {
        Code.warning("Client Cert Authentication is EXPERIMENTAL");
    }

    public int getMaxHandShakeSeconds() {
        return this._maxHandShakeSeconds;
    }

    public void setMaxHandShakeSeconds(int maxHandShakeSeconds) {
        this._maxHandShakeSeconds = maxHandShakeSeconds;
    }

    public UserPrincipal authenticated(UserRealm realm, String pathInContext, HttpRequest request, HttpResponse response) throws IOException {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length == 0 || certs[0] == null) {
            Object s = HttpConnection.getHttpConnection().getConnection();
            if (!(s instanceof SSLSocket)) {
                return null;
            }
            SSLSocket socket = (SSLSocket)s;
            if (!socket.getNeedClientAuth()) {
                socket.setNeedClientAuth(true);
                socket.startHandshake();
                int i = this._maxHandShakeSeconds * 4;
                while (i-- > 0) {
                    certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
                    if (certs != null && certs.length > 0 && certs[0] != null) break;
                    try {
                        Thread.sleep(250L);
                    }
                    catch (Exception e) {
                        break;
                    }
                }
            }
        }
        if (certs == null || certs.length == 0 || certs[0] == null) {
            return null;
        }
        Principal principal = certs[0].getSubjectDN();
        if (principal == null) {
            principal = certs[0].getIssuerDN();
        }
        UserPrincipal user = realm.authenticate(principal == null ? "clientcert" : principal.getName(), certs, request);
        request.setAuthType("CLIENT-CERT");
        request.setAuthUser(user.getName());
        request.setUserPrincipal(user);
        return user;
    }

    public String getAuthMethod() {
        return "CLIENT-CERT";
    }
}

