/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.converter;

import java.io.IOException;
import java.io.Writer;

public class ConverterLogChannel {
    public static final String DEBUG_IDENT = "jfor.DEBUG:";
    public static final String INFO_IDENT = "jfor.INFO:";
    public static final String WARNING_IDENT = "jfor.WARNING:";
    public static final String ERROR_IDENT = "jfor.ERROR:";
    private final Writer mDebugWriter;
    private final Writer mInfoWriter;
    private final Writer mWarningWriter;
    private final Writer mErrorwriter;

    public ConverterLogChannel(Writer writer) {
        this.mDebugWriter = writer;
        this.mInfoWriter = writer;
        this.mWarningWriter = writer;
        this.mErrorwriter = writer;
    }

    public ConverterLogChannel(Writer writer, Writer writer2, Writer writer3, Writer writer4) {
        this.mDebugWriter = writer;
        this.mInfoWriter = writer2;
        this.mWarningWriter = writer3;
        this.mErrorwriter = writer4;
    }

    private void doLog(String string, String string2, Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            Writer writer2 = writer;
            synchronized (writer2) {
                writer.write(string);
                writer.write(string2);
                writer.write(10);
                writer.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void logDebug(String string) {
        this.doLog(DEBUG_IDENT, string, this.mDebugWriter);
    }

    public void logInfo(String string) {
        this.doLog(INFO_IDENT, string, this.mInfoWriter);
    }

    public void logWarning(String string) {
        this.doLog(WARNING_IDENT, string, this.mWarningWriter);
    }

    public void logError(String string) {
        this.doLog(ERROR_IDENT, string, this.mErrorwriter);
    }
}

