/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.jfor.jfor.rtflib.rtfdoc.BorderAttributesConverter;
import org.jfor.jfor.rtflib.rtfdoc.ITableAttributes;
import org.jfor.jfor.rtflib.rtfdoc.RtfAttributes;
import org.jfor.jfor.rtflib.rtfdoc.RtfContainer;
import org.jfor.jfor.rtflib.rtfdoc.RtfElement;
import org.jfor.jfor.rtflib.rtfdoc.RtfExtraRowSet;
import org.jfor.jfor.rtflib.rtfdoc.RtfTable;
import org.jfor.jfor.rtflib.rtfdoc.RtfTableCell;

public class RtfTableRow
extends RtfContainer
implements ITableAttributes {
    private RtfTableCell m_cell;
    private RtfExtraRowSet m_extraRowSet;
    private int id;
    private int highestCell = 0;

    RtfTableRow(RtfTable rtfTable, Writer writer, int n) throws IOException {
        super(rtfTable, writer);
        this.id = n;
    }

    RtfTableRow(RtfTable rtfTable, Writer writer, RtfAttributes rtfAttributes, int n) throws IOException {
        super(rtfTable, writer, rtfAttributes);
        this.id = n;
    }

    public RtfTableCell newTableCell(int n) throws IOException {
        ++this.highestCell;
        this.m_cell = new RtfTableCell(this, this.m_writer, n, this.highestCell);
        return this.m_cell;
    }

    public RtfTableCell newTableCell(int n, RtfAttributes rtfAttributes) throws IOException {
        ++this.highestCell;
        this.m_cell = new RtfTableCell(this, this.m_writer, n, rtfAttributes, this.highestCell);
        return this.m_cell;
    }

    protected void writeRtfPrefix() throws IOException {
        this.writeGroupMark(true);
    }

    protected void writeRtfContent() throws IOException {
        this.m_extraRowSet = new RtfExtraRowSet(this.m_writer);
        this.writeControlWord("trowd");
        if (this.m_attrib != null && this.m_attrib.isSet("trkeep")) {
            this.writeControlWord("trkeep");
        }
        this.writePaddingAttributes();
        RtfTable rtfTable = (RtfTable)this.m_parent;
        if (this.m_attrib != null && rtfTable != null) {
            if (this.isFirstRow() && rtfTable.isHighestRow(this.id)) {
                this.m_attrib.unset("trbrdrh");
            } else if (this.isFirstRow()) {
                this.m_attrib.unset("trbrdrb");
            } else if (rtfTable.isHighestRow(this.id)) {
                this.m_attrib.unset("trbrdrt");
            } else {
                this.m_attrib.unset("trbrdrb");
                this.m_attrib.unset("trbrdrt");
            }
        }
        this.writeAttributes(this.m_attrib, ITableAttributes.ROW_BORDER);
        this.writeAttributes(this.m_attrib, ITableAttributes.CELL_BORDER);
        this.writeAttributes(this.m_attrib, BorderAttributesConverter.BORDERS);
        int n = 0;
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            RtfElement rtfElement = (RtfElement)iterator.next();
            if (!(rtfElement instanceof RtfTableCell)) continue;
            n = ((RtfTableCell)rtfElement).writeCellDef(n);
        }
        super.writeRtfContent();
    }

    protected void writeRtfSuffix() throws IOException {
        this.writeControlWord("row");
        this.m_extraRowSet.writeRtf();
        this.writeGroupMark(false);
    }

    RtfExtraRowSet getExtraRowSet() {
        return this.m_extraRowSet;
    }

    private void writePaddingAttributes() throws IOException {
        if (this.m_attrib != null && !this.m_attrib.isSet("trgaph")) {
            int n = -1;
            try {
                Integer n2;
                Integer n3 = (Integer)this.m_attrib.getValue("trpaddl");
                if (n3 != null) {
                    n = n3;
                }
                if ((n2 = (Integer)this.m_attrib.getValue("trpaddr")) != null) {
                    n = (n + n2) / 2;
                }
            }
            catch (Exception exception) {
                String string = "RtfTableRow.writePaddingAttributes: " + exception.toString();
                this.getRtfFile().getLog().logWarning(string);
            }
            if (n >= 0) {
                this.m_attrib.set("trgaph", n);
            }
        }
        this.writeAttributes(this.m_attrib, ITableAttributes.ATTRIB_ROW_PADDING);
    }

    public boolean isFirstRow() {
        return this.id == 1;
    }

    public boolean isHighestCell(int n) {
        return this.highestCell == n;
    }
}

