/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.collections;

public class CircularBuffer {
    protected Object[] m_buffer;
    protected int m_bufferSize;
    protected int m_contentSize;
    protected int m_head;
    protected int m_tail;

    public CircularBuffer(int size) {
        this.m_buffer = new Object[size];
        this.m_bufferSize = size;
        this.m_contentSize = 0;
        this.m_head = 0;
        this.m_tail = 0;
    }

    public CircularBuffer() {
        this(32);
    }

    public boolean isEmpty() {
        return this.m_contentSize == 0;
    }

    public int getContentSize() {
        return this.m_contentSize;
    }

    public int getBufferSize() {
        return this.m_bufferSize;
    }

    public void append(Object o) {
        if (this.m_contentSize >= this.m_bufferSize) {
            int j = 0;
            int i = this.m_tail;
            Object[] tmp = new Object[this.m_bufferSize * 2];
            while (this.m_contentSize > 0) {
                ++i;
                --this.m_contentSize;
                tmp[++j] = this.m_buffer[i %= this.m_bufferSize];
            }
            this.m_buffer = tmp;
            this.m_tail = 0;
            this.m_head = j;
            this.m_contentSize = j;
            this.m_bufferSize *= 2;
        }
        this.m_buffer[this.m_head] = o;
        ++this.m_head;
        this.m_head %= this.m_bufferSize;
        ++this.m_contentSize;
    }

    public Object get() {
        if (this.m_contentSize <= 0) {
            return null;
        }
        Object o = this.m_buffer[this.m_tail];
        ++this.m_tail;
        this.m_tail %= this.m_bufferSize;
        --this.m_contentSize;
        return o;
    }
}

