/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.caching.Cacheable;
import org.apache.cocoon.caching.TimeStampCacheValidity;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ComposerGenerator;
import org.apache.cocoon.util.HashUtil;
import org.xml.sax.SAXException;

public class FileGenerator
extends ComposerGenerator
implements Cacheable {
    protected Source inputSource;

    public void recycle() {
        super.recycle();
        if (this.inputSource != null) {
            this.inputSource.recycle();
            this.inputSource = null;
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.inputSource = resolver.resolve(src);
    }

    public long generateKey() {
        if (this.inputSource.getLastModified() != 0L) {
            return HashUtil.hash(this.inputSource.getSystemId());
        }
        return 0L;
    }

    public CacheValidity generateValidity() {
        long modified = this.inputSource.getLastModified();
        if (modified != 0L) {
            return new TimeStampCacheValidity(modified);
        }
        return null;
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("processing file " + this.source);
                this.getLogger().debug("file resolved to " + this.inputSource.getSystemId());
            }
            this.inputSource.toSAX(this.xmlConsumer);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (SAXException e) {
            Exception cause = e.getException();
            if (cause != null) {
                this.getLogger().debug("Got SAXException; Rethrowing cause exception", (Throwable)e);
                if (cause instanceof ProcessingException) {
                    throw (ProcessingException)((Object)cause);
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof SAXException) {
                    throw (SAXException)cause;
                }
                throw new ProcessingException("Could not read resource " + this.inputSource.getSystemId(), cause);
            }
            throw e;
        }
        catch (Exception e) {
            this.getLogger().error("Could not read resource " + this.inputSource.getSystemId(), (Throwable)e);
            throw new ProcessingException("Could not read resource " + this.inputSource.getSystemId(), e);
        }
    }
}

