/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml.dom;

import java.net.URL;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.log.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SVGBuilder
extends SAXSVGDocumentFactory
implements XMLConsumer,
Loggable {
    protected Logger log;
    private static final String SAX_PARSER = "org.apache.xerces.parsers.SAXParser";

    protected SVGBuilder() {
        super(SAX_PARSER);
    }

    public void setLogger(Logger logger) {
        if (this.log == null) {
            this.log = logger;
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void startDocument() throws SAXException {
        try {
            String namespaceURI = "http://www.w3.org/2000/svg";
            this.document = this.implementation.createDocument(namespaceURI, "svg", null);
            super.startDocument();
        }
        catch (Exception ex) {
            this.log.error("SVGBuilder: startDocument", (Throwable)ex);
            ex.printStackTrace();
            throw new SAXException("SVGBuilder: startDocument", ex);
        }
    }

    public void endDocument() throws SAXException {
        try {
            super.endDocument();
            ((SVGOMDocument)this.document).setURLObject(new URL("http://xml.apache.org"));
            this.notify(this.document);
        }
        catch (Exception ex) {
            this.log.error("SVGBuilder: endDocument", (Throwable)ex);
            ex.printStackTrace();
            throw new SAXException("SVGBuilder: endDocument", ex);
        }
    }

    protected void notify(Document doc) throws SAXException {
    }
}

