/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.lang;

import com.hp.hpl.jena.rdf.arp.lang.LanguageTag;
import com.hp.hpl.jena.rdf.arp.lang.LanguageTagSyntaxException;
import java.util.HashMap;
import java.util.Map;

public class IanaLanguageTag
extends LanguageTag {
    static final Map all = new HashMap();
    public final int classification;

    private IanaLanguageTag(String string, int n) throws LanguageTagSyntaxException {
        super(string);
        this.classification = 0x1024 | n;
    }

    private IanaLanguageTag(String string) throws LanguageTagSyntaxException {
        this(string, 0);
    }

    public static IanaLanguageTag find(LanguageTag languageTag) {
        if (languageTag.tags.length < 2) {
            return null;
        }
        IanaLanguageTag[] ianaLanguageTagArray = (IanaLanguageTag[])all.get(languageTag.tags[1]);
        if (ianaLanguageTagArray == null) {
            return null;
        }
        int n = 0;
        while (n < ianaLanguageTagArray.length) {
            block6: {
                if (languageTag.tags.length >= ianaLanguageTagArray[n].tags.length) {
                    int n2 = 0;
                    while (n2 < ianaLanguageTagArray[n].tags.length) {
                        if (languageTag.tags[n2].equals(ianaLanguageTagArray[n].tags[n2])) {
                            ++n2;
                            continue;
                        }
                        break block6;
                    }
                    return ianaLanguageTagArray[n];
                }
            }
            ++n;
        }
        return null;
    }

    static {
        try {
            all.put("ami", new IanaLanguageTag[]{new IanaLanguageTag("i-ami")});
            all.put("bnn", new IanaLanguageTag[]{new IanaLanguageTag("i-bnn")});
            all.put("bok", new IanaLanguageTag[]{new IanaLanguageTag("no-bok", 8192)});
            all.put("default", new IanaLanguageTag[]{new IanaLanguageTag("i-default", 256)});
            all.put("gan", new IanaLanguageTag[]{new IanaLanguageTag("zh-gan")});
            all.put("gaulish", new IanaLanguageTag[]{new IanaLanguageTag("cel-gaulish")});
            all.put("gb", new IanaLanguageTag[]{new IanaLanguageTag("sgn-GB")});
            all.put("guoyu", new IanaLanguageTag[]{new IanaLanguageTag("zh-guoyu")});
            all.put("hak", new IanaLanguageTag[]{new IanaLanguageTag("i-hak", 8192)});
            all.put("hakka", new IanaLanguageTag[]{new IanaLanguageTag("zh-hakka")});
            all.put("ie", new IanaLanguageTag[]{new IanaLanguageTag("sgn-IE")});
            all.put("klingon", new IanaLanguageTag[]{new IanaLanguageTag("i-klingon")});
            all.put("lux", new IanaLanguageTag[]{new IanaLanguageTag("i-lux", 8192)});
            all.put("min", new IanaLanguageTag[]{new IanaLanguageTag("zh-min"), new IanaLanguageTag("zh-min-nan")});
            all.put("mingo", new IanaLanguageTag[]{new IanaLanguageTag("i-mingo")});
            all.put("navajo", new IanaLanguageTag[]{new IanaLanguageTag("i-navajo", 8192)});
            all.put("ni", new IanaLanguageTag[]{new IanaLanguageTag("sgn-NI")});
            all.put("nyn", new IanaLanguageTag[]{new IanaLanguageTag("no-nyn", 8192)});
            all.put("pwn", new IanaLanguageTag[]{new IanaLanguageTag("i-pwn")});
            all.put("tao", new IanaLanguageTag[]{new IanaLanguageTag("i-tao")});
            all.put("tay", new IanaLanguageTag[]{new IanaLanguageTag("i-tay")});
            all.put("tsu", new IanaLanguageTag[]{new IanaLanguageTag("i-tsu")});
            all.put("us", new IanaLanguageTag[]{new IanaLanguageTag("sgn-US")});
            all.put("wuu", new IanaLanguageTag[]{new IanaLanguageTag("zh-wuu")});
            all.put("xiang", new IanaLanguageTag[]{new IanaLanguageTag("zh-xiang")});
            all.put("yue", new IanaLanguageTag[]{new IanaLanguageTag("zh-yue")});
        }
        catch (LanguageTagSyntaxException languageTagSyntaxException) {
            System.err.println("Internal Error in static initializer of IanaLnaguageTag.");
        }
    }
}

