/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query;

import com.hp.hpl.jena.rdf.query.Value;
import com.hp.hpl.jena.rdf.query.Var;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.Resource;

public class Slot {
    Value value;
    Var variable;
    Resource resource;
    Property property;

    private void unset() {
        this.value = null;
        this.variable = null;
        this.resource = null;
        this.property = null;
    }

    public Slot() {
        this.unset();
    }

    public Slot(Slot slot) {
        this.value = slot.value;
        this.variable = slot.variable;
        this.property = slot.property;
        this.resource = slot.resource;
    }

    public void set(Value value) {
        this.unset();
        this.value = value;
    }

    public void set(Var var) {
        this.unset();
        this.variable = var;
    }

    public void set(Resource resource) {
        this.unset();
        this.resource = resource;
    }

    public void set(Property property) {
        this.unset();
        this.property = property;
    }

    public boolean isValue() {
        return this.value != null;
    }

    public boolean isVar() {
        return this.variable != null;
    }

    public boolean isResource() {
        return this.resource != null;
    }

    public boolean isProperty() {
        return this.property != null;
    }

    public Value getValue() {
        return this.value;
    }

    public Var getVar() {
        return this.variable;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Property getProperty() {
        return this.property;
    }

    public String getVarName() {
        if (this.variable == null) {
            return null;
        }
        return this.variable.getVarName();
    }

    public String toString() {
        if (this.value != null) {
            return this.value.asInfixString();
        }
        if (this.variable != null) {
            return this.variable.toString();
        }
        if (this.property != null) {
            return "<" + this.property.toString() + ">";
        }
        if (this.resource != null) {
            return "<" + this.resource.toString() + ">";
        }
        return "slot:unset";
    }
}

