/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.parser;

import com.hp.hpl.jena.rdf.query.EvalTypeException;
import com.hp.hpl.jena.rdf.query.Query;
import com.hp.hpl.jena.rdf.query.QueryException;
import com.hp.hpl.jena.rdf.query.QueryFormatUtils;
import com.hp.hpl.jena.rdf.query.ResultBinding;
import com.hp.hpl.jena.rdf.query.Value;
import com.hp.hpl.jena.rdf.query.WorkingVar;
import com.hp.hpl.jena.rdf.query.parser.Expr;
import com.hp.hpl.jena.rdf.query.parser.ExprNumeric;
import com.hp.hpl.jena.rdf.query.parser.RDQLParser;
import com.hp.hpl.jena.rdf.query.parser.SimpleNode;
import java.io.PrintWriter;

class Q_UnaryMinus
extends SimpleNode
implements ExprNumeric {
    Expr expr;
    private String printName = "unaryminus";
    private String opSymbol = "-";

    Q_UnaryMinus(int n) {
        super(n);
    }

    Q_UnaryMinus(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public Value eval(Query query, ResultBinding resultBinding) {
        Value value = this.expr.eval(query, resultBinding);
        if (!value.isNumber()) {
            throw new EvalTypeException("Q_UnaryMinus: Wanted a number: got " + this.expr);
        }
        WorkingVar workingVar = new WorkingVar();
        if (value.isInt()) {
            workingVar.setInt(-value.getInt());
        } else {
            workingVar.setLong(-value.getLong());
        }
        return workingVar;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 1) {
            throw new QueryException("Q_UnaryMinus: Wrong number of children: " + n);
        }
        this.expr = (Expr)((Object)this.jjtGetChild(0));
    }

    public String asInfixString() {
        return QueryFormatUtils.asInfixString1(this.expr, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return QueryFormatUtils.asPrefixString(this.expr, null, this.printName, this.opSymbol);
    }

    public void print(PrintWriter printWriter, int n) {
        QueryFormatUtils.print(printWriter, this.expr, null, this.printName, this.opSymbol, n);
    }

    public String toString() {
        return this.asInfixString();
    }
}

