/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSEngineListener;
import org.apache.batik.css.engine.CSSImportNode;
import org.apache.batik.css.engine.CSSImportedElementRoot;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.CSSStyleSheetNode;
import org.apache.batik.css.engine.ImportRule;
import org.apache.batik.css.engine.MediaRule;
import org.apache.batik.css.engine.Messages;
import org.apache.batik.css.engine.Rule;
import org.apache.batik.css.engine.StringIntMap;
import org.apache.batik.css.engine.StyleDeclaration;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.StyleRule;
import org.apache.batik.css.engine.StyleSheet;
import org.apache.batik.css.engine.sac.CSSConditionFactory;
import org.apache.batik.css.engine.sac.CSSSelectorFactory;
import org.apache.batik.css.engine.sac.ExtendedSelector;
import org.apache.batik.css.engine.value.ComputedValue;
import org.apache.batik.css.engine.value.InheritValue;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.util.ParsedURL;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public abstract class CSSEngine {
    protected CSSContext cssContext;
    protected Document document;
    protected URL documentURI;
    protected StringIntMap indexes;
    protected StringIntMap shorthandIndexes;
    protected ValueManager[] valueManagers;
    protected ShorthandManager[] shorthandManagers;
    protected ExtendedParser parser;
    protected String[] pseudoElementNames;
    protected int fontSizeIndex = -1;
    protected int lineHeightIndex = -1;
    protected int colorIndex = -1;
    protected StyleSheet userAgentStyleSheet;
    protected StyleSheet userStyleSheet;
    protected SACMediaList media;
    protected List styleSheetNodes;
    protected String styleNamespaceURI;
    protected String styleLocalName;
    protected String classNamespaceURI;
    protected String classLocalName;
    protected Set nonCSSPresentationalHints;
    protected String nonCSSPresentationalHintsNamespaceURI;
    protected StyleDeclarationDocumentHandler styleDeclarationDocumentHandler = new StyleDeclarationDocumentHandler();
    protected StyleDeclarationUpdateHandler styleDeclarationUpdateHandler;
    protected StyleSheetDocumentHandler styleSheetDocumentHandler = new StyleSheetDocumentHandler();
    protected StyleDeclarationBuilder styleDeclarationBuilder = new StyleDeclarationBuilder();
    protected CSSStylableElement element;
    protected URL cssBaseURI;
    protected String alternateStyleSheet;
    protected EventListener domAttrModifiedListener;
    protected EventListener domNodeInsertedListener;
    protected EventListener domNodeRemovedListener;
    protected EventListener domSubtreeModifiedListener;
    protected EventListener domCharacterDataModifiedListener;
    protected boolean styleSheetRemoved;
    protected Node removedStylableElementSibling;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected Set selectorAttributes;
    protected final int[] ALL_PROPERTIES;
    protected CSSConditionFactory cssConditionFactory;
    protected static final CSSEngineListener[] LISTENER_ARRAY = new CSSEngineListener[0];

    public static CSSStylableElement getParentCSSStylableElement(Element element) {
        Element element2 = CSSEngine.getParentElement(element);
        while (element2 != null) {
            if (element2 instanceof CSSStylableElement) {
                return (CSSStylableElement)element2;
            }
            element2 = CSSEngine.getParentElement(element2);
        }
        return null;
    }

    public static Element getParentElement(Element element) {
        for (Node node = element.getParentNode(); node != null; node = node.getParentNode()) {
            if ((node = CSSEngine.getLogicalParentNode(node)).getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public static Node getLogicalParentNode(Node node) {
        Node node2 = node;
        if (node2 != null) {
            if (node2 instanceof CSSImportedElementRoot) {
                return ((CSSImportedElementRoot)node2).getCSSParentElement();
            }
            return node2;
        }
        return null;
    }

    public static Node getImportedChild(Node node) {
        if (node instanceof CSSImportNode) {
            CSSImportNode cSSImportNode = (CSSImportNode)node;
            CSSImportedElementRoot cSSImportedElementRoot = cSSImportNode.getCSSImportedElementRoot();
            if (cSSImportedElementRoot == null) {
                return null;
            }
            return cSSImportedElementRoot.getFirstChild();
        }
        return null;
    }

    protected CSSEngine(Document document, URL uRL, ExtendedParser extendedParser, ValueManager[] valueManagerArray, ShorthandManager[] shorthandManagerArray, String[] stringArray, String string, String string2, String string3, String string4, boolean bl, String string5, CSSContext cSSContext) {
        String string6;
        int n;
        this.document = document;
        this.documentURI = uRL;
        this.parser = extendedParser;
        this.pseudoElementNames = stringArray;
        this.styleNamespaceURI = string;
        this.styleLocalName = string2;
        this.classNamespaceURI = string3;
        this.classLocalName = string4;
        this.cssContext = cSSContext;
        this.cssConditionFactory = new CSSConditionFactory(string3, string4, null, "id");
        int n2 = valueManagerArray.length;
        this.indexes = new StringIntMap(n2);
        this.valueManagers = valueManagerArray;
        for (n = n2 - 1; n >= 0; --n) {
            string6 = valueManagerArray[n].getPropertyName();
            this.indexes.put(string6, n);
            if (this.fontSizeIndex == -1 && string6.equals("font-size")) {
                this.fontSizeIndex = n;
            }
            if (this.lineHeightIndex == -1 && string6.equals("line-height")) {
                this.lineHeightIndex = n;
            }
            if (this.colorIndex != -1 || !string6.equals("color")) continue;
            this.colorIndex = n;
        }
        n2 = shorthandManagerArray.length;
        this.shorthandIndexes = new StringIntMap(n2);
        this.shorthandManagers = shorthandManagerArray;
        for (n = n2 - 1; n >= 0; --n) {
            this.shorthandIndexes.put(shorthandManagerArray[n].getPropertyName(), n);
        }
        if (bl) {
            n2 = valueManagerArray.length;
            this.nonCSSPresentationalHints = new HashSet();
            this.nonCSSPresentationalHintsNamespaceURI = string5;
            for (n = n2 - 1; n >= 0; --n) {
                string6 = valueManagerArray[n].getPropertyName();
                this.nonCSSPresentationalHints.add(string6);
            }
        }
        if (this.cssContext.isDynamic() && this.document instanceof EventTarget) {
            EventTarget eventTarget = (EventTarget)((Object)this.document);
            this.domAttrModifiedListener = new DOMAttrModifiedListener();
            eventTarget.addEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            this.domNodeInsertedListener = new DOMNodeInsertedListener();
            eventTarget.addEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            this.domNodeRemovedListener = new DOMNodeRemovedListener();
            eventTarget.addEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            this.domSubtreeModifiedListener = new DOMSubtreeModifiedListener();
            eventTarget.addEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            this.domCharacterDataModifiedListener = new DOMCharacterDataModifiedListener();
            eventTarget.addEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
            this.styleDeclarationUpdateHandler = new StyleDeclarationUpdateHandler();
        }
        this.ALL_PROPERTIES = new int[this.getNumberOfProperties()];
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            this.ALL_PROPERTIES[i] = i;
        }
    }

    public void dispose() {
        this.disposeStyleMaps(this.document.getDocumentElement());
        if (this.document instanceof EventTarget) {
            EventTarget eventTarget = (EventTarget)((Object)this.document);
            eventTarget.removeEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            eventTarget.removeEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            eventTarget.removeEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            eventTarget.removeEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            eventTarget.removeEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
        }
    }

    private void disposeStyleMaps(Node node) {
        if (node instanceof CSSStylableElement) {
            ((CSSStylableElement)node).setComputedStyleMap(null, null);
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3;
            if (node2.getNodeType() == 1) {
                this.disposeStyleMaps(node2);
            }
            if ((node3 = CSSEngine.getImportedChild(node2)) == null) continue;
            this.disposeStyleMaps(node3);
        }
    }

    public CSSContext getCSSContext() {
        return this.cssContext;
    }

    public Document getDocument() {
        return this.document;
    }

    public int getFontSizeIndex() {
        return this.fontSizeIndex;
    }

    public int getLineHeightIndex() {
        return this.lineHeightIndex;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public int getNumberOfProperties() {
        return this.valueManagers.length;
    }

    public int getPropertyIndex(String string) {
        return this.indexes.get(string);
    }

    public int getShorthandIndex(String string) {
        return this.shorthandIndexes.get(string);
    }

    public String getPropertyName(int n) {
        return this.valueManagers[n].getPropertyName();
    }

    public void setUserAgentStyleSheet(StyleSheet styleSheet) {
        this.userAgentStyleSheet = styleSheet;
    }

    public void setUserStyleSheet(StyleSheet styleSheet) {
        this.userStyleSheet = styleSheet;
    }

    public ValueManager[] getValueManagers() {
        return this.valueManagers;
    }

    public void setMedia(String string) {
        try {
            this.media = this.parser.parseMedia(string);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            String string3 = Messages.formatMessage("media.error", new Object[]{string, string2 == null ? "" : string2});
            throw new DOMException(12, string3);
        }
    }

    public void setAlternateStyleSheet(String string) {
        this.alternateStyleSheet = string;
    }

    public void importCascadedStyleMaps(Element element, CSSEngine cSSEngine, Element element2) {
        Node node;
        Node node2;
        if (element instanceof CSSStylableElement) {
            node2 = (CSSStylableElement)element;
            node = (CSSStylableElement)element2;
            StyleMap styleMap = cSSEngine.getCascadedStyleMap((CSSStylableElement)node2, null);
            styleMap.setFixedCascadedStyle(true);
            node.setComputedStyleMap(null, styleMap);
            if (this.pseudoElementNames != null) {
                int n = this.pseudoElementNames.length;
                for (int i = 0; i < n; ++i) {
                    String string = this.pseudoElementNames[i];
                    styleMap = cSSEngine.getCascadedStyleMap((CSSStylableElement)node2, string);
                    node.setComputedStyleMap(string, styleMap);
                }
            }
        }
        node2 = element2.getFirstChild();
        node = element.getFirstChild();
        while (node2 != null) {
            if (node.getNodeType() == 1) {
                this.importCascadedStyleMaps((Element)node, cSSEngine, (Element)node2);
            }
            node2 = node2.getNextSibling();
            node = node.getNextSibling();
        }
    }

    public URL getCSSBaseURI() {
        if (this.cssBaseURI == null) {
            this.cssBaseURI = this.element.getCSSBase();
        }
        return this.cssBaseURI;
    }

    public StyleMap getCascadedStyleMap(CSSStylableElement cSSStylableElement, String string) {
        String string2;
        Object object;
        Object object2;
        int n;
        Object object3;
        int n2 = this.getNumberOfProperties();
        StyleMap styleMap = new StyleMap(n2);
        if (this.userAgentStyleSheet != null) {
            object3 = new ArrayList();
            this.addMatchingRules((List)object3, this.userAgentStyleSheet, cSSStylableElement, string);
            this.addRules(cSSStylableElement, string, styleMap, (List)object3, (short)0);
        }
        if (this.userStyleSheet != null) {
            object3 = new ArrayList();
            this.addMatchingRules((List)object3, this.userStyleSheet, cSSStylableElement, string);
            this.addRules(cSSStylableElement, string, styleMap, (List)object3, (short)8192);
        }
        this.element = cSSStylableElement;
        if (this.nonCSSPresentationalHints != null) {
            object3 = cSSStylableElement.getAttributes();
            n = object3.getLength();
            for (int i = 0; i < n; ++i) {
                Object object4;
                Node node = object3.item(i);
                object2 = node.getNodeName();
                if (!this.nonCSSPresentationalHints.contains(object2)) continue;
                try {
                    int n3 = this.getPropertyIndex((String)object2);
                    object = this.parser.parsePropertyValue(node.getNodeValue());
                    object4 = this.valueManagers[n3];
                    Value value = object4.createValue((LexicalUnit)object, this);
                    this.putAuthorProperty(styleMap, n3, value, false, (short)16384);
                    continue;
                }
                catch (Exception exception) {
                    String string3 = exception.getMessage();
                    object4 = Messages.formatMessage("property.syntax.error.at", new Object[]{this.documentURI.toString(), object2, node.getNodeValue(), string3 == null ? "" : string3});
                    throw new DOMException(12, (String)object4);
                }
            }
        }
        if ((n = (object3 = this.getStyleSheetNodes()).size()) > 0) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < n; ++i) {
                object2 = (CSSStyleSheetNode)object3.get(i);
                object = object2.getCSSStyleSheet();
                if (object == null || ((StyleSheet)object).isAlternate() && ((StyleSheet)object).getTitle() != null && !((StyleSheet)object).getTitle().equals(this.alternateStyleSheet) || !this.mediaMatch(((StyleSheet)object).getMedia())) continue;
                this.addMatchingRules(arrayList, (StyleSheet)object, cSSStylableElement, string);
            }
            this.addRules(cSSStylableElement, string, styleMap, arrayList, (short)24576);
        }
        if (this.styleLocalName != null && (string2 = cSSStylableElement.getAttributeNS(this.styleNamespaceURI, this.styleLocalName)).length() > 0) {
            try {
                this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                this.parser.setConditionFactory(this.cssConditionFactory);
                this.styleDeclarationDocumentHandler.styleMap = styleMap;
                this.parser.setDocumentHandler(this.styleDeclarationDocumentHandler);
                this.parser.parseStyleDeclaration(string2);
                this.styleDeclarationDocumentHandler.styleMap = null;
            }
            catch (Exception exception) {
                object2 = exception.getMessage();
                object = Messages.formatMessage("style.syntax.error.at", new Object[]{this.documentURI.toString(), this.styleLocalName, string2, object2 == null ? "" : object2});
                throw new DOMException(12, (String)object);
            }
        }
        this.element = null;
        this.cssBaseURI = null;
        return styleMap;
    }

    public Value getComputedStyle(CSSStylableElement cSSStylableElement, String string, int n) {
        StyleMap styleMap = cSSStylableElement.getComputedStyleMap(string);
        if (styleMap == null) {
            styleMap = this.getCascadedStyleMap(cSSStylableElement, string);
            cSSStylableElement.setComputedStyleMap(string, styleMap);
        }
        Value value = styleMap.getValue(n);
        if (!styleMap.isComputed(n)) {
            Value value2 = value;
            ValueManager valueManager = this.valueManagers[n];
            CSSStylableElement cSSStylableElement2 = CSSEngine.getParentCSSStylableElement(cSSStylableElement);
            if (!(value != null || valueManager.isInheritedProperty() && cSSStylableElement2 != null)) {
                value2 = valueManager.getDefaultValue();
            } else if (value != null && value == InheritValue.INSTANCE && cSSStylableElement2 != null) {
                value2 = null;
            }
            if (value2 == null) {
                value2 = this.getComputedStyle(cSSStylableElement2, null, n);
                styleMap.putParentRelative(n, true);
            } else {
                value2 = valueManager.computeValue(cSSStylableElement, string, this, n, styleMap, value2);
            }
            if (value == null) {
                styleMap.putValue(n, value2);
                styleMap.putNullCascaded(n, true);
            } else if (value2 != value) {
                ComputedValue computedValue = new ComputedValue(value);
                computedValue.setComputedValue(value2);
                styleMap.putValue(n, computedValue);
                value2 = computedValue;
            }
            styleMap.putComputed(n, true);
            value = value2;
        }
        return value;
    }

    public List getStyleSheetNodes() {
        if (this.styleSheetNodes == null) {
            this.styleSheetNodes = new ArrayList();
            this.selectorAttributes = new HashSet();
            this.findStyleSheetNodes(this.document);
            int n = this.styleSheetNodes.size();
            for (int i = 0; i < n; ++i) {
                CSSStyleSheetNode cSSStyleSheetNode = (CSSStyleSheetNode)this.styleSheetNodes.get(i);
                StyleSheet styleSheet = cSSStyleSheetNode.getCSSStyleSheet();
                if (styleSheet == null) continue;
                this.findSelectorAttributes(this.selectorAttributes, styleSheet);
            }
        }
        return this.styleSheetNodes;
    }

    protected void findStyleSheetNodes(Node node) {
        if (node instanceof CSSStyleSheetNode) {
            this.styleSheetNodes.add(node);
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            this.findStyleSheetNodes(node2);
        }
    }

    protected void findSelectorAttributes(Set set, StyleSheet styleSheet) {
        int n = styleSheet.getSize();
        block4: for (int i = 0; i < n; ++i) {
            Rule rule = styleSheet.getRule(i);
            switch (rule.getType()) {
                case 0: {
                    StyleRule styleRule = (StyleRule)rule;
                    SelectorList selectorList = styleRule.getSelectorList();
                    int n2 = selectorList.getLength();
                    for (int j = 0; j < n2; ++j) {
                        ExtendedSelector extendedSelector = (ExtendedSelector)selectorList.item(j);
                        extendedSelector.fillAttributeSet(set);
                    }
                    continue block4;
                }
                case 1: 
                case 2: {
                    MediaRule mediaRule = (MediaRule)rule;
                    if (!this.mediaMatch(mediaRule.getMediaList())) continue block4;
                    this.findSelectorAttributes(set, mediaRule);
                }
            }
        }
    }

    public Value parsePropertyValue(CSSStylableElement cSSStylableElement, String string, String string2) {
        try {
            this.element = cSSStylableElement;
            int n = this.getPropertyIndex(string);
            LexicalUnit lexicalUnit = this.parser.parsePropertyValue(string2);
            ValueManager valueManager = this.valueManagers[n];
            Value value = valueManager.createValue(lexicalUnit, this);
            return value;
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            String string4 = Messages.formatMessage("property.syntax.error.at", new Object[]{this.documentURI.toString(), string, string2, string3 == null ? "" : string3});
            throw new DOMException(12, string4);
        }
        finally {
            this.element = null;
        }
    }

    public StyleDeclaration parseStyleDeclaration(String string) {
        try {
            this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
            this.parser.setConditionFactory(this.cssConditionFactory);
            this.cssBaseURI = this.documentURI;
            this.styleDeclarationBuilder.styleDeclaration = new StyleDeclaration();
            this.parser.setDocumentHandler(this.styleDeclarationBuilder);
            this.parser.parseStyleDeclaration(string);
            this.cssBaseURI = null;
            return this.styleDeclarationBuilder.styleDeclaration;
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            String string3 = Messages.formatMessage("syntax.error.at", new Object[]{this.documentURI.toString(), string2 == null ? "" : string2});
            throw new DOMException(12, string3);
        }
    }

    public StyleSheet parseStyleSheet(URL uRL, String string) throws DOMException {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.setMedia(this.parser.parseMedia(string));
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            String string3 = Messages.formatMessage("syntax.error.at", new Object[]{this.documentURI.toString(), string2 == null ? "" : string2});
            throw new DOMException(12, string3);
        }
        this.parseStyleSheet(styleSheet, uRL);
        return styleSheet;
    }

    public StyleSheet parseStyleSheet(InputSource inputSource, URL uRL, String string) throws DOMException {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.setMedia(this.parser.parseMedia(string));
            this.parseStyleSheet(styleSheet, inputSource, uRL);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            String string3 = Messages.formatMessage("syntax.error.at", new Object[]{this.documentURI.toString(), string2 == null ? "" : string2});
            throw new DOMException(12, string3);
        }
        return styleSheet;
    }

    public void parseStyleSheet(StyleSheet styleSheet, URL uRL) throws DOMException {
        if (uRL == null) {
            String string = Messages.formatMessage("syntax.error.at", new Object[]{"Null Document reference", ""});
            throw new DOMException(12, string);
        }
        try {
            ParsedURL parsedURL = null;
            if (this.documentURI != null) {
                parsedURL = new ParsedURL(this.documentURI);
            }
            ParsedURL parsedURL2 = null;
            parsedURL2 = new ParsedURL(uRL);
            this.cssContext.checkLoadExternalResource(parsedURL2, parsedURL);
            this.parseStyleSheet(styleSheet, new InputSource(uRL.toString()), uRL);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            String string2 = Messages.formatMessage("syntax.error.at", new Object[]{uRL.toString(), string == null ? "" : string});
            throw new DOMException(12, string2);
        }
    }

    public StyleSheet parseStyleSheet(String string, URL uRL, String string2) throws DOMException {
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.setMedia(this.parser.parseMedia(string2));
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            String string4 = Messages.formatMessage("syntax.error.at", new Object[]{this.documentURI.toString(), string3 == null ? "" : string3});
            throw new DOMException(12, string4);
        }
        this.parseStyleSheet(styleSheet, string, uRL);
        return styleSheet;
    }

    public void parseStyleSheet(StyleSheet styleSheet, String string, URL uRL) throws DOMException {
        try {
            this.parseStyleSheet(styleSheet, new InputSource(new StringReader(string)), uRL);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            String string3 = Messages.formatMessage("stylesheet.syntax.error", new Object[]{uRL.toString(), string, string2 == null ? "" : string2});
            throw new DOMException(12, string3);
        }
    }

    protected void parseStyleSheet(StyleSheet styleSheet, InputSource inputSource, URL uRL) throws IOException {
        Rule rule;
        this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
        this.parser.setConditionFactory(this.cssConditionFactory);
        this.cssBaseURI = uRL;
        this.styleSheetDocumentHandler.styleSheet = styleSheet;
        this.parser.setDocumentHandler(this.styleSheetDocumentHandler);
        this.parser.parseStyleSheet(inputSource);
        this.cssBaseURI = null;
        int n = styleSheet.getSize();
        for (int i = 0; i < n && (rule = styleSheet.getRule(i)).getType() == 2; ++i) {
            ImportRule importRule = (ImportRule)rule;
            this.parseStyleSheet(importRule, importRule.getURI());
        }
    }

    protected void putAuthorProperty(StyleMap styleMap, int n, Value value, boolean bl, short s) {
        boolean bl2;
        Value value2 = styleMap.getValue(n);
        short s2 = styleMap.getOrigin(n);
        boolean bl3 = styleMap.isImportant(n);
        boolean bl4 = bl2 = value2 == null;
        if (!bl2) {
            switch (s2) {
                case 8192: {
                    bl2 = !bl3;
                    break;
                }
                case 24576: {
                    bl2 = !bl3 || bl;
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            styleMap.putValue(n, value);
            styleMap.putImportant(n, bl);
            styleMap.putOrigin(n, s);
        }
    }

    protected void addMatchingRules(List list, StyleSheet styleSheet, Element element, String string) {
        int n = styleSheet.getSize();
        block4: for (int i = 0; i < n; ++i) {
            Rule rule = styleSheet.getRule(i);
            switch (rule.getType()) {
                case 0: {
                    StyleRule styleRule = (StyleRule)rule;
                    SelectorList selectorList = styleRule.getSelectorList();
                    int n2 = selectorList.getLength();
                    for (int j = 0; j < n2; ++j) {
                        ExtendedSelector extendedSelector = (ExtendedSelector)selectorList.item(j);
                        if (!extendedSelector.match(element, string)) continue;
                        list.add(styleRule);
                    }
                    continue block4;
                }
                case 1: 
                case 2: {
                    MediaRule mediaRule = (MediaRule)rule;
                    if (!this.mediaMatch(mediaRule.getMediaList())) continue block4;
                    this.addMatchingRules(list, mediaRule, element, string);
                }
            }
        }
    }

    protected void addRules(Element element, String string, StyleMap styleMap, List list, short s) {
        this.sortRules(list, element, string);
        int n = list.size();
        int n2 = this.getNumberOfProperties();
        if (s == 24576) {
            for (int i = 0; i < n; ++i) {
                StyleRule styleRule = (StyleRule)list.get(i);
                StyleDeclaration styleDeclaration = styleRule.getStyleDeclaration();
                int n3 = styleDeclaration.size();
                for (int j = 0; j < n3; ++j) {
                    this.putAuthorProperty(styleMap, styleDeclaration.getIndex(j), styleDeclaration.getValue(j), styleDeclaration.getPriority(j), s);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                StyleRule styleRule = (StyleRule)list.get(i);
                StyleDeclaration styleDeclaration = styleRule.getStyleDeclaration();
                int n4 = styleDeclaration.size();
                for (int j = 0; j < n4; ++j) {
                    int n5 = styleDeclaration.getIndex(j);
                    styleMap.putValue(n5, styleDeclaration.getValue(j));
                    styleMap.putImportant(n5, styleDeclaration.getPriority(j));
                    styleMap.putOrigin(n5, s);
                }
            }
        }
    }

    protected void sortRules(List list, Element element, String string) {
        int n = list.size();
        for (int i = 0; i < n - 1; ++i) {
            int n2 = i;
            int n3 = Integer.MAX_VALUE;
            for (int j = i; j < n; ++j) {
                StyleRule styleRule = (StyleRule)list.get(j);
                SelectorList selectorList = styleRule.getSelectorList();
                int n4 = 0;
                int n5 = selectorList.getLength();
                for (int k = 0; k < n5; ++k) {
                    int n6;
                    ExtendedSelector extendedSelector = (ExtendedSelector)selectorList.item(k);
                    if (!extendedSelector.match(element, string) || (n6 = extendedSelector.getSpecificity()) <= n4) continue;
                    n4 = n6;
                }
                if (n4 >= n3) continue;
                n3 = n4;
                n2 = j;
            }
            if (i == n2) continue;
            Object e = list.get(i);
            list.set(i, list.get(n2));
            list.set(n2, e);
        }
    }

    protected boolean mediaMatch(SACMediaList sACMediaList) {
        if (this.media == null || sACMediaList == null || this.media.getLength() == 0 || sACMediaList.getLength() == 0) {
            return true;
        }
        for (int i = 0; i < sACMediaList.getLength(); ++i) {
            for (int j = 0; j < this.media.getLength(); ++j) {
                if (!this.media.item(j).equalsIgnoreCase("all") && !sACMediaList.item(i).equalsIgnoreCase(this.media.item(j))) continue;
                return true;
            }
        }
        return false;
    }

    public void addCSSEngineListener(CSSEngineListener cSSEngineListener) {
        this.listeners.add(cSSEngineListener);
    }

    public void removeCSSEngineListener(CSSEngineListener cSSEngineListener) {
        this.listeners.remove(cSSEngineListener);
    }

    protected void firePropertiesChangedEvent(Element element, int[] nArray) {
        CSSEngineListener[] cSSEngineListenerArray = this.listeners.toArray(LISTENER_ARRAY);
        int n = cSSEngineListenerArray.length;
        if (n > 0) {
            CSSEngineEvent cSSEngineEvent = new CSSEngineEvent(this, element, nArray);
            for (int i = 0; i < n; ++i) {
                cSSEngineListenerArray[i].propertiesChanged(cSSEngineEvent);
            }
        }
    }

    protected void inlineStyleAttributeUpdated(CSSStylableElement cSSStylableElement, StyleMap styleMap, MutationEvent mutationEvent) {
        boolean[] blArray = this.styleDeclarationUpdateHandler.updatedProperties;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            blArray[i] = false;
        }
        switch (mutationEvent.getAttrChange()) {
            case 1: 
            case 2: {
                String string = mutationEvent.getNewValue();
                if (string.length() > 0) {
                    this.element = cSSStylableElement;
                    try {
                        this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                        this.parser.setConditionFactory(this.cssConditionFactory);
                        this.styleDeclarationUpdateHandler.styleMap = styleMap;
                        this.parser.setDocumentHandler(this.styleDeclarationUpdateHandler);
                        this.parser.parseStyleDeclaration(string);
                        this.styleDeclarationUpdateHandler.styleMap = null;
                    }
                    catch (Exception exception) {
                        String string2 = exception.getMessage();
                        String string3 = Messages.formatMessage("style.syntax.error.at", new Object[]{this.documentURI.toString(), this.styleLocalName, string, string2 == null ? "" : string2});
                        throw new DOMException(12, string3);
                    }
                    this.element = null;
                    this.cssBaseURI = null;
                }
            }
            case 3: {
                int n;
                boolean bl = false;
                if (mutationEvent.getPrevValue() != null && mutationEvent.getPrevValue().length() > 0) {
                    for (n = this.getNumberOfProperties() - 1; n >= 0; --n) {
                        if (!styleMap.isComputed(n) || styleMap.getOrigin(n) != Short.MIN_VALUE || blArray[n]) continue;
                        bl = true;
                        blArray[n] = true;
                    }
                }
                if (bl) {
                    cSSStylableElement.setComputedStyleMap(null, null);
                    this.firePropertiesChangedEvent(cSSStylableElement, this.ALL_PROPERTIES);
                    Node node = CSSEngine.getImportedChild(cSSStylableElement);
                    if (node != null) {
                        this.propagateChanges(node, this.ALL_PROPERTIES);
                    }
                    for (Node node2 = cSSStylableElement.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        this.propagateChanges(node2, this.ALL_PROPERTIES);
                    }
                } else {
                    n = 0;
                    boolean bl2 = this.fontSizeIndex == -1 ? false : blArray[this.fontSizeIndex];
                    boolean bl3 = this.lineHeightIndex == -1 ? false : blArray[this.lineHeightIndex];
                    boolean bl4 = this.colorIndex == -1 ? false : blArray[this.colorIndex];
                    for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                        if (!blArray[i]) {
                            if (!styleMap.isComputed(i)) continue;
                            if (bl2 && styleMap.isFontSizeRelative(i)) {
                                blArray[i] = true;
                                ++n;
                                CSSEngine.clearComputedValue(styleMap, i);
                            }
                            if (bl3 && styleMap.isLineHeightRelative(i)) {
                                blArray[i] = true;
                                ++n;
                                CSSEngine.clearComputedValue(styleMap, i);
                            }
                            if (!bl4 || !styleMap.isColorRelative(i)) continue;
                            blArray[i] = true;
                            ++n;
                            CSSEngine.clearComputedValue(styleMap, i);
                            continue;
                        }
                        ++n;
                    }
                    if (n <= 0) break;
                    int[] nArray = new int[n];
                    n = 0;
                    for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
                        if (!blArray[i]) continue;
                        nArray[n++] = i;
                    }
                    this.firePropertiesChangedEvent(cSSStylableElement, nArray);
                    Node node = CSSEngine.getImportedChild(cSSStylableElement);
                    if (node != null) {
                        this.propagateChanges(node, nArray);
                    }
                    for (Node node3 = cSSStylableElement.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                        this.propagateChanges(node3, nArray);
                    }
                }
                break;
            }
            default: {
                throw new InternalError("Invalid attrChangeType");
            }
        }
    }

    private static void clearComputedValue(StyleMap styleMap, int n) {
        if (styleMap.isNullCascaded(n)) {
            styleMap.putValue(n, null);
        } else {
            Value value = styleMap.getValue(n);
            if (value instanceof ComputedValue) {
                ComputedValue computedValue = (ComputedValue)value;
                value = computedValue.getCascadedValue();
                styleMap.putValue(n, value);
            }
        }
        styleMap.putComputed(n, false);
    }

    protected void invalidateTreeProperties(Node node) {
        Node node2;
        Object object;
        if (node instanceof CSSStylableElement && (object = (node2 = (CSSStylableElement)node).getComputedStyleMap(null)) != null) {
            node2.setComputedStyleMap(null, null);
            this.firePropertiesChangedEvent((Element)node2, this.ALL_PROPERTIES);
        }
        if ((node2 = CSSEngine.getImportedChild(node)) != null) {
            this.propagateChanges(node2, this.ALL_PROPERTIES);
        }
        for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
            this.invalidateTreeProperties((Node)object);
        }
    }

    protected void invalidateProperties(Node node) {
        Node node2;
        Object object;
        if (node instanceof CSSStylableElement && (object = (node2 = (CSSStylableElement)node).getComputedStyleMap(null)) != null) {
            node2.setComputedStyleMap(null, null);
            this.firePropertiesChangedEvent((Element)node2, this.ALL_PROPERTIES);
        }
        if ((node2 = CSSEngine.getImportedChild(node)) != null) {
            this.propagateChanges(node2, this.ALL_PROPERTIES);
        }
        for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
            this.propagateChanges((Node)object, this.ALL_PROPERTIES);
        }
    }

    protected void propagateChanges(Node node, int[] nArray) {
        Node node2;
        Object object;
        if (node instanceof CSSStylableElement && (object = (node2 = (CSSStylableElement)node).getComputedStyleMap(null)) != null) {
            int n;
            int n2;
            int n3;
            boolean[] blArray = this.styleDeclarationUpdateHandler.updatedProperties;
            for (n3 = this.getNumberOfProperties() - 1; n3 >= 0; --n3) {
                blArray[n3] = false;
            }
            for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                n2 = nArray[n3];
                if (!((StyleMap)object).isComputed(n2) || !((StyleMap)object).isParentRelative(n2)) continue;
                blArray[n2] = true;
                CSSEngine.clearComputedValue((StyleMap)object, n2);
            }
            n3 = this.fontSizeIndex == -1 ? 0 : blArray[this.fontSizeIndex];
            n2 = this.lineHeightIndex == -1 ? 0 : blArray[this.lineHeightIndex];
            boolean bl = this.colorIndex == -1 ? false : blArray[this.colorIndex];
            int n4 = 0;
            for (n = this.getNumberOfProperties() - 1; n >= 0; --n) {
                if (!blArray[n]) {
                    if (!((StyleMap)object).isComputed(n)) continue;
                    if (n3 != 0 && ((StyleMap)object).isFontSizeRelative(n)) {
                        blArray[n] = true;
                        ++n4;
                        CSSEngine.clearComputedValue((StyleMap)object, n);
                    }
                    if (n2 != 0 && ((StyleMap)object).isLineHeightRelative(n)) {
                        blArray[n] = true;
                        ++n4;
                        CSSEngine.clearComputedValue((StyleMap)object, n);
                    }
                    if (!bl || !((StyleMap)object).isColorRelative(n)) continue;
                    blArray[n] = true;
                    ++n4;
                    CSSEngine.clearComputedValue((StyleMap)object, n);
                    continue;
                }
                ++n4;
            }
            if (n4 > 0) {
                nArray = new int[n4];
                n4 = 0;
                for (n = this.getNumberOfProperties() - 1; n >= 0; --n) {
                    if (!blArray[n]) continue;
                    nArray[n4++] = n;
                }
                this.firePropertiesChangedEvent((Element)node2, nArray);
            } else {
                nArray = null;
            }
        }
        if (nArray != null) {
            node2 = CSSEngine.getImportedChild(node);
            if (node2 != null) {
                this.propagateChanges(node2, nArray);
            }
            for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                this.propagateChanges((Node)object, nArray);
            }
        }
    }

    protected void nonCSSPresentationalHintUpdated(CSSStylableElement cSSStylableElement, StyleMap styleMap, String string, MutationEvent mutationEvent) {
        int n;
        Object object;
        int n2 = this.getPropertyIndex(string);
        if (styleMap.isImportant(n2)) {
            return;
        }
        switch (styleMap.getOrigin(n2)) {
            case -32768: 
            case 24576: {
                return;
            }
        }
        boolean bl = styleMap.isComputed(n2);
        switch (mutationEvent.getAttrChange()) {
            case 1: 
            case 2: {
                this.element = cSSStylableElement;
                try {
                    object = this.parser.parsePropertyValue(mutationEvent.getNewValue());
                    ValueManager valueManager = this.valueManagers[n2];
                    Value value = valueManager.createValue((LexicalUnit)object, this);
                    styleMap.putMask(n2, (short)0);
                    styleMap.putValue(n2, value);
                    styleMap.putOrigin(n2, (short)16384);
                }
                catch (Exception exception) {
                    String string2 = exception.getMessage();
                    String string3 = Messages.formatMessage("property.syntax.error.at", new Object[]{this.documentURI.toString(), string, mutationEvent.getNewValue(), string2 == null ? "" : string2});
                    throw new DOMException(12, string3);
                }
                this.element = null;
                this.cssBaseURI = null;
                break;
            }
            case 3: {
                cSSStylableElement.setComputedStyleMap(null, null);
                this.firePropertiesChangedEvent(cSSStylableElement, this.ALL_PROPERTIES);
                Node node = CSSEngine.getImportedChild(cSSStylableElement);
                if (node != null) {
                    this.propagateChanges(node, this.ALL_PROPERTIES);
                }
                for (Node node2 = cSSStylableElement.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.propagateChanges(node2, this.ALL_PROPERTIES);
                }
                return;
            }
        }
        if (!bl) {
            return;
        }
        object = this.styleDeclarationUpdateHandler.updatedProperties;
        for (n = this.getNumberOfProperties() - 1; n >= 0; --n) {
            object[n] = false;
        }
        object[n2] = true;
        n = n2 == this.fontSizeIndex ? 1 : 0;
        boolean bl2 = n2 == this.lineHeightIndex;
        boolean bl3 = n2 == this.colorIndex;
        int n3 = 0;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            if (!object[i]) {
                if (!styleMap.isComputed(i)) continue;
                if (n != 0 && styleMap.isFontSizeRelative(i)) {
                    object[i] = true;
                    ++n3;
                    CSSEngine.clearComputedValue(styleMap, i);
                }
                if (bl2 && styleMap.isLineHeightRelative(i)) {
                    object[i] = true;
                    ++n3;
                    CSSEngine.clearComputedValue(styleMap, i);
                }
                if (!bl3 || !styleMap.isColorRelative(i)) continue;
                object[i] = true;
                ++n3;
                CSSEngine.clearComputedValue(styleMap, i);
                continue;
            }
            ++n3;
        }
        int[] nArray = new int[n3];
        n3 = 0;
        for (int i = this.getNumberOfProperties() - 1; i >= 0; --i) {
            if (!object[i]) continue;
            nArray[n3++] = i;
        }
        this.firePropertiesChangedEvent(cSSStylableElement, nArray);
        Node node = CSSEngine.getImportedChild(cSSStylableElement);
        if (node != null) {
            this.propagateChanges(node, nArray);
        }
        for (Node node3 = cSSStylableElement.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            this.propagateChanges(node3, nArray);
        }
    }

    protected class DOMAttrModifiedListener
    implements EventListener {
        protected DOMAttrModifiedListener() {
        }

        public void handleEvent(Event event) {
            String string;
            EventTarget eventTarget = event.getTarget();
            if (!(eventTarget instanceof CSSStylableElement)) {
                return;
            }
            CSSStylableElement cSSStylableElement = (CSSStylableElement)((Object)eventTarget);
            StyleMap styleMap = cSSStylableElement.getComputedStyleMap(null);
            if (styleMap == null) {
                return;
            }
            MutationEvent mutationEvent = (MutationEvent)event;
            Node node = mutationEvent.getRelatedNode();
            String string2 = node.getNamespaceURI();
            if (string2 == null && CSSEngine.this.styleNamespaceURI == null || string2 != null && string2.equals(CSSEngine.this.styleNamespaceURI)) {
                String string3 = string = string2 == null ? node.getNodeName() : node.getLocalName();
                if (string.equals(CSSEngine.this.styleLocalName)) {
                    CSSEngine.this.inlineStyleAttributeUpdated(cSSStylableElement, styleMap, mutationEvent);
                    return;
                }
            }
            String string4 = string = string2 == null ? node.getNodeName() : node.getLocalName();
            if (CSSEngine.this.nonCSSPresentationalHints != null && (string2 == null && CSSEngine.this.nonCSSPresentationalHintsNamespaceURI == null || string2 != null && string2.equals(CSSEngine.this.nonCSSPresentationalHintsNamespaceURI)) && CSSEngine.this.nonCSSPresentationalHints.contains(string)) {
                CSSEngine.this.nonCSSPresentationalHintUpdated(cSSStylableElement, styleMap, string, mutationEvent);
                return;
            }
            if (CSSEngine.this.selectorAttributes != null && CSSEngine.this.selectorAttributes.contains(string)) {
                cSSStylableElement.setComputedStyleMap(null, null);
                CSSEngine.this.firePropertiesChangedEvent(cSSStylableElement, CSSEngine.this.ALL_PROPERTIES);
                Node node2 = CSSEngine.getImportedChild(cSSStylableElement);
                if (node2 != null) {
                    CSSEngine.this.propagateChanges(node2, CSSEngine.this.ALL_PROPERTIES);
                }
                for (Node node3 = cSSStylableElement.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    CSSEngine.this.propagateChanges(node3, CSSEngine.this.ALL_PROPERTIES);
                }
            }
        }
    }

    protected class DOMCharacterDataModifiedListener
    implements EventListener {
        protected DOMCharacterDataModifiedListener() {
        }

        public void handleEvent(Event event) {
            Node node = (Node)((Object)event.getTarget());
            if (node.getParentNode() instanceof CSSStyleSheetNode) {
                CSSEngine.this.styleSheetNodes = null;
                CSSEngine.this.invalidateTreeProperties(CSSEngine.this.document.getDocumentElement());
            }
        }
    }

    protected class DOMSubtreeModifiedListener
    implements EventListener {
        protected DOMSubtreeModifiedListener() {
        }

        public void handleEvent(Event event) {
            if (CSSEngine.this.styleSheetRemoved) {
                CSSEngine.this.styleSheetRemoved = false;
                CSSEngine.this.styleSheetNodes = null;
                CSSEngine.this.invalidateTreeProperties(CSSEngine.this.document.getDocumentElement());
            } else if (CSSEngine.this.removedStylableElementSibling != null) {
                for (Node node = CSSEngine.this.removedStylableElementSibling; node != null; node = node.getNextSibling()) {
                    CSSEngine.this.invalidateProperties(node);
                }
                CSSEngine.this.removedStylableElementSibling = null;
            }
        }
    }

    protected class DOMNodeRemovedListener
    implements EventListener {
        protected DOMNodeRemovedListener() {
        }

        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (eventTarget instanceof CSSStyleSheetNode) {
                CSSEngine.this.styleSheetRemoved = true;
            } else if (eventTarget instanceof CSSStylableElement) {
                CSSEngine.this.removedStylableElementSibling = ((Node)((Object)eventTarget)).getNextSibling();
            }
            CSSEngine.this.disposeStyleMaps((Node)((Object)eventTarget));
        }
    }

    protected class DOMNodeInsertedListener
    implements EventListener {
        protected DOMNodeInsertedListener() {
        }

        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (eventTarget instanceof CSSStyleSheetNode) {
                CSSEngine.this.styleSheetNodes = null;
                CSSEngine.this.invalidateTreeProperties(CSSEngine.this.document.getDocumentElement());
                return;
            }
            if (eventTarget instanceof CSSStylableElement) {
                for (Node node = ((Node)((Object)event.getTarget())).getNextSibling(); node != null; node = node.getNextSibling()) {
                    CSSEngine.this.invalidateProperties(node);
                }
            }
        }
    }

    protected class StyleDeclarationUpdateHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;
        public boolean[] updatedProperties;

        protected StyleDeclarationUpdateHandler() {
            this.updatedProperties = new boolean[CSSEngine.this.getNumberOfProperties()];
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n == -1) {
                n = CSSEngine.this.getShorthandIndex(string);
                if (n == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
            } else {
                if (this.styleMap.isImportant(n)) {
                    return;
                }
                if (this.styleMap.isComputed(n)) {
                    this.updatedProperties[n] = true;
                }
                Value value = CSSEngine.this.valueManagers[n].createValue(lexicalUnit, CSSEngine.this);
                this.styleMap.putMask(n, (short)0);
                this.styleMap.putValue(n, value);
                this.styleMap.putOrigin(n, (short)Short.MIN_VALUE);
            }
        }
    }

    protected static class DocumentAdapter
    implements DocumentHandler {
        protected DocumentAdapter() {
        }

        public void startDocument(InputSource inputSource) throws CSSException {
            throw new InternalError();
        }

        public void endDocument(InputSource inputSource) throws CSSException {
            throw new InternalError();
        }

        public void comment(String string) throws CSSException {
        }

        public void ignorableAtRule(String string) throws CSSException {
            throw new InternalError();
        }

        public void namespaceDeclaration(String string, String string2) throws CSSException {
            throw new InternalError();
        }

        public void importStyle(String string, SACMediaList sACMediaList, String string2) throws CSSException {
            throw new InternalError();
        }

        public void startMedia(SACMediaList sACMediaList) throws CSSException {
            throw new InternalError();
        }

        public void endMedia(SACMediaList sACMediaList) throws CSSException {
            throw new InternalError();
        }

        public void startPage(String string, String string2) throws CSSException {
            throw new InternalError();
        }

        public void endPage(String string, String string2) throws CSSException {
            throw new InternalError();
        }

        public void startFontFace() throws CSSException {
            throw new InternalError();
        }

        public void endFontFace() throws CSSException {
            throw new InternalError();
        }

        public void startSelector(SelectorList selectorList) throws CSSException {
            throw new InternalError();
        }

        public void endSelector(SelectorList selectorList) throws CSSException {
            throw new InternalError();
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            throw new InternalError();
        }
    }

    protected class StyleSheetDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleSheet styleSheet;
        protected StyleRule styleRule;
        protected StyleDeclaration styleDeclaration;

        protected StyleSheetDocumentHandler() {
        }

        public void startDocument(InputSource inputSource) throws CSSException {
        }

        public void endDocument(InputSource inputSource) throws CSSException {
        }

        public void ignorableAtRule(String string) throws CSSException {
        }

        public void importStyle(String string, SACMediaList sACMediaList, String string2) throws CSSException {
            ImportRule importRule = new ImportRule();
            importRule.setMediaList(sACMediaList);
            importRule.setParent(this.styleSheet);
            try {
                importRule.setURI(new URL(CSSEngine.this.getCSSBaseURI(), string));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.styleSheet.append(importRule);
        }

        public void startMedia(SACMediaList sACMediaList) throws CSSException {
            MediaRule mediaRule = new MediaRule();
            mediaRule.setMediaList(sACMediaList);
            mediaRule.setParent(this.styleSheet);
            this.styleSheet.append(mediaRule);
            this.styleSheet = mediaRule;
        }

        public void endMedia(SACMediaList sACMediaList) throws CSSException {
            this.styleSheet = this.styleSheet.getParent();
        }

        public void startPage(String string, String string2) throws CSSException {
        }

        public void endPage(String string, String string2) throws CSSException {
        }

        public void startFontFace() throws CSSException {
            this.styleDeclaration = new StyleDeclaration();
        }

        public void endFontFace() throws CSSException {
            this.styleDeclaration = null;
        }

        public void startSelector(SelectorList selectorList) throws CSSException {
            this.styleRule = new StyleRule();
            this.styleRule.setSelectorList(selectorList);
            this.styleDeclaration = new StyleDeclaration();
            this.styleRule.setStyleDeclaration(this.styleDeclaration);
            this.styleSheet.append(this.styleRule);
        }

        public void endSelector(SelectorList selectorList) throws CSSException {
            this.styleRule = null;
            this.styleDeclaration = null;
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n == -1) {
                n = CSSEngine.this.getShorthandIndex(string);
                if (n == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
            } else {
                Value value = CSSEngine.this.valueManagers[n].createValue(lexicalUnit, CSSEngine.this);
                this.styleDeclaration.append(value, n, bl);
            }
        }
    }

    protected class StyleDeclarationBuilder
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleDeclaration styleDeclaration;

        protected StyleDeclarationBuilder() {
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n == -1) {
                n = CSSEngine.this.getShorthandIndex(string);
                if (n == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
            } else {
                Value value = CSSEngine.this.valueManagers[n].createValue(lexicalUnit, CSSEngine.this);
                this.styleDeclaration.append(value, n, bl);
            }
        }
    }

    protected class StyleDeclarationDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;

        protected StyleDeclarationDocumentHandler() {
        }

        public void property(String string, LexicalUnit lexicalUnit, boolean bl) throws CSSException {
            int n = CSSEngine.this.getPropertyIndex(string);
            if (n == -1) {
                n = CSSEngine.this.getShorthandIndex(string);
                if (n == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[n].setValues(CSSEngine.this, this, lexicalUnit, bl);
            } else {
                Value value = CSSEngine.this.valueManagers[n].createValue(lexicalUnit, CSSEngine.this);
                CSSEngine.this.putAuthorProperty(this.styleMap, n, value, bl, (short)Short.MIN_VALUE);
            }
        }
    }
}

