/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.interfaces;

import org.apache.avalon.framework.configuration.ConfigurationException;

public class InstrumentSampleUtils {
    public static int resolveInstrumentSampleType(String type) throws ConfigurationException {
        if (type.equalsIgnoreCase("max") || type.equalsIgnoreCase("maximum")) {
            return 103;
        }
        if (type.equalsIgnoreCase("min") || type.equalsIgnoreCase("minimum")) {
            return 102;
        }
        if (type.equalsIgnoreCase("mean")) {
            return 104;
        }
        if (type.equalsIgnoreCase("ctr") || type.equalsIgnoreCase("counter")) {
            return 101;
        }
        throw new ConfigurationException("'" + type + "' is not a valid sample type.");
    }

    public static String getInstrumentSampleTypeName(int type) {
        switch (type) {
            case 103: {
                return "maximum";
            }
            case 102: {
                return "minimum";
            }
            case 104: {
                return "mean";
            }
            case 101: {
                return "counter";
            }
        }
        return "unknown-" + type;
    }

    public static String generateInstrumentSampleName(int sampleType, long sampleInterval, int sampleSize) {
        return InstrumentSampleUtils.getInstrumentSampleTypeName(sampleType) + "_" + sampleInterval + "_" + sampleSize;
    }

    public static String generateFullInstrumentSampleName(String instrumentName, int sampleType, long sampleInterval, int sampleSize) {
        return instrumentName + "." + InstrumentSampleUtils.generateInstrumentSampleName(sampleType, sampleInterval, sampleSize);
    }
}

