@echo off

:: Configuration variables
::
:: SDX_HOME
::   Folder that points to the root of the SDX distribution
::
:: SDX_LIB
::   Folder containing all the library files needed by the SDX CLI
::
:: JAVA_HOME
::   Home of Java installation.
::
:: JAVA_OPTIONS
::   Extra options to pass to the JVM
::
:: JAVA_DEBUG_PORT
::   The location where the JVM debug server should listen to
::
:: JETTY_PORT
::   Override the default port for Jetty
:: 
:: JETTY_ADMIN_PORT
::   The port where the jetty web administration should bind
::
:: JETTY_WEBAPP
::   The directory where the webapp that jetty has to execute is located
::

:: ----- Verify and Set Required Environment Variables -------------------------

if not "%JAVA_HOME%" == "" goto gotJavaHome
echo You must set JAVA_HOME to point at your Java Development Kit installation
goto end
:gotJavaHome

:: ----- Check System Properties -----------------------------------------------

if not "%EXEC%" == "" goto gotExec
if not "%OS%" == "Windows_NT" goto noExecNT
set EXEC=start "SDX" /D. /MAX
goto gotExec
:noExecNT
set EXEC=
:gotExec

if not "%SDX_HOME%" == "" goto gotHome
set SDX_HOME=.
:gotHome

if not "%SDX_LIB%" == "" goto gotLib
set SDX_LIB=%SDX_HOME%\build\webapp\WEB-INF\lib
:gotLib

if not "%JETTY_PORT%" == "" goto gotJettyPort
set JETTY_PORT=8888
:gotJettyPort

if not "%JETTY_ADMIN_PORT%" == "" goto gotJettyAdminPort
set JETTY_ADMIN_PORT=8889
:gotJettyAdminPort

if not "%JETTY_WEBAPP%" == "" goto gotWebapp
set DEMO_WEBAPP=..\webapp
if not exist %DEMO_WEBAPP% goto standardWebapp
set JETTY_WEBAPP=%DEMO_WEBAPP%
goto gotWebapp
:standardWebapp
set JETTY_WEBAPP=%SDX_HOME%\build\webapp
:gotWebapp
echo sdx.bat: using %JETTY_WEBAPP% as the webapp directory

if not "%JAVA_DEBUG_PORT%" == "" goto gotDebugPort
set JAVA_DEBUG_PORT=8000
:gotDebugPort

:: ----- Set Up The Classpath --------------------------------------------------

set CP=%SDX_HOME%\tools\loader

:: ----- Check action ----------------------------------------------------------

if ""%1"" == ""cli"" goto doCli
if ""%1"" == ""servlet"" goto doServlet
if ""%1"" == ""servlet-admin"" goto doAdmin
if ""%1"" == ""servlet-debug"" goto doDebug
IF ""%1"" == ""servlet-profile"" goto doProfile

echo Usage: sdx (action)
echo actions:
echo   cli             Run SDX from command line
echo   servlet         Run SDX in a servlet container
echo   servlet-admin   Run SDX in a servlet container and turn container web administration on
echo   servlet-debug   Run SDX in a servlet container and turn on remote JVM debug
echo   servlet-profile Run SDX in a servlet container and turn on JVM profiling
goto end

:: ----- Cli -------------------------------------------------------------------

:doCli
if not "%OS%" == "Windows_NT" goto noNT
shift
%JAVA_HOME%\bin\java.exe %JAVA_OPT% -classpath %CP% -Djava.endorsed.dirs=lib\endorsed -Dloader.jar.repositories=%SDX_LIB% -Dloader.main.class=org.apache.cocoon.Main Loader %*
goto end
:noNT
%JAVA_HOME%\bin\java.exe %JAVA_OPT% -classpath %CP% -Djava.endorsed.dirs=lib\endorsed -Dloader.jar.repositories=%SDX_LIB% -Dloader.main.class=org.apache.cocoon.Main Loader %2 %3 %4 %5 %6 %7 %8 %9
goto end

:: ----- Servlet ---------------------------------------------------------------

:doServlet
%EXEC% %JAVA_HOME%\bin\java.exe %JAVA_OPT% -classpath %CP% -Djava.endorsed.dirs=%SDX_HOME%\lib\endorsed -Dwebapp=%JETTY_WEBAPP% -Dorg.xml.sax.parser=org.apache.xerces.parsers.SAXParser -Djetty.port=%JETTY_PORT% -Djetty.admin.port=%JETTY_ADMIN_PORT% -Dhome=%SDX_HOME% -Dloader.jar.repositories=%SDX_HOME%\tools\jetty\lib,%SDX_HOME%\lib\endorsed -Dloader.main.class=org.mortbay.jetty.Server Loader %SDX_HOME%\tools\jetty\conf\main.xml
goto end

:: ----- Servlet with Administration Web Interface -----------------------------

:doAdmin
%EXEC% %JAVA_HOME%\bin\java.exe %JAVA_OPT% -classpath %CP% -Djava.endorsed.dirs=%SDX_HOME%\lib\endorsed -Dwebapp=%JETTY_WEBAPP% -Dorg.xml.sax.parser=org.apache.xerces.parsers.SAXParser -Djetty.port=%JETTY_PORT% -Djetty.admin.port=%JETTY_ADMIN_PORT% -Dhome=%SDX_HOME% -Dloader.jar.repositories=%SDX_HOME%\tools\jetty\lib,%SDX_HOME%\lib\endorsed -Dloader.main.class=org.mortbay.jetty.Server Loader %SDX_HOME%\tools\jetty\conf\main.xml %SDX_HOME%\tools\jetty\conf\admin.xml
goto end

:: ----- Servlet Debug ---------------------------------------------------------

:doDebug
%EXEC% %JAVA_HOME%\bin\java.exe %JAVA_OPT% -Xdebug -Xrunjdwp:transport=dt_socket,address=%JAVA_DEBUG_PORT%,server=y,suspend=n  -classpath %CP% -Djava.endorsed.dirs=%SDX_HOME%\lib\endorsed -Dwebapp=%JETTY_WEBAPP% -Dhome=%SDX_HOME% -Dorg.xml.sax.parser=org.apache.xerces.parsers.SAXParser -Djetty.port=%JETTY_PORT% -Djetty.admin.port=%JETTY_ADMIN_PORT% -Dloader.jar.repositories=%SDX_HOME%\tools\jetty\lib,%SDX_HOME%\lib\endorsed -Dloader.main.class=org.mortbay.jetty.Server Loader %SDX_HOME%\tools\jetty\conf\main.xml
goto end

:: ----- Servlet Profile ---------------------------------------------------------

:doProfile
%EXEC% %JAVA_HOME%\bin\java.exe %JAVA_OPT% -Xrunhprof:heap=all,cpu=samples,thread=y,depth=3 -classpath %CP% -Djava.endorsed.dirs=%SDX_HOME%\lib\endorsed -Dwebapp=%JETTY_WEBAPP% -Dhome=%SDX_HOME% -Dorg.xml.sax.parser=org.apache.xerces.parsers.SAXParser -Djetty.port=%JETTY_PORT% -Djetty.admin.port=%JETTY_ADMIN_PORT% -Dloader.jar.repositories=%SDX_HOME%\tools\jetty\lib,%SDX_HOME%\lib\endorsed -Dloader.main.class=org.mortbay.jetty.Server Loader %SDX_HOME%\tools\jetty\conf\main.xml

:: ----- End -------------------------------------------------------------------

:end
set CP=


