/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/

package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.component.ComponentException;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

/**The same as JDBCRespository, but the method for the table creation query is overridden.
 *
 */
public class HSQLRepository extends JDBCRepository {

    /** Returns an SQL query that could create the table.
     * <p>
     * This query should not have any parameter.
     * @return The query.
     */
    protected String getTableCreationQuery() {
        //changed dataType of FIELD_DATA_TRANSFORMED from "BINARY NOT NULL" TO only "BINARY"
        return "CREATE CACHED TABLE " + getTableName() + " ( " + FIELD_ID + " VARCHAR(255) NOT NULL, " + FIELD_DATA + " BINARY, PRIMARY KEY (" + FIELD_ID + "))";
    }

    /** Initializes the repository.
     *
     * If there are no tables in the database,
     * we create the necessary table
     *
     * @throws SDXException  */
    public void init() throws SDXException {

        /** First try to access the database and see if the tables exist. */
        Connection conn = null;
        ResultSet rs = null;

        try {
            DataSourceComponent dataSource = getDataSourceComponent();
            try {
                conn = dataSource.getConnection();
                DatabaseMetaData dbmd = conn.getMetaData();
                //TODO: FIXME when hsql bug is correctect, using .toUpperCase() here to compensate for a bug in hsql
                rs = dbmd.getTables(null, null, getTableName().toUpperCase(), null);
                if (!rs.next()) {
                    // The table doesn't exist, so we should create it.
                    createTable(conn);
                }
            } catch (SQLException e) {
                String[] args = new String[2];
                args[0] = this.getId();
                args[1] = e.getMessage();
                throw new SDXException(logger, SDXExceptionCode.ERROR_INIT_REPO, args, e);
            } finally {
                if (rs != null) {
                    try {
                        rs.close();
                    } catch (SQLException e) {
                        String[] args = new String[2];
                        args[0] = this.getId();
                        args[1] = e.getMessage();
                        throw new SDXException(logger, SDXExceptionCode.ERROR_CLOSE_RESULT_SET, args, e);
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    } catch (SQLException e) {
                        String[] args = new String[2];
                        args[0] = this.getId();
                        args[1] = e.getMessage();
                        throw new SDXException(logger, SDXExceptionCode.ERROR_CLOSE_SQL_CONNECTION, args, e);
                    }
                }
                releaseDataSourceComponent(dataSource);
            }
        } catch (ComponentException e) {
            String[] args = new String[1];
            args[0] = e.getMessage();
            //null logger passed to prevent double logging
            SDXException sdxE = new SDXException(null, SDXExceptionCode.ERROR_ACQUIRE_DATASOURCE, args, e);

            String[] args2 = new String[2];
            args2[0] = this.getId();
            args2[1] = sdxE.getMessage();
            throw new SDXException(logger, SDXExceptionCode.ERROR_INIT_REPO, args2, sdxE);
        }
    }

    protected String getTableName() {
        return handleUnsupportedTokens(super.getTableName());
    }
}
