/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.utils;

import fr.gouv.culture.sdx.framework.FrameworkImpl;


/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Dec 10, 2002
 * Time: 2:00:08 PM
 * To change this template use Options | File Templates.
 */
abstract public class SdxObjectImpl implements SdxObject {
    /** Avalon logger to write information. */
    protected org.apache.avalon.framework.logger.Logger logger;
    /**The default encoding to be used when working with strings*/
    protected String encoding = FrameworkImpl.DEFAULT_ENCODING;


    /**
     * Sets the logger for this object.
     *
     * <p>
     * Setting the logger ensures proper logging of potential
     * errors. If not set, this class won't be able to log any
     * information. But it will still work.
     */
    public void enableLogging(org.apache.avalon.framework.logger.Logger logger) {
        this.logger = logger;
    }

    protected void getChildLogger(String id) {
        if (this.logger != null && Utilities.checkString(id))
            this.logger = this.logger.getChildLogger(id);
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

}
