<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx">
    <!-- Cette feuille n'est proposée
que pour illustrer la possibilité d'un changement
dynamique de transformation d'indexation selon un
paramètre utilisateur (voir upload.xsp).
Pour le même effet, on aurait pu tout aussi bien se
contenter d'un paramètre d'indexation 
(voir index-html.xsl et upload.xsp) -->
    <xsl:include href="index-html.xsl"/>
    <!-- resolve links -->
    <xsl:template match="@src | @href | @action">
        <xsl:if test="not(starts-with(., 'http')) and not(starts-with(. , '#')) and not(starts-with(. , 'mailto'))">
            <xsl:value-of select="$base"/>
            <xsl:text>/</xsl:text>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="starts-with(., '/')">
                <xsl:value-of select="normalize-space(substring-after(., '/'))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="normalize-space(.)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- handle image
    [substring-before(@src, '.jpg')!='']
     -->
    <xsl:template match="img">
        <sdx:field name="image">
            <xsl:apply-templates select="@src"/>
        </sdx:field>
    </xsl:template>
    <xsl:template match="a">
        <sdx:field name="lien">
            <xsl:apply-templates select="@href"/>
        </sdx:field>
        <xsl:apply-templates/>
    </xsl:template>
</xsl:stylesheet>
