/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.environment.Environment;

public final class HandleErrorsNode
extends AbstractParentProcessingNode {
    private ProcessingNode[] children;
    private int statusCode;

    public HandleErrorsNode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setChildren(ProcessingNode[] nodes) {
        this.children = nodes;
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Processing handle-errors at " + this.getLocation());
        }
        if (this.statusCode == -1) {
            try {
                return this.invokeNodes(this.children, env, context);
            }
            catch (ProcessingException pe) {
                if (this.statusCode == -1 && pe.getMessage().indexOf("must set a generator first before you can use a transformer") != -1) {
                    throw new ProcessingException("Incomplete pipeline : 'handle-error' without a 'type' must include a generator, at " + this.getLocation() + System.getProperty("line.separator") + "Either add a generator (preferred) or a type='500' attribute (deprecated) on 'handle-errors'");
                }
                if (this.statusCode != -1 && pe.getMessage().indexOf("Generator already set") != -1) {
                    throw new ProcessingException("Error : 'handle-error' with a 'type' attribute has an implicit generator, at " + this.getLocation() + System.getProperty("line.separator") + "Please remove the 'type' attribute on 'handle-error'");
                }
                throw pe;
            }
        }
        context.getProcessingPipeline().setGenerator("<notifier>", "", Parameters.EMPTY_PARAMETERS, Parameters.EMPTY_PARAMETERS);
        return this.invokeNodes(this.children, env, context);
    }
}

