/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.Iterator;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TempRepeaterJXPathBinding
extends JXPathBindingBase {
    private final String repeaterId;
    private final String repeaterPath;
    private final String rowPath;
    private final String rowPathInsert;
    private final boolean clearOnLoad;
    private final JXPathBindingBase rowBinding;
    private final JXPathBindingBase insertRowBinding;
    private final boolean deleteIfEmpty;
    private final boolean virtualRows;

    public TempRepeaterJXPathBinding(JXPathBindingBuilderBase.CommonAttributes commonAtts, String repeaterId, String repeaterPath, String rowPath, String rowPathInsert, boolean virtualRows, boolean clearOnLoad, boolean deleteIfEmpty, JXPathBindingBase rowBinding, JXPathBindingBase insertBinding) {
        super(commonAtts);
        this.repeaterId = repeaterId;
        this.repeaterPath = repeaterPath;
        this.rowPath = rowPath;
        this.rowPathInsert = rowPathInsert;
        this.rowBinding = rowBinding;
        this.rowBinding.setParent(this);
        this.insertRowBinding = insertBinding;
        this.insertRowBinding.setParent(this);
        this.virtualRows = virtualRows;
        this.clearOnLoad = clearOnLoad;
        this.deleteIfEmpty = deleteIfEmpty;
    }

    public void doLoad(Widget frmModel, JXPathContext jctx) throws BindingException {
        Pointer repeaterPointer;
        Repeater repeater = (Repeater)this.selectWidget(frmModel, this.repeaterId);
        if (repeater == null) {
            String fullId = frmModel.getRequestParameterName();
            fullId = fullId == null || fullId.length() == 0 ? "" : fullId + ".";
            throw new RuntimeException("TempRepeaterJXPathBinding: Repeater \"" + fullId + this.repeaterId + "\" does not exist (" + frmModel.getLocation() + ")");
        }
        if (this.clearOnLoad) {
            repeater.removeRows();
        }
        if ((repeaterPointer = jctx.getPointer(this.repeaterPath)) != null) {
            JXPathContext repeaterContext = jctx.getRelativeContext(repeaterPointer);
            Iterator rowPointers = repeaterContext.iteratePointers(this.rowPath);
            int rowNum = 0;
            while (rowPointers.hasNext()) {
                Repeater.RepeaterRow thisRow = repeater.getSize() > rowNum ? repeater.getRow(rowNum) : repeater.addRow();
                ++rowNum;
                Pointer rowPointer = (Pointer)rowPointers.next();
                JXPathContext rowContext = repeaterContext.getRelativeContext(rowPointer);
                if (this.virtualRows) {
                    Node repeaterNode = (Node)repeaterPointer.getNode();
                    Element virtualNode = repeaterNode.getOwnerDocument().createElementNS(null, "virtual");
                    Node clone = ((Node)rowPointer.getNode()).cloneNode(true);
                    virtualNode.appendChild(clone);
                    rowContext = JXPathContext.newContext((JXPathContext)repeaterContext, (Object)virtualNode);
                }
                this.rowBinding.loadFormFromModel((Widget)thisRow, rowContext);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("done loading rows " + this.toString());
        }
    }

    public void doSave(Widget frmModel, JXPathContext jctx) throws BindingException {
        Repeater repeater = (Repeater)this.selectWidget(frmModel, this.repeaterId);
        if (repeater.getSize() == 0 && this.deleteIfEmpty) {
            jctx.removeAll(this.repeaterPath);
        } else {
            JXPathContext repeaterContext = jctx.getRelativeContext(jctx.createPath(this.repeaterPath));
            repeaterContext.removeAll(this.rowPath);
            if (repeater.getSize() > 0) {
                if (this.insertRowBinding != null) {
                    int i = 0;
                    while (i < repeater.getSize()) {
                        Pointer rowPointer = repeaterContext.getPointer(this.rowPathInsert);
                        JXPathContext rowContext = repeaterContext.getRelativeContext(rowPointer);
                        Node rowNode = null;
                        Element virtualNode = null;
                        if (this.virtualRows) {
                            rowNode = (Node)rowContext.getContextBean();
                            virtualNode = rowNode.getOwnerDocument().createElementNS(null, "virtual");
                            rowContext = JXPathContext.newContext((JXPathContext)repeaterContext, (Object)virtualNode);
                        }
                        this.insertRowBinding.saveFormToModel((Widget)repeater, rowContext);
                        this.rowBinding.saveFormToModel((Widget)repeater.getRow(i), rowContext);
                        if (this.virtualRows) {
                            NodeList list = virtualNode.getChildNodes();
                            int count = list.getLength();
                            int j = 0;
                            while (j < count) {
                                rowNode.appendChild(list.item(0));
                                ++j;
                            }
                        }
                        this.getLogger().debug("bound new row");
                        ++i;
                    }
                } else {
                    this.getLogger().warn("TempRepeaterBinding has detected rows to insert, but misses the <on-insert-row> binding to do it.");
                }
            }
        }
    }

    public String toString() {
        return "TempRepeaterJXPathBinding [widget=" + this.repeaterId + ", xpath=" + this.repeaterPath + "]";
    }

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        if (this.insertRowBinding != null) {
            this.insertRowBinding.enableLogging(logger);
        }
        this.rowBinding.enableLogging(logger);
    }
}

