/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.validationruleimpl;

import org.apache.cocoon.forms.datatype.ValidationRule;
import org.apache.cocoon.forms.datatype.validationruleimpl.AbstractValidationRuleBuilder;
import org.apache.cocoon.forms.datatype.validationruleimpl.RangeValidationRule;
import org.apache.cocoon.forms.util.DomHelper;
import org.outerj.expression.Expression;
import org.w3c.dom.Element;

public class RangeValidationRuleBuilder
extends AbstractValidationRuleBuilder {
    public ValidationRule build(Element validationRuleElement) throws Exception {
        RangeValidationRule rule = new RangeValidationRule();
        String minExprString = validationRuleElement.getAttribute("min");
        String maxExprString = validationRuleElement.getAttribute("max");
        if (minExprString.length() > 0 && maxExprString.length() > 0) {
            Expression expression = this.parseExpression(minExprString, validationRuleElement, "min");
            rule.setMinExpr(expression);
            expression = this.parseExpression(maxExprString, validationRuleElement, "max");
            rule.setMaxExpr(expression);
        } else if (minExprString.length() > 0) {
            Expression expression = this.parseExpression(minExprString, validationRuleElement, "min");
            rule.setMinExpr(expression);
        } else if (maxExprString.length() > 0) {
            Expression expression = this.parseExpression(maxExprString, validationRuleElement, "max");
            rule.setMaxExpr(expression);
        } else {
            throw new Exception("range validation rule requires a min and/or max attribute at " + DomHelper.getLocation(validationRuleElement));
        }
        this.buildFailMessage(validationRuleElement, rule);
        return rule;
    }
}

