/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.caching;

import EDU.oswego.cs.dl.util.concurrent.FIFOReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.cocoon.caching.ExtendedCachedResponse;
import org.apache.cocoon.caching.IdentifierCacheKey;
import org.apache.cocoon.caching.impl.CacheImpl;
import org.apache.cocoon.util.IOUtils;
import org.apache.cocoon.util.NetUtils;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.FileTimeStampValidity;

public class SimpleCache
extends CacheImpl {
    protected String baseDirectory;
    protected Map locks = new HashMap(50);

    public void parameterize(Parameters parameters) throws ParameterException {
        super.parameterize(parameters);
        this.baseDirectory = parameters.getParameter("baseDirectory");
        File dir = new File(this.baseDirectory);
        dir.mkdirs();
    }

    protected File getFile(Serializable key) {
        String filename = key instanceof String ? NetUtils.absolutize((String)this.baseDirectory, (String)((String)((Object)key))) : (key instanceof IdentifierCacheKey ? NetUtils.absolutize((String)this.baseDirectory, (String)((IdentifierCacheKey)key).getKey()) : NetUtils.absolutize((String)this.baseDirectory, (String)key.toString()));
        return new File(filename);
    }

    public void clear() {
        super.clear();
        File dir = new File(this.baseDirectory);
        dir.delete();
        dir = new File(this.baseDirectory);
        dir.mkdir();
    }

    public boolean containsKey(Serializable key) {
        File file;
        boolean result = super.containsKey(key);
        if (!result && !(result = (file = this.getFile(key)).exists())) {
            file = new File(file.getAbsolutePath() + ".cxml");
            result = file.exists();
        }
        return result;
    }

    public CachedResponse get(Serializable key) {
        CachedResponse response = super.get(key);
        if (response == null || response.getValidityObjects()[0].isValid() != 1) {
            if (response != null) {
                this.remove(key);
            }
            File file = this.getFile(key);
            byte[] content = null;
            byte[] altContent = null;
            if (file.exists()) {
                content = this.get(file);
            }
            if ((file = new File(file.getAbsolutePath() + ".cxml")).exists()) {
                altContent = this.get(file);
            }
            if (content != null || altContent != null) {
                FileTimeStampValidity val = new FileTimeStampValidity(file);
                response = new ExtendedCachedResponse((SourceValidity)val, content);
                ((ExtendedCachedResponse)response).setAlternativeResponse(altContent);
            }
        }
        return response;
    }

    public void remove(Serializable key) {
        super.remove(key);
        File file = this.getFile(key);
        if (file.exists()) {
            file.delete();
        }
    }

    public void store(Serializable key, CachedResponse response) throws ProcessingException {
        super.store(key, response);
        byte[] content = response.getResponse();
        if (content != null) {
            this.store(this.getFile(key), content);
        }
        if (response instanceof ExtendedCachedResponse && (content = ((ExtendedCachedResponse)response).getAlternativeResponse()) != null) {
            File file = this.getFile(key);
            file = new File(file.getAbsolutePath() + ".cxml");
            this.store(file, content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void store(File file, byte[] content) {
        ReadWriteLock lock;
        Map map = this.locks;
        synchronized (map) {
            lock = (ReadWriteLock)this.locks.get(file.getAbsolutePath());
            if (lock == null) {
                lock = new FIFOReadWriteLock();
                this.locks.put(file.getAbsolutePath(), lock);
            }
        }
        Sync sync = lock.writeLock();
        try {
            sync.acquire();
            try {
                try {
                    FileOutputStream os = new FileOutputStream(file);
                    ((OutputStream)os).write(content);
                    os.flush();
                    ((OutputStream)os).close();
                }
                catch (IOException io) {
                    this.getLogger().warn("Exception during caching of content to " + file, (Throwable)io);
                    Object var8_10 = null;
                    sync.release();
                    return;
                }
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                sync.release();
                throw throwable;
            }
            sync.release();
            return;
        }
        catch (InterruptedException ie) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] get(File file) {
        ReadWriteLock lock;
        Map map = this.locks;
        synchronized (map) {
            lock = (ReadWriteLock)this.locks.get(file.getAbsolutePath());
            if (lock == null) {
                lock = new FIFOReadWriteLock();
                this.locks.put(file.getAbsolutePath(), lock);
            }
        }
        Sync sync = lock.readLock();
        try {
            byte[] byArray;
            sync.acquire();
            try {
                try {
                    String content = IOUtils.deserializeString((File)file);
                    byArray = content.getBytes();
                    Object var8_10 = null;
                }
                catch (IOException io) {
                    this.getLogger().warn("Exception during reading of content from " + file, (Throwable)io);
                    byte[] byArray2 = null;
                    Object var8_11 = null;
                    sync.release();
                    return byArray2;
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                sync.release();
                throw throwable;
            }
            sync.release();
            return byArray;
        }
        catch (InterruptedException ie) {
            return null;
        }
    }
}

