/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;

public abstract class AbstractSource
implements Source {
    private boolean m_gotInfos;
    private long m_lastModificationDate;
    private long m_contentLength;
    private String m_systemId;
    private String m_scheme;

    protected void getInfos() {
        this.m_contentLength = -1L;
        this.m_lastModificationDate = 0L;
    }

    protected void checkInfos() {
        if (!this.m_gotInfos) {
            this.getInfos();
            this.m_gotInfos = true;
        }
    }

    public InputStream getInputStream() throws IOException, SourceException {
        return null;
    }

    public String getURI() {
        return this.m_systemId;
    }

    public String getScheme() {
        return this.m_scheme;
    }

    public SourceValidity getValidity() {
        return null;
    }

    public void refresh() {
        this.m_gotInfos = false;
    }

    public String getMimeType() {
        return null;
    }

    public long getContentLength() {
        this.checkInfos();
        return this.m_contentLength;
    }

    public long getLastModified() {
        this.checkInfos();
        return this.m_lastModificationDate;
    }

    protected void setContentLength(long contentLength) {
        this.m_contentLength = contentLength;
    }

    protected void setLastModified(long lastModificationDate) {
        this.m_lastModificationDate = lastModificationDate;
    }

    protected void setScheme(String scheme) {
        this.m_scheme = scheme;
    }

    protected void setSystemId(String systemId) {
        this.m_systemId = systemId;
    }

    public abstract boolean exists();
}

