/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral.javagroups;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.lateral.LateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.LateralCacheInfo;
import org.apache.jcs.auxiliary.lateral.LateralElementDescriptor;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheObserver;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheService;
import org.apache.jcs.auxiliary.lateral.javagroups.LateralJGSender;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheListener;

public class LateralJGService
implements ILateralCacheService,
ILateralCacheObserver {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$lateral$javagroups$LateralJGService == null ? (class$org$apache$jcs$auxiliary$lateral$javagroups$LateralJGService = LateralJGService.class$("org.apache.jcs.auxiliary.lateral.javagroups.LateralJGService")) : class$org$apache$jcs$auxiliary$lateral$javagroups$LateralJGService));
    private ILateralCacheAttributes ilca;
    private LateralJGSender sender;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$lateral$javagroups$LateralJGService;

    public LateralJGService(ILateralCacheAttributes lca) throws IOException {
        this.ilca = lca;
        try {
            log.debug((Object)"creating sender");
            this.sender = new LateralJGSender(lca);
            log.debug((Object)"created sender");
        }
        catch (IOException e) {
            log.error((Object)("Could not create sender to [" + lca.getJGChannelProperties() + "] -- " + e.getMessage()));
            throw e;
        }
    }

    public void update(ICacheElement item) throws IOException {
        this.update(item, LateralCacheInfo.listenerId);
    }

    public void update(ICacheElement item, byte requesterId) throws IOException {
        LateralElementDescriptor led = new LateralElementDescriptor(item);
        led.requesterId = requesterId;
        led.command = 1;
        this.sender.send(led);
    }

    public void remove(String cacheName, Serializable key) throws IOException {
        this.remove(cacheName, key, LateralCacheInfo.listenerId);
    }

    public void remove(String cacheName, Serializable key, byte requesterId) throws IOException {
        CacheElement ce = new CacheElement(cacheName, key, null);
        LateralElementDescriptor led = new LateralElementDescriptor(ce);
        led.requesterId = requesterId;
        led.command = 2;
        this.sender.send(led);
    }

    public void release() throws IOException {
    }

    public void dispose(String cache) throws IOException {
        this.sender.dispose(cache);
    }

    public ICacheElement get(String cacheName, Serializable key) throws IOException {
        CacheElement ce = new CacheElement(cacheName, key, null);
        LateralElementDescriptor led = new LateralElementDescriptor(ce);
        led.command = 5;
        return this.sender.sendAndReceive(led);
    }

    public void removeAll(String cacheName) throws IOException {
        this.removeAll(cacheName, LateralCacheInfo.listenerId);
    }

    public void removeAll(String cacheName, byte requesterId) throws IOException {
        CacheElement ce = new CacheElement(cacheName, (Serializable)((Object)"ALL"), null);
        LateralElementDescriptor led = new LateralElementDescriptor(ce);
        led.requesterId = requesterId;
        led.command = 3;
        this.sender.send(led);
    }

    public Set getGroupKeys(String cacheName, String group) {
        throw new UnsupportedOperationException("Groups not implemented.");
    }

    public static void main(String[] args) {
        try {
            LateralJGSender sender = new LateralJGSender(new LateralCacheAttributes());
            boolean notDone = true;
            String message = null;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            while (notDone) {
                System.out.println("enter mesage:");
                message = br.readLine();
                CacheElement ce = new CacheElement("test", (Serializable)((Object)"test"), (Serializable)((Object)message));
                LateralElementDescriptor led = new LateralElementDescriptor(ce);
                sender.send(led);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void addCacheListener(String cacheName, ICacheListener obj) throws IOException {
    }

    public void addCacheListener(ICacheListener obj) throws IOException {
    }

    public void removeCacheListener(String cacheName, ICacheListener obj) throws IOException {
    }

    public void removeCacheListener(ICacheListener obj) throws IOException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

