/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup;

import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.language.markup.Logicsheet;
import org.apache.cocoon.components.language.markup.MarkupCodeGenerator;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.util.TraxErrorHandler;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.excalibur.source.Source;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class LogicsheetCodeGenerator
extends AbstractLogEnabled
implements MarkupCodeGenerator {
    private ContentHandler serializerContentHandler;
    private AbstractXMLPipe end;
    private TransformerHandler currentParent;
    private StringWriter writer;
    private SAXTransformerFactory tfactory = null;

    public void initialize() {
        Properties format = new Properties();
        try {
            TransformerHandler handler = this.getTransformerFactory().newTransformerHandler();
            format.put("method", "text");
            format.put("indent", "yes");
            handler.getTransformer().setOutputProperties(format);
            this.writer = new StringWriter();
            handler.setResult(new StreamResult(this.writer));
            this.serializerContentHandler = handler;
        }
        catch (TransformerConfigurationException tce) {
            this.getLogger().error("LogicsheetCodeGenerator: unable to get TransformerHandler", (Throwable)tce);
        }
    }

    private SAXTransformerFactory getTransformerFactory() {
        if (this.tfactory == null) {
            this.tfactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            this.tfactory.setErrorListener((ErrorListener)new TraxErrorHandler(this.getLogger()));
        }
        return this.tfactory;
    }

    public void addLogicsheet(Logicsheet logicsheet) throws ProcessingException {
        if (this.currentParent == null) {
            this.currentParent = logicsheet.getTransformerHandler();
            this.end.setContentHandler((ContentHandler)this.currentParent);
            this.currentParent.setResult(new SAXResult(this.serializerContentHandler));
        } else {
            TransformerHandler newParent = logicsheet.getTransformerHandler();
            this.currentParent.setResult(new SAXResult(newParent));
            this.currentParent = newParent;
            this.currentParent.setResult(new SAXResult(this.serializerContentHandler));
        }
    }

    public String generateCode(Source source, AbstractXMLPipe filter) throws Exception {
        try {
            this.end = filter;
            SourceUtil.toSAX((Source)source, (ContentHandler)filter);
            return this.writer.toString();
        }
        catch (SAXException e) {
            if (e.getException() != null) {
                this.getLogger().debug("Got SAXException; Rethrowing cause exception", (Throwable)e);
                throw e.getException();
            }
            this.getLogger().debug("Got SAXException", (Throwable)e);
            throw e;
        }
    }
}

