/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.SdxObject;

import java.sql.Connection;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Mar 3, 2003
 * Time: 2:11:37 PM
 * To change this template use Options | File Templates.
 */
public interface DatabaseConnection extends SdxObject {
    String CLASS_NAME_SUFFIX = "DatabaseConnection";

    /**
     * Commit all operation done with this active connection.
     */
    public void commit() throws SDXException;

    /**
     * Undo all operations done with this connection.
     */
    public void rollback() throws SDXException;

    /**
     * Sets this connection in autocommit mode or not.
     *
     * @param   autoCommit      true enables auto-commit ; false disables auto-commit.
     */
    public void setAutoCommit(boolean autoCommit) throws SDXException;

    /**Can do optimization of a Repository if needed*/
    public void optimize() throws SDXException;

    /**
     * Returns the SQL connection
     */
    public Connection getConnection();

    /**Closes the connectiokbn*/
    public void close() throws SDXException;


}
