/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;

/**
 * Created by IntelliJ IDEA.
 * User: Rasik Pandey
 * Date: 2 fvr. 2004
 * Time: 14:51:22
 * To change this template use Options | File Templates.
 */
public class JDBCDatabase extends AbstractJDBCDatabase {


	/**Not needed*/
	public String getDatabaseDirectoryName() {
		return null;
	}

	/**Not needed*/
	public void optimize() throws SDXException {
	}

	/* (non-Javadoc)
	 * @see fr.gouv.culture.sdx.utils.AbstractSdxObject#initToSax()
	 */
	protected boolean initToSax() {
		this._xmlizable_objects.put("Database_Type","JDBCDatabase");
		this._xmlizable_objects.put("JDBC_Table_Name",this.tableName);
		this._xmlizable_objects.put("Document_Count",String.valueOf(this.size()));
		this._xmlizable_objects.put("Data_Source_Identifier",this.dsi);
		return true;
	}
	
	/**Init the LinkedHashMap _xmlizable_volatile_objects with the objects in order to describ them in XML
	 * Some objects need to be refresh each time a toSAX is called*/
	protected void initVolatileObjectsToSax() {
		this._xmlizable_objects.put("Document_Count",String.valueOf(this.size()));
	}
	
	/** 
	 * @see fr.gouv.culture.sdx.utils.database.AbstractJDBCDatabase#getAllEntitiesWithLimitQuery(long, long)
	 * JDBC implementation
	 * Should not be called
	 */
	protected String getEntriesWithLimitQuery(long offset, long number) {
		String query = "SELECT * FROM " + getTableName() + ";";
		return query;
	}
	
}
