/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ComposerAction;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.i18n.I18nUtils;

public class LocaleAction
extends ComposerAction
implements ThreadSafe,
Configurable {
    public static final String LANG = "lang";
    public static final String COUNTRY = "country";
    public static final String VARIANT = "variant";
    public static final String LOCALE = "locale";
    public static final String LANG_ATTR = "language-attribute";
    public static final String COUNTRY_ATTR = "country-attribute";
    public static final String VARIANT_ATTR = "variant-attribute";
    public static final String LOCALE_ATTR = "locale-attribute";
    public static final String STORE_REQUEST = "store-in-request";
    public static final String CREATE_SESSION = "create-session";
    public static final String STORE_SESSION = "store-in-session";
    public static final String STORE_COOKIE = "store-in-cookie";
    private boolean storeInRequest = false;
    private boolean storeInSession = false;
    private boolean createSession = false;
    private boolean storeInCookie = false;
    private String langAttr;
    private String countryAttr;
    private String variantAttr;
    private String localeAttr;

    public void configure(Configuration conf) throws ConfigurationException {
        if (conf != null) {
            Configuration child = conf.getChild(STORE_REQUEST);
            this.storeInRequest = child.getValueAsBoolean(false);
            this.debug((this.storeInRequest ? "will" : "won't") + " set values in request");
            child = conf.getChild(CREATE_SESSION);
            this.createSession = child.getValueAsBoolean(false);
            this.debug((this.createSession ? "will" : "won't") + " create session");
            child = conf.getChild(STORE_SESSION);
            this.storeInSession = child.getValueAsBoolean(false);
            this.debug((this.storeInSession ? "will" : "won't") + " set values in session");
            child = conf.getChild(STORE_COOKIE);
            this.storeInCookie = child.getValueAsBoolean(false);
            this.debug((this.storeInCookie ? "will" : "won't") + " set values in cookies");
            child = conf.getChild(LANG_ATTR);
            this.langAttr = child.getValue(LANG);
            this.debug("global language attribute name is " + this.langAttr);
            child = conf.getChild(COUNTRY_ATTR);
            this.countryAttr = child.getValue(COUNTRY);
            this.debug("global country attribute name is " + this.countryAttr);
            child = conf.getChild(VARIANT_ATTR);
            this.variantAttr = child.getValue(VARIANT);
            this.debug("global variant attribute name is " + this.variantAttr);
            child = conf.getChild(LOCALE_ATTR);
            this.localeAttr = child.getValue(LOCALE);
            this.debug("global locale attribute name is " + this.localeAttr);
        }
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters par) throws Exception {
        Session session;
        Request request;
        String lc = LocaleAction.getLocaleAttribute(objectModel);
        Locale locale = I18nUtils.parseLocale(lc);
        String l = locale.getLanguage();
        String c = locale.getCountry();
        String v = locale.getVariant();
        this.debug("obtained locale information, locale = " + lc);
        this.debug("language = " + l + ", country = " + c + ", variant = " + v);
        if (this.getLogger().isDebugEnabled()) {
            this.checkParams(par);
        }
        if (this.storeInRequest) {
            request = ObjectModelHelper.getRequest(objectModel);
            request.setAttribute(this.localeAttr, lc);
            this.debug("updated request");
        }
        if (this.storeInSession && (session = (request = ObjectModelHelper.getRequest(objectModel)).getSession(this.createSession)) != null) {
            session.setAttribute(this.localeAttr, lc);
            this.debug("updated session");
        }
        if (this.storeInCookie) {
            Response response = ObjectModelHelper.getResponse(objectModel);
            response.addCookie(response.createCookie(this.localeAttr, lc));
            this.debug("created cookies");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.langAttr, l);
        map.put(this.countryAttr, c);
        map.put(this.variantAttr, v);
        map.put(this.localeAttr, lc);
        this.debug("returning map for XPath substitutions");
        return map;
    }

    public static String getLocaleAttribute(Map objectModel) throws Exception {
        Request request = ObjectModelHelper.getRequest(objectModel);
        String ret_val = request.getParameter(LOCALE);
        if (ret_val != null) {
            return ret_val;
        }
        Session session = request.getSession(false);
        if (session != null && (ret_val = (String)session.getAttribute(LOCALE)) != null) {
            return ret_val;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                Cookie cookie = cookies[i];
                if (cookie.getName().equals(LOCALE)) {
                    return cookie.getValue();
                }
                ++i;
            }
        }
        return request.getLocale().toString();
    }

    private void checkParams(Parameters par) {
        this.langAttr = par.getParameter(LANG_ATTR, this.langAttr);
        this.countryAttr = par.getParameter(COUNTRY_ATTR, this.countryAttr);
        this.variantAttr = par.getParameter(VARIANT_ATTR, this.variantAttr);
        this.localeAttr = par.getParameter(LOCALE_ATTR, this.localeAttr);
        this.storeInRequest = par.getParameterAsBoolean(STORE_REQUEST, this.storeInRequest);
        this.storeInSession = par.getParameterAsBoolean(STORE_SESSION, this.storeInSession);
        this.createSession = par.getParameterAsBoolean(CREATE_SESSION, this.createSession);
        this.storeInCookie = par.getParameterAsBoolean(STORE_COOKIE, this.storeInCookie);
        this.debug("checking for local overrides, language-attribute = " + this.langAttr + ", " + COUNTRY_ATTR + " = " + this.countryAttr + ", " + VARIANT_ATTR + " = " + this.variantAttr + ", " + LOCALE_ATTR + " = " + this.localeAttr + ", " + STORE_REQUEST + " = " + this.storeInRequest + ", " + STORE_SESSION + " = " + this.storeInSession + ", " + CREATE_SESSION + " = " + this.createSession + ", " + STORE_COOKIE + " = " + this.storeInCookie);
    }

    private void debug(String msg) {
        this.getLogger().debug(msg);
    }
}

